/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.jdp.common;

import com.oracle.jmc.jdp.common.Configuration;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ConfigurationFactory {
    public static final InetAddress DEFAULT_MULTICAST_ADDRESS;

    static {
        InetAddress tmp = null;
        try {
            tmp = InetAddress.getByName("224.0.23.178");
        }
        catch (UnknownHostException e) {
            Logger.getLogger("com.oracle.jdp.common").log(Level.SEVERE, "Could not create default mulitcast address!", e);
        }
        DEFAULT_MULTICAST_ADDRESS = tmp;
    }

    public static Configuration createConfiguration() {
        return new Configuration(){

            @Override
            public int getMulticastPort() {
                return 7095;
            }

            @Override
            public InetAddress getMulticastAddress() {
                return DEFAULT_MULTICAST_ADDRESS;
            }

            @Override
            public int getBroadcastPeriod() {
                return 5000;
            }

            @Override
            public short getTTL() {
                return 0;
            }

            @Override
            public int getMaxHeartBeatTimeout() {
                return 12000;
            }
        };
    }
}

