/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.jdp.client;

import com.oracle.jmc.jdp.client.JDPClient;
import com.oracle.jmc.jdp.client.PacketProcessor;
import com.oracle.jmc.jdp.common.JDPPacket;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.util.logging.Level;

final class PacketListener
implements Runnable {
    private static final int BUFFER_LENGTH = 4096;
    private final MulticastSocket socket;
    private final PacketProcessor packetProcessor;
    private volatile boolean shutdown;

    PacketListener(MulticastSocket socket, PacketProcessor packetProcessor) {
        this.socket = socket;
        this.packetProcessor = packetProcessor;
    }

    @Override
    public void run() {
        byte[] buffer = new byte[4096];
        DatagramPacket dgram = new DatagramPacket(buffer, buffer.length);
        while (!this.shutdown) {
            try {
                this.socket.receive(dgram);
            }
            catch (IOException e) {
                if (!this.shutdown) {
                    JDPClient.LOGGER.log(Level.SEVERE, "Problem listening for JDP packets! Shutting down!", e);
                    this.socket.close();
                }
                return;
            }
            byte[] data = new byte[dgram.getLength()];
            System.arraycopy(dgram.getData(), dgram.getOffset(), data, 0, dgram.getLength());
            try {
                JDPPacket packet = new JDPPacket(data);
                this.packetProcessor.process(packet);
            }
            catch (Exception e) {
                JDPClient.LOGGER.log(Level.WARNING, "Could not decode JDP packet. Skipping!", e);
            }
        }
    }

    public void stop() {
        this.shutdown = true;
        this.socket.close();
    }

    public boolean isAlive() {
        return !this.shutdown;
    }
}

