/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.parser.synthetic;

import com.oracle.jmc.common.IMCFrame;
import com.oracle.jmc.common.IMCStackTrace;
import com.oracle.jmc.common.IMCThread;
import com.oracle.jmc.common.item.Attribute;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.unit.ContentType;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.LabeledIdentifier;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.parser.IEventSink;
import com.oracle.jmc.flightrecorder.parser.IEventSinkFactory;
import com.oracle.jmc.flightrecorder.parser.IParserExtension;
import com.oracle.jmc.flightrecorder.parser.ValueField;
import com.oracle.jmc.flightrecorder.parser.synthetic.Messages;
import com.oracle.jmc.flightrecorder.parser.synthetic.SettingsTransformer;
import java.util.Arrays;
import java.util.List;

public class SyntheticAttributeExtension
implements IParserExtension {
    private static final IAttribute<IMCStackTrace> EXECUTION_SAMPLES_STACKTRACE = Attribute.attr((String)"stackTrace", (String)Messages.getString("SyntheticAttributeExtension_EXECUTION_SAMPLES_STACKTRACE"), (ContentType)JfrAttributes.EVENT_STACKTRACE.getContentType());
    private static final IAttribute<IMCThread> EXECUTION_SAMPLES_THREAD = Attribute.attr((String)"sampledThread", (String)Messages.getString("SyntheticAttributeExtension_EXECUTION_SAMPLES_THREAD"), (ContentType)JfrAttributes.EVENT_THREAD.getContentType());
    private static final IAttribute<IMCThread> ALLOC_STATISTICS_THREAD = Attribute.attr((String)"thread", (String)Messages.getString("SyntheticAttributeExtension_ALLOC_STATISTICS_THREAD"), (ContentType)JfrAttributes.EVENT_THREAD.getContentType());
    static final IAttribute<LabeledIdentifier> REC_SETTING_EVENT_ID_ATTRIBUTE = Attribute.attr((String)"id", (String)Messages.getString("SyntheticAttributeExtension_REC_SETTING_EVENT_ID_ATTRIBUTE"), (ContentType)UnitLookup.LABELED_IDENTIFIER);

    @Override
    public IEventSinkFactory getEventSinkFactory(final IEventSinkFactory sf) {
        return SettingsTransformer.wrapSinkFactory(new IEventSinkFactory(){

            @Override
            public IEventSink create(String identifier, String label, String[] category, String description, List<ValueField> dataStructure) {
                if ("com.oracle.jdk.ExecutionSample".equals(identifier)) {
                    ValueField[] struct = new ValueField[dataStructure.size()];
                    int i = 0;
                    while (i < struct.length) {
                        ValueField vf = dataStructure.get(i);
                        if (vf.matches(EXECUTION_SAMPLES_STACKTRACE)) {
                            vf = new ValueField(JfrAttributes.EVENT_STACKTRACE);
                        } else if (vf.matches(EXECUTION_SAMPLES_THREAD)) {
                            vf = new ValueField(JfrAttributes.EVENT_THREAD);
                        }
                        struct[i] = vf;
                        ++i;
                    }
                    dataStructure = Arrays.asList(struct);
                } else if ("com.oracle.jdk.ThreadAllocationStatistics".equals(identifier)) {
                    ValueField[] struct = new ValueField[dataStructure.size()];
                    int i = 0;
                    while (i < struct.length) {
                        ValueField vf = dataStructure.get(i);
                        if (vf.matches(ALLOC_STATISTICS_THREAD)) {
                            vf = new ValueField(JfrAttributes.EVENT_THREAD);
                        }
                        struct[i] = vf;
                        ++i;
                    }
                    dataStructure = Arrays.asList(struct);
                } else if ("com.oracle.jdk.JavaExceptionThrow".equals(identifier)) {
                    int i = 0;
                    while (i < dataStructure.size()) {
                        final int stacktraceIndex = i;
                        if (dataStructure.get(i).matches(JfrAttributes.EVENT_STACKTRACE)) {
                            final IEventSink subSink = sf.create(identifier, label, category, description, dataStructure);
                            return new IEventSink(){

                                @Override
                                public void addEvent(Object ... values) {
                                    IMCStackTrace st = (IMCStackTrace)values[stacktraceIndex];
                                    if (st == null || st.getFrames().size() < 2 || !this.isError((IMCFrame)st.getFrames().get(0)) && !this.isError((IMCFrame)st.getFrames().get(1))) {
                                        subSink.addEvent(values);
                                    }
                                }

                                private boolean isError(IMCFrame frame) {
                                    return frame.getMethod().getType().getFullName().equals("java.lang.Error");
                                }
                            };
                        }
                        ++i;
                    }
                } else if ("com.oracle.jdk.ActiveSetting".equals(identifier)) {
                    ValueField[] struct = new ValueField[dataStructure.size()];
                    int i = 0;
                    while (i < struct.length) {
                        ValueField vf = dataStructure.get(i);
                        if (vf.matches(REC_SETTING_EVENT_ID_ATTRIBUTE)) {
                            vf = new ValueField(JdkAttributes.REC_SETTING_FOR);
                        }
                        struct[i] = vf;
                        ++i;
                    }
                    dataStructure = Arrays.asList(struct);
                }
                return sf.create(identifier, label, category, description, dataStructure);
            }

            @Override
            public void flush() {
                sf.flush();
            }
        });
    }

    @Override
    public String getValueInterpretation(String eventTypeId, String fieldId) {
        if (REC_SETTING_EVENT_ID_ATTRIBUTE.getIdentifier().equals(fieldId) && "http://www.oracle.com/hotspot/jfr-info/recordings/recording_setting".equals(eventTypeId)) {
            return "com.oracle.jmc.flightrecorder.value_interpretation.type_identifier";
        }
        if (REC_SETTING_EVENT_ID_ATTRIBUTE.getIdentifier().equals(fieldId) && "com.oracle.jdk.ActiveSetting".equals(eventTypeId)) {
            return "com.oracle.jmc.flightrecorder.value_interpretation.type_identifier";
        }
        return null;
    }
}

