/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.parser.synthetic;

import com.oracle.jmc.common.item.Attribute;
import com.oracle.jmc.common.item.IAttribute;
import com.oracle.jmc.common.unit.ContentType;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.LabeledIdentifier;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;
import com.oracle.jmc.flightrecorder.parser.IEventSink;
import com.oracle.jmc.flightrecorder.parser.IEventSinkFactory;
import com.oracle.jmc.flightrecorder.parser.ValueField;
import com.oracle.jmc.flightrecorder.parser.synthetic.JdkTypeIDsPreJdk9;
import com.oracle.jmc.flightrecorder.parser.synthetic.Messages;
import com.oracle.jmc.flightrecorder.parser.synthetic.SyntheticAttributeExtension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SettingsTransformer
implements IEventSink {
    static final String REC_SETTING_NAME_ENABLED = "enabled";
    static final String REC_SETTING_NAME_STACKTRACE = "stacktrace";
    static final String REC_SETTING_NAME_THRESHOLD = "threshold";
    static final String REC_SETTING_NAME_PERIOD = "period";
    static final String REC_SETTING_PERIOD_EVERY_CHUNK = "everyChunk";
    private static final IAttribute<Boolean> REC_SETTINGS_ATTR_ENABLED = Attribute.attr((String)"enabled", (String)Messages.getString("SettingsTransformer_REC_SETTINGS_ATTR_ENABLED"), (ContentType)UnitLookup.FLAG);
    private static final IAttribute<Boolean> REC_SETTINGS_ATTR_STACKTRACE = Attribute.attr((String)"stacktrace", (String)Messages.getString("SettingsTransformer_REC_SETTINGS_ATTR_STACKTRACE"), (ContentType)UnitLookup.FLAG);
    static final IAttribute<IQuantity> REC_SETTINGS_ATTR_THRESHOLD = Attribute.attr((String)"threshold", (String)Messages.getString("SettingsTransformer_REC_SETTINGS_ATTR_THRESHOLD"), (ContentType)UnitLookup.TIMESPAN);
    static final IAttribute<IQuantity> REC_SETTINGS_ATTR_PERIOD = Attribute.attr((String)"period", (String)Messages.getString("SettingsTransformer_REC_SETTINGS_ATTR_PERIOD"), (ContentType)UnitLookup.TIMESPAN);
    private static final List<ValueField> FIELDS = Arrays.asList(new ValueField(JfrAttributes.END_TIME), new ValueField(SyntheticAttributeExtension.REC_SETTING_EVENT_ID_ATTRIBUTE), new ValueField(JdkAttributes.REC_SETTING_NAME), new ValueField(JdkAttributes.REC_SETTING_VALUE));
    private static final Map<String, Map<String, String>> attributeRenameMap = SettingsTransformer.buildRenameMap();
    private static final String UNALLOCATED_CAPACITY_FIELD_ID = "unallocatedCapacity";
    private final IEventSink sink;
    private final Object[] reusableArray = new Object[FIELDS.size()];
    private int endTimeIndex = -1;
    private int typeIndex = -1;
    private int enabledIndex = -1;
    private int stacktraceIndex = -1;
    private int thresholdIndex = -1;
    private int periodIndex = -1;

    private static HashMap<String, Map<String, String>> buildRenameMap() {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/java/thread_park", "klass", "parkedClass");
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/java/monitor_enter", "klass", JdkAttributes.MONITOR_CLASS.getIdentifier());
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/java/monitor_wait", "klass", JdkAttributes.MONITOR_CLASS.getIdentifier());
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/vm/flag/int_changed", "old_value", "oldValue");
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/vm/flag/int_changed", "new_value", "newValue");
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/vm/flag/uint_changed", "old_value", "oldValue");
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/vm/flag/uint_changed", "new_value", "newValue");
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/vm/flag/long_changed", "old_value", "oldValue");
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/vm/flag/long_changed", "new_value", "newValue");
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/vm/flag/ulong_changed", "old_value", "oldValue");
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/vm/flag/ulong_changed", "new_value", "newValue");
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/vm/flag/double_changed", "old_value", "oldValue");
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/vm/flag/double_changed", "new_value", "newValue");
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/vm/flag/boolean_changed", "old_value", "oldValue");
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/vm/flag/boolean_changed", "new_value", "newValue");
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/vm/flag/string_changed", "old_value", "oldValue");
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/vm/flag/string_changed", "new_value", "newValue");
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/vm/gc/detailed/evacuation_info", "allocRegionsUsedBefore", "allocationRegionsUsedBefore");
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/vm/gc/detailed/evacuation_info", "allocRegionsUsedAfter", "allocationRegionsUsedAfter");
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/vm/code_sweeper/sweep", "sweepIndex", "sweepId");
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/java/object_alloc_in_new_TLAB", "class", JdkAttributes.ALLOCATION_CLASS.getIdentifier());
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/java/object_alloc_outside_TLAB", "class", JdkAttributes.ALLOCATION_CLASS.getIdentifier());
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/vm/gc/detailed/object_count", "class", JdkAttributes.OBJECT_CLASS.getIdentifier());
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/vm/compiler/phase", "compileID", JdkAttributes.COMPILER_COMPILATION_ID.getIdentifier());
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/vm/compiler/compilation", "compileID", JdkAttributes.COMPILER_COMPILATION_ID.getIdentifier());
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/vm/compiler/failure", "compileID", JdkAttributes.COMPILER_COMPILATION_ID.getIdentifier());
        SettingsTransformer.addRenameEntry(map, "http://www.oracle.com/hotspot/jvm/vm/compiler/failure", "failure", JdkAttributes.COMPILER_FAILED_MESSAGE.getIdentifier());
        return map;
    }

    private static void addRenameEntry(Map<String, Map<String, String>> renameMap, String eventId, String pre9AttrId, String attrId) {
        Map<String, String> attrMap = renameMap.get(eventId);
        if (attrMap == null) {
            attrMap = new HashMap<String, String>();
            renameMap.put(eventId, attrMap);
        }
        attrMap.put(pre9AttrId, attrId);
    }

    SettingsTransformer(IEventSinkFactory sinkFactory, String label, String[] category, String description, List<ValueField> dataStructure) {
        this.sink = sinkFactory.create("com.oracle.jdk.ActiveSetting", label, category, description, FIELDS);
        int i = 0;
        while (i < dataStructure.size()) {
            ValueField vf = dataStructure.get(i);
            if (vf.matches(JfrAttributes.END_TIME)) {
                this.endTimeIndex = i;
            } else if (vf.matches(SyntheticAttributeExtension.REC_SETTING_EVENT_ID_ATTRIBUTE)) {
                this.typeIndex = i;
            } else if (vf.matches(REC_SETTINGS_ATTR_ENABLED)) {
                this.enabledIndex = i;
            } else if (vf.matches(REC_SETTINGS_ATTR_STACKTRACE)) {
                this.stacktraceIndex = i;
            } else if (vf.matches(REC_SETTINGS_ATTR_THRESHOLD)) {
                this.thresholdIndex = i;
            } else if (vf.matches(REC_SETTINGS_ATTR_PERIOD)) {
                this.periodIndex = i;
            }
            ++i;
        }
    }

    boolean isValid() {
        return this.endTimeIndex >= 0 && this.typeIndex >= 0 && this.enabledIndex >= 0 && this.stacktraceIndex >= 0 && this.thresholdIndex >= 0 && this.periodIndex >= 0;
    }

    @Override
    public void addEvent(Object ... values) {
        LabeledIdentifier type = (LabeledIdentifier)values[this.typeIndex];
        if (type != null) {
            type = new LabeledIdentifier(JdkTypeIDsPreJdk9.translate(type.getInterfaceId()), type.getImplementationId(), type.getName(), type.getDeclaredDescription());
        }
        Object startTime = values[this.endTimeIndex];
        this.addSettingEvent(startTime, type, REC_SETTING_NAME_ENABLED, values[this.enabledIndex]);
        this.addSettingEvent(startTime, type, REC_SETTING_NAME_STACKTRACE, values[this.stacktraceIndex]);
        this.addThresholdSettingEvent(startTime, type, (IQuantity)values[this.thresholdIndex]);
        this.addPeriodSettingEvent(startTime, type, (IQuantity)values[this.periodIndex]);
    }

    private boolean addThresholdSettingEvent(Object startTime, LabeledIdentifier type, IQuantity quantity) {
        long numQuantity;
        if (quantity != null && (numQuantity = quantity.longValue()) != Long.MIN_VALUE && numQuantity != Long.MAX_VALUE) {
            this.addSettingEvent(startTime, type, REC_SETTING_NAME_THRESHOLD, quantity.persistableString());
        }
        return false;
    }

    private boolean addPeriodSettingEvent(Object startTime, LabeledIdentifier type, IQuantity quantity) {
        if (quantity != null) {
            long numQuantity = quantity.longValue();
            if (numQuantity == 0L) {
                this.addSettingEvent(startTime, type, REC_SETTING_NAME_PERIOD, REC_SETTING_PERIOD_EVERY_CHUNK);
            } else if (numQuantity != Long.MIN_VALUE && numQuantity != Long.MAX_VALUE) {
                this.addSettingEvent(startTime, type, REC_SETTING_NAME_PERIOD, quantity.persistableString());
            }
        }
        return false;
    }

    private void addSettingEvent(Object startTime, LabeledIdentifier type, String settingName, Object settingValue) {
        this.reusableArray[0] = startTime;
        this.reusableArray[1] = type;
        this.reusableArray[2] = settingName;
        this.reusableArray[3] = settingValue == null ? null : settingValue.toString();
        this.sink.addEvent(this.reusableArray);
    }

    static IEventSinkFactory wrapSinkFactory(final IEventSinkFactory subFactory) {
        return new IEventSinkFactory(){

            @Override
            public IEventSink create(String identifier, String label, String[] category, String description, List<ValueField> dataStructure) {
                if ("http://www.oracle.com/hotspot/jfr-info/recordings/recording_setting".equals(identifier)) {
                    SettingsTransformer st = new SettingsTransformer(subFactory, label, category, description, dataStructure);
                    if (st.isValid()) {
                        return st;
                    }
                    System.err.println("Cannot create SettingsTransformer from fields: " + dataStructure.toString());
                } else {
                    if ("http://www.oracle.com/hotspot/jfr-info/recordings/recording".equals(identifier)) {
                        ValueField[] struct = new ValueField[dataStructure.size()];
                        int i = 0;
                        while (i < struct.length) {
                            ValueField vf = dataStructure.get(i);
                            if (vf.matches(JfrAttributes.START_TIME)) {
                                vf = new ValueField(JdkAttributes.RECORDING_START);
                            } else if (vf.matches(JfrAttributes.DURATION)) {
                                vf = new ValueField(JdkAttributes.RECORDING_DURATION);
                            }
                            struct[i] = vf;
                            ++i;
                        }
                        return subFactory.create("com.oracle.jdk.ActiveRecording", label, category, description, Arrays.asList(struct));
                    }
                    if ("http://www.oracle.com/hotspot/jvm/vm/code_cache/stats".equals(identifier)) {
                        int i = 0;
                        while (i < dataStructure.size()) {
                            if (SettingsTransformer.UNALLOCATED_CAPACITY_FIELD_ID.equals(dataStructure.get(i).getIdentifier())) {
                                return new FixCodeCacheSink(i, subFactory.create(JdkTypeIDsPreJdk9.translate(identifier), label, category, description, dataStructure));
                            }
                            ++i;
                        }
                    }
                }
                return subFactory.create(JdkTypeIDsPreJdk9.translate(identifier), label, category, description, this.translate(identifier, dataStructure));
            }

            private List<ValueField> translate(String identifier, List<ValueField> dataStructure) {
                Map attrMap = (Map)attributeRenameMap.get(identifier);
                if (attrMap == null) {
                    return dataStructure;
                }
                ArrayList<ValueField> renamedDataStructure = new ArrayList<ValueField>();
                for (ValueField vf : dataStructure) {
                    String renamedId = (String)attrMap.get(vf.getIdentifier());
                    if (renamedId == null) {
                        renamedDataStructure.add(vf);
                        continue;
                    }
                    renamedDataStructure.add(new ValueField(renamedId, vf.getName(), vf.getDescription(), vf.getContentType()));
                }
                return renamedDataStructure;
            }

            @Override
            public void flush() {
                subFactory.flush();
            }
        };
    }

    private static class FixCodeCacheSink
    implements IEventSink {
        private int unallocatedFieldIndex;
        private IEventSink subSink;

        public FixCodeCacheSink(int unallocatedFieldIndex, IEventSink subSink) {
            this.unallocatedFieldIndex = unallocatedFieldIndex;
            this.subSink = subSink;
        }

        @Override
        public void addEvent(Object ... values) {
            if (values[this.unallocatedFieldIndex] instanceof IQuantity) {
                values[this.unallocatedFieldIndex] = ((IQuantity)values[this.unallocatedFieldIndex]).multiply(1024L);
            }
            this.subSink.addEvent(values);
        }
    }
}

