/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.jdk;

import com.oracle.jmc.common.IMCFrame;
import com.oracle.jmc.common.IMCMethod;
import com.oracle.jmc.common.IMCStackTrace;
import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.IPredicate;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.item.ItemFilters;
import com.oracle.jmc.common.util.PredicateToolkit;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.jdk.JdkAttributes;

public final class JdkFilters {
    public static final IItemFilter SOCKET_READ = ItemFilters.type((String)"com.oracle.jdk.SocketRead");
    public static final IItemFilter SOCKET_WRITE = ItemFilters.type((String)"com.oracle.jdk.SocketWrite");
    public static final IItemFilter SOCKET_READ_OR_WRITE = ItemFilters.or((IItemFilter[])new IItemFilter[]{SOCKET_READ, SOCKET_WRITE});
    public static final IItemFilter NO_RMI_SOCKET_READ = ItemFilters.and((IItemFilter[])new IItemFilter[]{SOCKET_READ, ItemFilters.not((IItemFilter)new MethodFilter("sun.rmi.transport.tcp.TCPTransport", "handleMessages")), ItemFilters.not((IItemFilter)new MethodFilter("javax.management.remote.rmi.RMIConnector$RMINotifClient", "fetchNotifs"))});
    public static final IItemFilter NO_RMI_SOCKET_WRITE = ItemFilters.and((IItemFilter[])new IItemFilter[]{SOCKET_WRITE, ItemFilters.not((IItemFilter)new MethodFilter("sun.rmi.transport.tcp.TCPTransport$ConnectionHandler", "run")), ItemFilters.not((IItemFilter)new MethodFilter("sun.rmi.transport.tcp.TCPTransport$ConnectionHandler", "run0"))});
    public static final IItemFilter ENVIRONMENT_VARIABLE = ItemFilters.type((String)"com.oracle.jdk.InitialEnvironmentVariable");
    public static final IItemFilter FILE_READ = ItemFilters.type((String)"com.oracle.jdk.FileRead");
    public static final IItemFilter FILE_WRITE = ItemFilters.type((String)"com.oracle.jdk.FileWrite");
    public static final IItemFilter CODE_CACHE_FULL = ItemFilters.type((String)"com.oracle.jdk.CodeCacheFull");
    public static final IItemFilter CODE_CACHE_STATISTICS = ItemFilters.type((String)"com.oracle.jdk.CodeCacheStatistics");
    public static final IItemFilter CODE_CACHE_CONFIGURATION = ItemFilters.type((String)"com.oracle.jdk.CodeCacheConfiguration");
    public static final IItemFilter SWEEP_CODE_CACHE = ItemFilters.type((String)"com.oracle.jdk.SweepCodeCache");
    public static final IItemFilter CODE_CACHE = ItemFilters.or((IItemFilter[])new IItemFilter[]{CODE_CACHE_FULL, CODE_CACHE_STATISTICS, SWEEP_CODE_CACHE, CODE_CACHE_CONFIGURATION});
    public static final IItemFilter CPU_INFORMATION = ItemFilters.type((String)"com.oracle.jdk.CPUInformation");
    public static final IItemFilter GC_CONFIG = ItemFilters.type((String)"com.oracle.jdk.GCConfiguration");
    public static final IItemFilter HEAP_CONFIG = ItemFilters.type((String)"com.oracle.jdk.GCHeapConfiguration");
    public static final IItemFilter BEFORE_GC = ItemFilters.equals(JdkAttributes.GC_WHEN, (Object)"Before GC");
    public static final IItemFilter AFTER_GC = ItemFilters.equals(JdkAttributes.GC_WHEN, (Object)"After GC");
    public static final IItemFilter ALLOC_OUTSIDE_TLAB = ItemFilters.type((String)"com.oracle.jdk.ObjectAllocationOutsideTLAB");
    public static final IItemFilter ALLOC_INSIDE_TLAB = ItemFilters.type((String)"com.oracle.jdk.ObjectAllocationInNewTLAB");
    public static final IItemFilter ALLOC_ALL = ItemFilters.type((String[])new String[]{"com.oracle.jdk.ObjectAllocationInNewTLAB", "com.oracle.jdk.ObjectAllocationOutsideTLAB"});
    public static final IItemFilter REFERENCE_STATISTICS = ItemFilters.type((String)"com.oracle.jdk.GCReferenceStatistics");
    public static final IItemFilter GARBAGE_COLLECTION = ItemFilters.type((String)"com.oracle.jdk.GarbageCollection");
    public static final IItemFilter CONCURRENT_MODE_FAILURE = ItemFilters.type((String)"com.oracle.jdk.ConcurrentModeFailure");
    public static final IItemFilter ERRORS = ItemFilters.type((String)"com.oracle.jdk.JavaErrorThrow");
    public static final IItemFilter EXCEPTIONS = ItemFilters.type((String)"com.oracle.jdk.JavaExceptionThrow");
    public static final IItemFilter THROWABLES = ItemFilters.or((IItemFilter[])new IItemFilter[]{EXCEPTIONS, ERRORS});
    public static final IItemFilter THROWABLES_STATISTICS = ItemFilters.type((String)"com.oracle.jdk.ExceptionStatistics");
    public static final IItemFilter CLASS_UNLOAD = ItemFilters.type((String)"com.oracle.jdk.ClassUnload");
    public static final IItemFilter CLASS_LOAD_STATISTICS = ItemFilters.type((String)"com.oracle.jdk.ClassLoadingStatistics");
    public static final IItemFilter CLASS_LOAD = ItemFilters.type((String)"com.oracle.jdk.ClassLoad");
    public static final IItemFilter CLASS_LOAD_OR_UNLOAD = ItemFilters.or((IItemFilter[])new IItemFilter[]{CLASS_LOAD, CLASS_UNLOAD});
    public static final IItemFilter MONITOR_ENTER = ItemFilters.type((String)"com.oracle.jdk.JavaMonitorEnter");
    public static final IItemFilter FILE_OR_SOCKET_IO = ItemFilters.type((String[])new String[]{"com.oracle.jdk.SocketRead", "com.oracle.jdk.SocketWrite", "com.oracle.jdk.FileRead", "com.oracle.jdk.FileWrite"});
    public static final IItemFilter THREAD_LATENCIES = ItemFilters.type((String[])new String[]{"com.oracle.jdk.JavaMonitorEnter", "com.oracle.jdk.JavaMonitorWait", "com.oracle.jdk.ThreadSleep", "com.oracle.jdk.ThreadPark", "com.oracle.jdk.SocketRead", "com.oracle.jdk.SocketWrite", "com.oracle.jdk.FileRead", "com.oracle.jdk.FileWrite", "com.oracle.jdk.ClassLoad", "com.oracle.jdk.Compilation", "com.oracle.jdk.ExecutionSampling"});
    public static final IItemFilter EXECUTION_SAMPLE = ItemFilters.type((String)"com.oracle.jdk.ExecutionSample");
    public static final IItemFilter CPU_LOAD = ItemFilters.type((String)"com.oracle.jdk.CPULoad");
    public static final IItemFilter GC_PAUSE = ItemFilters.type((String)"com.oracle.jdk.GCPhasePause");
    public static final IItemFilter GC_PAUSE_PHASE = ItemFilters.type((String[])new String[]{"com.oracle.jdk.GCPhasePauseLevel1", "com.oracle.jdk.GCPhasePauseLevel2", "com.oracle.jdk.GCPhasePauseLevel3"});
    public static final IItemFilter TIME_CONVERSION = ItemFilters.type((String)"com.oracle.jdk.CPUTimeStampCounter");
    public static final IItemFilter VM_INFO = ItemFilters.type((String)"com.oracle.jdk.JVMInformation");
    public static final IItemFilter THREAD_DUMP = ItemFilters.type((String)"com.oracle.jdk.ThreadDump");
    public static final IItemFilter SYSTEM_PROPERTIES = ItemFilters.type((String)"com.oracle.jdk.InitialSystemProperty");
    public static final IItemFilter JFR_DATA_LOST = ItemFilters.type((String)"com.oracle.jdk.DataLoss");
    public static final IItemFilter PROCESSES = ItemFilters.type((String)"com.oracle.jdk.SystemProcess");
    public static final IItemFilter OBJECT_COUNT = ItemFilters.type((String)"com.oracle.jdk.ObjectCount");
    public static final IItemFilter METASPACE_OOM = ItemFilters.type((String)"com.oracle.jdk.MetaspaceOOM");
    public static final IItemFilter COMPILATION = ItemFilters.type((String)"com.oracle.jdk.Compilation");
    public static final IItemFilter COMPILER_FAILURE = ItemFilters.type((String)"com.oracle.jdk.CompilationFailure");
    public static final IItemFilter COMPILER_STATS = ItemFilters.type((String)"com.oracle.jdk.CompilerStatistics");
    public static final IItemFilter OS_MEMORY_SUMMARY = ItemFilters.type((String)"com.oracle.jdk.PhysicalMemory");
    public static final IItemFilter HEAP_SUMMARY = ItemFilters.type((String)"com.oracle.jdk.GCHeapSummary");
    public static final IItemFilter HEAP_SUMMARY_AFTER_GC = ItemFilters.and((IItemFilter[])new IItemFilter[]{HEAP_SUMMARY, AFTER_GC});
    public static final IItemFilter METASPACE_SUMMARY = ItemFilters.type((String)"com.oracle.jdk.MetaspaceSummary");
    public static final IItemFilter METASPACE_SUMMARY_AFTER_GC = ItemFilters.and((IItemFilter[])new IItemFilter[]{METASPACE_SUMMARY, AFTER_GC});
    public static final IItemFilter RECORDINGS = ItemFilters.type((String)"com.oracle.jdk.ActiveRecording");
    public static final IItemFilter RECORDING_SETTING = ItemFilters.type((String)"com.oracle.jdk.ActiveSetting");
    public static final IItemFilter SAFE_POINTS = ItemFilters.type((String[])new String[]{"com.oracle.jdk.SafepointBegin", "com.oracle.jdk.SafepointCleanup", "com.oracle.jdk.SafepointCleanupTask", "com.oracle.jdk.SafepointStateSynchronization", "com.oracle.jdk.SafepointWaitBlocked", "com.oracle.jdk.SafepointEnd"});
    public static final IItemFilter VM_OPERATIONS = ItemFilters.type((String)"com.oracle.jdk.ExecuteVMOperation");
    public static final IItemFilter VM_OPERATIONS_BLOCKING_OR_SAFEPOINT = ItemFilters.and((IItemFilter[])new IItemFilter[]{ItemFilters.type((String)"com.oracle.jdk.ExecuteVMOperation"), ItemFilters.or((IItemFilter[])new IItemFilter[]{ItemFilters.equals(JdkAttributes.BLOCKING, (Object)true), ItemFilters.equals(JdkAttributes.SAFEPOINT, (Object)true)})});

    private static class MethodFilter
    implements IItemFilter {
        private final String typeName;
        private final String methodName;

        public MethodFilter(String typeName, String methodName) {
            this.typeName = typeName;
            this.methodName = methodName;
        }

        public IPredicate<IItem> getPredicate(IType<IItem> type) {
            final IMemberAccessor accessor = JfrAttributes.EVENT_STACKTRACE.getAccessor(type);
            if (accessor == null) {
                return PredicateToolkit.falsePredicate();
            }
            return new IPredicate<IItem>(){

                public boolean evaluate(IItem o) {
                    IMCStackTrace st = (IMCStackTrace)accessor.getMember((Object)o);
                    if (st != null) {
                        for (IMCFrame frame : st.getFrames()) {
                            IMCMethod method = frame.getMethod();
                            if (!MethodFilter.this.typeName.equals(method.getType().getFullName()) || !MethodFilter.this.methodName.equals(method.getMethodName())) continue;
                            return true;
                        }
                    }
                    return false;
                }
            };
        }
    }
}

