/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.util;

import com.oracle.jmc.common.IMCFrame;
import com.oracle.jmc.flightrecorder.internal.InvalidJfrFileException;
import java.util.Objects;

public final class ParserToolkit {
    private ParserToolkit() {
        throw new Error("Don't");
    }

    public static <T> T get(T[] elements, int index) throws InvalidJfrFileException {
        if (index < 0 || index >= elements.length) {
            throw new InvalidJfrFileException();
        }
        return elements[index];
    }

    public static void assertValue(long value, long accepted) throws InvalidJfrFileException {
        if (value != accepted) {
            throw new InvalidJfrFileException(String.valueOf(value) + " is not the expected value " + accepted);
        }
    }

    public static void assertValue(Object value, Object accepted) throws InvalidJfrFileException {
        if (!Objects.equals(value, accepted)) {
            throw new InvalidJfrFileException(value + " is not the expected value " + accepted);
        }
    }

    public static void assertValue(Object value, Object ... accepted) throws InvalidJfrFileException {
        Object[] objectArray = accepted;
        int n = accepted.length;
        int n2 = 0;
        while (n2 < n) {
            Object a = objectArray[n2];
            if (Objects.equals(a, value)) {
                return;
            }
            ++n2;
        }
        throw new InvalidJfrFileException(value + " is not among the expected values");
    }

    public static IMCFrame.Type parseFrameType(String type) {
        if ("Interpreted".equals(type)) {
            return IMCFrame.Type.INTERPRETED;
        }
        if ("JIT compiled".equals(type)) {
            return IMCFrame.Type.JIT_COMPILED;
        }
        if ("Inlined".equals(type)) {
            return IMCFrame.Type.INLINED;
        }
        return IMCFrame.Type.UNKNOWN;
    }
}

