/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.util;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.unit.IQuantity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

public class DisjointBuilder<T> {
    private static final IMemberAccessor<IQuantity, DisjointArray<?>> DA_START = new IMemberAccessor<IQuantity, DisjointArray<?>>(){

        public IQuantity getMember(DisjointArray<?> inObject) {
            return inObject.start;
        }
    };
    private static final IMemberAccessor<IQuantity, DisjointArray<?>> DA_END = new IMemberAccessor<IQuantity, DisjointArray<?>>(){

        public IQuantity getMember(DisjointArray<?> inObject) {
            return inObject.end;
        }
    };
    private int noLanes = 0;
    private DisjointArray<T>[] lanes = new DisjointArray[1];
    private final IMemberAccessor<IQuantity, ? super T> startAccessor;
    private final IMemberAccessor<IQuantity, ? super T> endAccessor;

    public DisjointBuilder(IMemberAccessor<IQuantity, ? super T> startAccessor, IMemberAccessor<IQuantity, ? super T> endAccessor) {
        this.startAccessor = startAccessor;
        this.endAccessor = endAccessor;
    }

    public void add(T e) {
        IQuantity start = (IQuantity)this.startAccessor.getMember(e);
        IQuantity end = (IQuantity)this.endAccessor.getMember(e);
        if (this.noLanes == 0) {
            this.addToNewLane(e, start, end);
        } else if (!this.lanes[0].accept(e, start, end)) {
            int changedLane = this.addToOtherLane(e, start, end);
            this.sortLanes(changedLane);
        }
    }

    private void sortLanes(int fromIndex) {
        int i = fromIndex;
        while (i > 0) {
            if (this.lanes[i].end.compareTo((Object)this.lanes[i - 1].end) > 0) {
                DisjointArray<T> tmp = this.lanes[i - 1];
                this.lanes[i - 1] = this.lanes[i];
                this.lanes[i] = tmp;
            }
            --i;
        }
    }

    private int addToOtherLane(T e, IQuantity start, IQuantity end) {
        int i = 1;
        while (i < this.noLanes) {
            if (this.lanes[i].accept(e, start, end)) {
                return i;
            }
            ++i;
        }
        return this.addToNewLane(e, start, end);
    }

    private int addToNewLane(T e, IQuantity start, IQuantity end) {
        if (this.noLanes >= this.lanes.length) {
            this.lanes = Arrays.copyOf(this.lanes, this.lanes.length * 3 / 2 + 2);
        }
        this.lanes[this.noLanes] = new DisjointArray<T>(e, start, end);
        return this.noLanes++;
    }

    public static <U> Collection<U[]> toArrays(Iterable<? extends DisjointBuilder<U>> collections, ArrayFactory<U> arrayFactory) {
        ArrayList allLanes = new ArrayList();
        for (DisjointBuilder<U> c : collections) {
            int i = 0;
            while (i < c.noLanes) {
                allLanes.add(c.lanes[i]);
                ++i;
            }
        }
        if (allLanes.size() == 0) {
            return Collections.emptyList();
        }
        Collections.sort(allLanes, new Comparator<DisjointArray<?>>(){

            @Override
            public int compare(DisjointArray<?> o1, DisjointArray<?> o2) {
                return o1.end.compareTo((Object)o2.end);
            }
        });
        DisjointBuilder lanesCombiner = new DisjointBuilder(DA_START, DA_END);
        for (DisjointArray disjointArray : allLanes) {
            lanesCombiner.add(disjointArray);
        }
        ArrayList<U[]> arrayList = new ArrayList<U[]>(lanesCombiner.noLanes);
        int i = 0;
        while (i < lanesCombiner.noLanes) {
            DisjointArray laneOfLanes = lanesCombiner.lanes[i];
            int totalSize = 0;
            int j = 0;
            while (j < laneOfLanes.size) {
                DisjointArray lane = (DisjointArray)laneOfLanes.getElement(j);
                totalSize += lane.size;
                ++j;
            }
            U[] resultArray = arrayFactory.createArray(totalSize);
            int offset = 0;
            int j2 = 0;
            while (j2 < laneOfLanes.size) {
                DisjointArray lane = (DisjointArray)laneOfLanes.getElement(j2);
                System.arraycopy(lane.array, 0, resultArray, offset, lane.size);
                offset += lane.size;
                ++j2;
            }
            arrayList.add(resultArray);
            ++i;
        }
        return arrayList;
    }

    public static interface ArrayFactory<U> {
        public U[] createArray(int var1);
    }

    private static class DisjointArray<T> {
        private Object[] array = new Object[3];
        final IQuantity start;
        IQuantity end;
        int size = 0;

        DisjointArray(T e, IQuantity start, IQuantity end) {
            this.start = start;
            this.end = end;
            this.array[this.size++] = e;
        }

        boolean accept(T e, IQuantity start, IQuantity end) {
            if (this.size >= this.array.length) {
                int newCapacity = this.array.length < 100 ? this.array.length * 4 : this.array.length * 3 / 2 + 1;
                this.array = Arrays.copyOf(this.array, newCapacity);
            }
            if (start.compareTo((Object)this.end) >= 0) {
                this.array[this.size++] = e;
                this.end = end;
                return true;
            }
            return false;
        }

        private T getElement(int index) {
            Object t = this.array[index];
            return (T)t;
        }
    }
}

