/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.parser.v1;

import com.oracle.jmc.common.collection.FastAccessNumberMap;
import com.oracle.jmc.common.unit.ContentType;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.StructContentType;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.LabeledIdentifier;
import com.oracle.jmc.flightrecorder.internal.InvalidJfrFileException;
import com.oracle.jmc.flightrecorder.internal.parser.LoaderContext;
import com.oracle.jmc.flightrecorder.internal.parser.v1.ChunkMetadata;
import com.oracle.jmc.flightrecorder.internal.parser.v1.ChunkStructure;
import com.oracle.jmc.flightrecorder.internal.parser.v1.IDataInput;
import com.oracle.jmc.flightrecorder.internal.parser.v1.StructTypes;
import com.oracle.jmc.flightrecorder.internal.parser.v1.ValueReaders;
import com.oracle.jmc.flightrecorder.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.parser.IEventSink;
import com.oracle.jmc.flightrecorder.parser.ValueField;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class TypeManager {
    private static final Map<Long, StructContentType<Object[]>> STRUCT_TYPES = new HashMap<Long, StructContentType<Object[]>>();
    private final FastAccessNumberMap<TypeEntry> otherTypes = new FastAccessNumberMap();
    private final FastAccessNumberMap<EventTypeEntry> eventTypes = new FastAccessNumberMap();
    private final ChunkStructure header;

    TypeManager(List<ChunkMetadata.ClassElement> classList, LoaderContext context, ChunkStructure header) throws InvalidJfrFileException, IOException {
        this.header = header;
        ChunkMetadata.ClassElement stringConstantElement = null;
        for (ChunkMetadata.ClassElement classElement : classList) {
            if (classElement.isEventType()) {
                this.eventTypes.put(classElement.classId, (Object)new EventTypeEntry(classElement));
                continue;
            }
            this.otherTypes.put(classElement.classId, (Object)new TypeEntry(classElement));
            if (!"com.oracle.jfr.types.StringConstant".equals(classElement.typeIdentifier)) continue;
            stringConstantElement = classElement;
        }
        if (stringConstantElement != null && stringConstantElement.getFieldCount() > 0) {
            TypeEntry typeEntry = (TypeEntry)this.otherTypes.get(stringConstantElement.fields.get((int)0).classId);
            this.otherTypes.put(stringConstantElement.classId, (Object)new TypeEntry(stringConstantElement, typeEntry.constants));
        }
        for (ChunkMetadata.ClassElement classElement : classList) {
            this.resolveAnnotations(classElement);
            int i = 0;
            while (i < classElement.getFieldCount()) {
                this.resolveAnnotations(classElement.fields.get(i));
                ++i;
            }
        }
        for (EventTypeEntry eventTypeEntry : this.eventTypes) {
            eventTypeEntry.init(context);
        }
    }

    void readEvent(long typeId, IDataInput input) throws InvalidJfrFileException, IOException {
        EventTypeEntry entry = (EventTypeEntry)this.eventTypes.get(typeId);
        if (entry == null) {
            throw new InvalidJfrFileException("Event type with id " + typeId + " was not declared");
        }
        entry.readEvent(input);
    }

    void readConstants(long typeId, IDataInput input, int constantCount) throws InvalidJfrFileException, IOException {
        TypeEntry entry = this.getTypeEntry(typeId);
        int j = 0;
        while (j < constantCount) {
            entry.readConstant(input);
            ++j;
        }
    }

    void resolveConstants() throws InvalidJfrFileException {
        for (TypeEntry classEntry : this.otherTypes) {
            classEntry.resolveConstants();
        }
    }

    private TypeEntry getTypeEntry(long typeId) throws InvalidJfrFileException {
        TypeEntry entry = (TypeEntry)this.otherTypes.get(typeId);
        if (entry == null) {
            throw new InvalidJfrFileException("Class with id " + typeId + " was not declared");
        }
        return entry;
    }

    private void resolveAnnotations(ChunkMetadata.AnnotatedElement ae) throws InvalidJfrFileException {
        if (ae.annotations != null) {
            for (ChunkMetadata.AnnotationElement a : ae.annotations) {
                ChunkMetadata.ClassElement annotationType = this.getTypeEntry((long)a.classId).element;
                ae.resolveAnnotation(annotationType.typeIdentifier, a.values);
            }
        }
    }

    private ValueReaders.IValueReader createFieldReader(ChunkMetadata.FieldElement f, String valueType) throws InvalidJfrFileException {
        TypeEntry fieldType = this.getTypeEntry(f.classId);
        String typeIdentifier = fieldType.element.typeIdentifier;
        boolean isNumeric = ValueReaders.PrimitiveReader.isNumeric(typeIdentifier);
        ValueReaders.IValueReader reader = fieldType.getReader();
        if (f.ticksUnitKind == UnitLookup.TIMESPAN) {
            reader = new ValueReaders.QuantityReader(typeIdentifier, (IUnit)this.header.getTicksTimespanUnit(), f.unsigned);
        } else if (f.ticksUnitKind == UnitLookup.TIMESTAMP) {
            reader = new ValueReaders.TicksTimestampReader(typeIdentifier, this.header, f.unsigned);
        } else if (f.unit != null) {
            reader = new ValueReaders.QuantityReader(typeIdentifier, f.unit, f.unsigned);
        } else if (isNumeric) {
            IUnit unit;
            reader = "com.oracle.jmc.flightrecorder.value_interpretation.type_identifier".equals(valueType) ? new TypeIdentifierReader(typeIdentifier, f.unsigned) : new ValueReaders.QuantityReader(typeIdentifier, (IUnit)((unit = UnitLookup.getUnitOrNull((String)valueType)) == null ? UnitLookup.NUMBER_UNITY : unit), f.unsigned);
        }
        if (f.isStoredInPool()) {
            if (isNumeric) {
                throw new InvalidJfrFileException("Numerics should not be put in constant pools");
            }
            reader = new ValueReaders.PoolReader(fieldType.constants, reader.getContentType());
        }
        return f.isArray() ? new ValueReaders.ArrayReader(reader) : reader;
    }

    private static String buildLabel(String id, ChunkMetadata.AnnotatedElement element) {
        String labelOrId = element.label == null ? id : element.label;
        return element.experimental ? MessageFormat.format(Messages.getString("TypeManager_EXPERIMENTAL_TYPE"), labelOrId) : labelOrId;
    }

    private class EventTypeEntry {
        private final ChunkMetadata.ClassElement element;
        private final List<ValueReaders.IValueReader> valueReaders;
        private Object[] reusableStruct;
        private IEventSink eventSink;
        private LabeledIdentifier eventType;

        EventTypeEntry(ChunkMetadata.ClassElement element) {
            this.element = element;
            this.valueReaders = new ArrayList<ValueReaders.IValueReader>(element.getFieldCount());
        }

        void readEvent(IDataInput input) throws InvalidJfrFileException, IOException {
            int i = 0;
            while (i < this.valueReaders.size()) {
                this.reusableStruct[i] = this.valueReaders.get(i).read(input, false);
                ++i;
            }
            this.eventSink.addEvent(this.reusableStruct);
        }

        LabeledIdentifier getValueType() {
            if (this.eventType == null) {
                this.eventType = new LabeledIdentifier(this.element.typeIdentifier, this.element.classId, this.element.label, this.element.description);
            }
            return this.eventType;
        }

        void init(LoaderContext context) throws InvalidJfrFileException, IOException {
            if (context.hideExperimentals() && this.element.experimental) {
                this.eventSink = new NopEventSink();
            } else {
                ArrayList<ValueField> fieldsList = new ArrayList<ValueField>();
                ArrayList<Integer> skipFields = new ArrayList<Integer>();
                int i = 0;
                while (i < this.element.getFieldCount()) {
                    ChunkMetadata.FieldElement fe = this.element.fields.get(i);
                    String valueType = context.getValueInterpretation(this.element.typeIdentifier, fe.fieldIdentifier);
                    ValueReaders.IValueReader reader = TypeManager.this.createFieldReader(fe, valueType);
                    String fieldLabel = TypeManager.buildLabel(fe.fieldIdentifier, fe);
                    if (context.hideExperimentals() && fe.experimental) {
                        this.valueReaders.add(reader);
                        skipFields.add(i);
                    } else if (reader instanceof ValueReaders.StructReader) {
                        ChunkMetadata.ClassElement fieldType = ((TypeManager)TypeManager.this).getTypeEntry((long)fe.classId).element;
                        int j = 0;
                        while (j < fieldType.getFieldCount()) {
                            ChunkMetadata.FieldElement nestedField = fieldType.fields.get(j);
                            String nestedId = String.valueOf(fe.fieldIdentifier) + ":" + nestedField.fieldIdentifier;
                            String nestedValueType = context.getValueInterpretation(this.element.typeIdentifier, nestedId);
                            ValueReaders.IValueReader nestedReader = TypeManager.this.createFieldReader(nestedField, nestedValueType);
                            this.valueReaders.add(nestedReader);
                            String nestedLabel = String.valueOf(fieldLabel) + " : " + (nestedField.label == null ? nestedField.fieldIdentifier : nestedField.label);
                            fieldsList.add(new ValueField(nestedId, nestedLabel, nestedField.description, nestedReader.getContentType()));
                            ++j;
                        }
                    } else {
                        this.valueReaders.add(reader);
                        fieldsList.add(new ValueField(fe.fieldIdentifier, fieldLabel, fe.description, reader.getContentType()));
                    }
                    ++i;
                }
                String typeLabel = TypeManager.buildLabel(this.element.typeIdentifier, this.element);
                this.eventSink = context.getSinkFactory().create(this.element.typeIdentifier, typeLabel, this.element.category, this.element.description, fieldsList);
                this.reusableStruct = new Object[this.valueReaders.size()];
                if (skipFields.size() > 0) {
                    this.eventSink = new SkipFieldsEventSink(this.eventSink, skipFields, this.reusableStruct.length);
                }
            }
        }
    }

    private static class NopEventSink
    implements IEventSink {
        private NopEventSink() {
        }

        @Override
        public void addEvent(Object ... values) {
        }
    }

    private static class SkipFieldsEventSink
    implements IEventSink {
        private final IEventSink subSink;
        private final List<Integer> skipFields;
        private final Object[] reusableStruct;

        SkipFieldsEventSink(IEventSink subSink, List<Integer> skipFields, int fieldCount) {
            this.subSink = subSink;
            this.skipFields = skipFields;
            this.reusableStruct = new Object[fieldCount - skipFields.size()];
        }

        @Override
        public void addEvent(Object ... fieldValues) {
            Iterator<Integer> skipIter = this.skipFields.iterator();
            int skipNext = skipIter.next();
            int j = 0;
            int i = 0;
            while (i < fieldValues.length) {
                if (i != skipNext) {
                    this.reusableStruct[j++] = fieldValues[i];
                } else if (skipIter.hasNext()) {
                    skipNext = skipIter.next();
                }
                ++i;
            }
            this.subSink.addEvent(this.reusableStruct);
        }
    }

    private class TypeEntry {
        private static final String STRUCT_TYPE_STACK_TRACE = "com.oracle.jfr.types.StackTrace";
        private static final String STRUCT_TYPE_STACK_FRAME = "com.oracle.jfr.types.StackFrame";
        private static final String STRUCT_TYPE_METHOD = "com.oracle.jfr.types.Method";
        private static final String STRUCT_TYPE_CLASS = "java.lang.Class";
        private static final String STRUCT_TYPE_CLASS_LOADER = "com.oracle.jfr.types.ClassLoader";
        private static final String STRUCT_TYPE_THREAD_GROUP = "com.oracle.jfr.types.ThreadGroup";
        private static final String STRUCT_TYPE_THREAD = "java.lang.Thread";
        final ChunkMetadata.ClassElement element;
        final FastAccessNumberMap<Object> constants;
        private ValueReaders.IValueReader reader;

        TypeEntry(ChunkMetadata.ClassElement element) {
            this(element, (FastAccessNumberMap<Object>)new FastAccessNumberMap());
        }

        TypeEntry(ChunkMetadata.ClassElement element, FastAccessNumberMap<Object> constants) {
            this.element = element;
            this.constants = constants;
        }

        public ValueReaders.IValueReader getReader() throws InvalidJfrFileException {
            if (this.reader == null) {
                int fieldCount = this.element.getFieldCount();
                if (this.element.isSimpleType() && fieldCount == 1) {
                    ChunkMetadata.FieldElement singleField = this.element.fields.get(0);
                    if (singleField.classId == this.element.classId) {
                        throw new InvalidJfrFileException(String.valueOf(this.element.typeIdentifier) + " is a simple type referring to itself");
                    }
                    this.reader = TypeManager.this.createFieldReader(this.element.fields.get(0), null);
                } else if (fieldCount == 0 && this.element.superType == null) {
                    this.reader = "java.lang.String".equals(this.element.typeIdentifier) ? new ValueReaders.StringReader(this.constants) : new ValueReaders.PrimitiveReader(this.element.typeIdentifier);
                } else {
                    ValueReaders.AbstractStructReader typeReader = this.createStructReader(this.element.typeIdentifier, this.element.label, this.element.description, fieldCount);
                    this.reader = typeReader;
                    int i = 0;
                    while (i < fieldCount) {
                        ChunkMetadata.FieldElement fe = this.element.fields.get(i);
                        ValueReaders.IValueReader reader = TypeManager.this.createFieldReader(fe, null);
                        String labelOrId = fe.label == null ? fe.fieldIdentifier : fe.label;
                        typeReader.addField(fe.fieldIdentifier, labelOrId, fe.description, reader);
                        ++i;
                    }
                }
            }
            return this.reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ValueReaders.AbstractStructReader createStructReader(String identifier, String name, String description, int fieldCount) {
            switch (identifier) {
                case "java.lang.Thread": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrThread.class, fieldCount, UnitLookup.THREAD);
                }
                case "com.oracle.jfr.types.ThreadGroup": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrThreadGroup.class, fieldCount, UnitLookup.UNKNOWN);
                }
                case "java.lang.Class": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrJavaClass.class, fieldCount, UnitLookup.CLASS);
                }
                case "com.oracle.jfr.types.ClassLoader": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrJavaClassLoader.class, fieldCount, UnitLookup.CLASS_LOADER);
                }
                case "com.oracle.jfr.types.Method": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrMethod.class, fieldCount, UnitLookup.METHOD);
                }
                case "com.oracle.jfr.types.StackFrame": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrFrame.class, fieldCount, UnitLookup.STACKTRACE_FRAME);
                }
                case "com.oracle.jfr.types.StackTrace": {
                    return new ValueReaders.ReflectiveReader(StructTypes.JfrStackTrace.class, fieldCount, UnitLookup.STACKTRACE);
                }
            }
            Map map = STRUCT_TYPES;
            synchronized (map) {
                StructContentType structType = (StructContentType)STRUCT_TYPES.get(this.element.classId);
                if (structType == null) {
                    structType = new StructContentType(this.element.typeIdentifier, this.element.label, this.element.description);
                    STRUCT_TYPES.put(this.element.classId, structType);
                }
                return new ValueReaders.StructReader((StructContentType<Object[]>)structType, fieldCount);
            }
        }

        void resolveConstants() throws InvalidJfrFileException {
            ValueReaders.IValueReader r = this.reader;
            if (r != null) {
                for (Object c : this.constants) {
                    r.resolve(c);
                }
            }
        }

        void readConstant(IDataInput input) throws InvalidJfrFileException, IOException {
            long constantIndex = input.readLong();
            Object value = this.constants.get(constantIndex);
            if (value == null) {
                value = this.getReader().read(input, true);
                this.constants.put(constantIndex, value);
            } else {
                this.getReader().skip(input);
            }
        }
    }

    private class TypeIdentifierReader
    implements ValueReaders.IValueReader {
        private final String typeIdentifier;
        private final boolean unsigned;

        TypeIdentifierReader(String typeIdentifier, boolean unsigned) throws InvalidJfrFileException {
            this.typeIdentifier = typeIdentifier;
            this.unsigned = unsigned;
        }

        @Override
        public Object read(IDataInput in, boolean allowUnresolvedReference) throws IOException, InvalidJfrFileException {
            long typeId = ValueReaders.PrimitiveReader.readLong(in, this.typeIdentifier, this.unsigned);
            return ((EventTypeEntry)TypeManager.this.eventTypes.get(typeId)).getValueType();
        }

        @Override
        public Object resolve(Object value) throws InvalidJfrFileException {
            return value;
        }

        @Override
        public void skip(IDataInput in) throws IOException, InvalidJfrFileException {
            ValueReaders.PrimitiveReader.readLong(in, this.typeIdentifier, this.unsigned);
        }

        @Override
        public ContentType<?> getContentType() {
            return UnitLookup.LABELED_IDENTIFIER;
        }
    }
}

