/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.parser.v1;

import com.oracle.jmc.common.IMCClassLoader;
import com.oracle.jmc.common.IMCFrame;
import com.oracle.jmc.common.IMCMethod;
import com.oracle.jmc.common.IMCStackTrace;
import com.oracle.jmc.common.IMCThread;
import com.oracle.jmc.common.IMCType;
import com.oracle.jmc.common.util.ClassLoaderToolkit;
import com.oracle.jmc.common.util.MCType;
import com.oracle.jmc.common.util.MethodToolkit;
import com.oracle.jmc.flightrecorder.internal.util.ParserToolkit;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

class StructTypes {
    private static final JfrMethod UNKNOWN_METHOD = new JfrMethod();
    private static final JfrJavaClass UNKNOWN_CLASS = new JfrJavaClass();

    StructTypes() {
    }

    static class JfrFrame
    implements IMCFrame {
        public Object method;
        public Object lineNumber;
        public Object bytecodeIndex;
        public Object type;

        JfrFrame() {
        }

        public Integer getFrameLineNumber() {
            return ((Number)this.lineNumber).intValue();
        }

        public Integer getBCI() {
            return ((Number)this.bytecodeIndex).intValue();
        }

        public IMCMethod getMethod() {
            if (this.method == null) {
                return UNKNOWN_METHOD;
            }
            return (IMCMethod)this.method;
        }

        public IMCFrame.Type getType() {
            Object t = this.type;
            if (!(t instanceof IMCFrame.Type)) {
                this.type = t = ParserToolkit.parseFrameType((String)t);
            }
            return (IMCFrame.Type)t;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this.method);
            result = 31 * result + Objects.hashCode(this.type);
            result = 31 * result + Objects.hashCode(this.lineNumber);
            result = 31 * result + Objects.hashCode(this.bytecodeIndex);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof JfrFrame) {
                JfrFrame of = (JfrFrame)obj;
                return Objects.equals(of.type, this.type) && Objects.equals(of.method, this.method) && Objects.equals(of.lineNumber, this.lineNumber) && Objects.equals(of.bytecodeIndex, this.bytecodeIndex);
            }
            return false;
        }
    }

    static class JfrJavaClass
    implements IMCType {
        public Object classLoaderType;
        public Object modifiers;
        public Object name;

        JfrJavaClass() {
        }

        public String getTypeName() {
            return this.getType().getTypeName();
        }

        public String getPackageName() {
            return this.getType().getPackageName();
        }

        public String getFullName() {
            return this.getType().getFullName();
        }

        private IMCType getType() {
            Object type = this.name;
            if (!(type instanceof IMCType)) {
                this.name = type = type == null ? MCType.UNKNOWN : MethodToolkit.typeFromReference((String)((String)type));
            }
            return (IMCType)type;
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }

        public boolean equals(Object obj) {
            return obj instanceof JfrJavaClass && Objects.equals(this.name, ((JfrJavaClass)obj).name);
        }

        public String toString() {
            return this.getFullName();
        }
    }

    static class JfrJavaClassLoader
    implements IMCClassLoader {
        public Object type;
        public Object name;

        JfrJavaClassLoader() {
        }

        public IMCType getType() {
            if (this.type != null && !(this.type instanceof IMCType)) {
                this.type = MethodToolkit.typeFromReference((String)((String)this.type));
            }
            return (IMCType)this.type;
        }

        public String getName() {
            return (String)this.name;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }

        public boolean equals(Object obj) {
            return obj instanceof JfrJavaClassLoader && Objects.equals(this.name, ((JfrJavaClassLoader)obj).name) && Objects.equals(this.type, ((JfrJavaClassLoader)obj).type);
        }

        public String toString() {
            return ClassLoaderToolkit.format((IMCClassLoader)this);
        }
    }

    static class JfrMethod
    implements IMCMethod {
        public Object type;
        public Object name;
        public Object descriptor;
        public Object modifiers;
        public Object hidden;

        JfrMethod() {
        }

        public IMCType getType() {
            if (this.type == null) {
                return UNKNOWN_CLASS;
            }
            return (IMCType)this.type;
        }

        public String getMethodName() {
            return (String)this.name;
        }

        public String getFormalDescriptor() {
            return (String)this.descriptor;
        }

        public Integer getModifier() {
            return ((Number)this.modifiers).intValue();
        }

        public Boolean isNative() {
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this.type);
            result = 31 * result + Objects.hashCode(this.descriptor);
            result = 31 * result + Objects.hashCode(this.name);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof JfrMethod) {
                JfrMethod om = (JfrMethod)obj;
                return Objects.equals(om.type, this.type) && Objects.equals(om.descriptor, this.descriptor) && Objects.equals(om.name, this.name);
            }
            return false;
        }
    }

    static class JfrStackTrace
    implements IMCStackTrace {
        public Object frames;
        public Object truncated;

        JfrStackTrace() {
        }

        public List<? extends IMCFrame> getFrames() {
            List<Object> l = this.frames;
            if (!(l instanceof List)) {
                this.frames = l = Arrays.asList((Object[])l);
            }
            return l;
        }

        public IMCStackTrace.TruncationState getTruncationState() {
            return this.truncated == null ? IMCStackTrace.TruncationState.UNKNOWN : ((Boolean)this.truncated != false ? IMCStackTrace.TruncationState.TRUNCATED : IMCStackTrace.TruncationState.NOT_TRUNCATED);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this.frames);
            result = 31 * result + Objects.hashCode(this.truncated);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof JfrStackTrace) {
                JfrStackTrace ost = (JfrStackTrace)obj;
                return Objects.equals(ost.frames, this.frames) && Objects.equals(ost.truncated, this.truncated);
            }
            return false;
        }
    }

    static class JfrThread
    implements IMCThread {
        public Object osName;
        public Object osThreadId;
        public Object javaThreadId;
        public Object javaName;
        public Object group;

        JfrThread() {
        }

        public Long getThreadId() {
            return ((Number)this.javaThreadId).longValue();
        }

        public String getThreadName() {
            return (String)(this.javaName != null ? this.javaName : this.osName);
        }

        public String getThreadGroupName() {
            Object threadGroup = this.group;
            return threadGroup == null ? null : (String)((JfrThreadGroup)threadGroup).name;
        }

        public String toString() {
            String name = this.getThreadName();
            return name == null ? "" : name;
        }

        public int hashCode() {
            return Objects.hashCode(this.osThreadId);
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof JfrThread && Objects.equals(this.osThreadId, ((JfrThread)obj).osThreadId);
        }
    }

    static class JfrThreadGroup {
        public Object name;
        public Object parent;

        JfrThreadGroup() {
        }
    }
}

