/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.parser.v1;

import com.oracle.jmc.common.unit.DecimalPrefix;
import com.oracle.jmc.common.unit.IPrefix;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IRange;
import com.oracle.jmc.common.unit.ITypedQuantity;
import com.oracle.jmc.common.unit.LinearUnit;
import com.oracle.jmc.common.unit.QuantityRange;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.flightrecorder.internal.InvalidJfrFileException;
import com.oracle.jmc.flightrecorder.internal.parser.Chunk;
import com.oracle.jmc.flightrecorder.internal.util.DataInputToolkit;
import java.io.IOException;

class ChunkStructure {
    private static final int SIZE = 60;
    private static final int COMPRESSED_INTS = 1;
    private final long chunkSize;
    private final long constantPoolOffset;
    private final long metadataOffset;
    private final long startTimeNanos;
    private final long durationNanos;
    private final long startTicks;
    private final double ticksPerNano;
    private final int features;
    private final int bodyOffset;
    private final LinearUnit ticksUnit;

    ChunkStructure(Chunk chunkInput) throws IOException, InvalidJfrFileException {
        int position = chunkInput.getPosition();
        byte[] buffer = chunkInput.fill(position + 60);
        this.chunkSize = DataInputToolkit.readLong(buffer, position);
        this.constantPoolOffset = DataInputToolkit.readLong(buffer, position += 8);
        this.metadataOffset = DataInputToolkit.readLong(buffer, position += 8);
        this.startTimeNanos = DataInputToolkit.readLong(buffer, position += 8);
        this.durationNanos = DataInputToolkit.readLong(buffer, position += 8);
        this.startTicks = DataInputToolkit.readLong(buffer, position += 8);
        this.ticksPerNano = (double)DataInputToolkit.readLong(buffer, position += 8) / 1.0E9;
        this.features = DataInputToolkit.readInt(buffer, position += 8);
        this.bodyOffset = position + 4;
        this.ticksUnit = UnitLookup.TIMESPAN.makeUnit("ticks", UnitLookup.TIMESPAN.getUnit((IPrefix)DecimalPrefix.NANO).quantity(1.0 / this.ticksPerNano));
    }

    long getBodyStartOffset() {
        return this.bodyOffset;
    }

    long getMetadataOffset() {
        return this.metadataOffset;
    }

    long getChunkSize() {
        return this.chunkSize;
    }

    long getConstantPoolOffset() {
        return this.constantPoolOffset;
    }

    boolean isIntegersCompressed() {
        return (this.features & 1) != 0;
    }

    LinearUnit getTicksTimespanUnit() {
        return this.ticksUnit;
    }

    IQuantity ticsTimestamp(long relativeTicks) {
        return UnitLookup.EPOCHNANOS.quantity(this.startTimeNanos + (long)((double)(relativeTicks - this.startTicks) / this.ticksPerNano));
    }

    IRange<IQuantity> getChunkRange() {
        return QuantityRange.createWithExtent((IQuantity)UnitLookup.EPOCHNANOS.quantity(this.startTimeNanos), (ITypedQuantity)UnitLookup.TIMESPAN.getUnit((IPrefix)DecimalPrefix.NANO).quantity(this.durationNanos));
    }
}

