/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.parser.v1;

import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.KindOfQuantity;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.flightrecorder.internal.InvalidJfrFileException;
import com.oracle.jmc.flightrecorder.internal.parser.v1.IDataInput;
import com.oracle.jmc.flightrecorder.internal.util.ParserToolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ChunkMetadata {
    static final long METADATA_EVENT_TYPE = 0L;
    private static final QName VALUE = new QName("value");
    private static final Pattern ARRAY_KEY_PATTERN = Pattern.compile("([^\\[]+)\\[([0-9]+)]");

    ChunkMetadata() {
    }

    static RootElement readMetadata(IDataInput input) throws IOException, InvalidJfrFileException {
        input.readInt();
        ParserToolkit.assertValue(input.readLong(), 0L);
        input.readLong();
        input.readLong();
        input.readLong();
        int stringCount = input.readInt();
        String[] strings = new String[stringCount];
        int i = 0;
        while (i < strings.length) {
            strings[i] = input.readRawString(input.readByte());
            ++i;
        }
        int nameIndex = input.readInt();
        try {
            Element rootElement = ChunkMetadata.createElement(strings[nameIndex]);
            ChunkMetadata.loadElement(input, strings, rootElement);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{RootElement.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            return (RootElement)jaxbUnmarshaller.unmarshal((Node)rootElement);
        }
        catch (JAXBException | ParserConfigurationException e) {
            throw new InvalidJfrFileException(e);
        }
    }

    private static void loadElement(IDataInput in, String[] s, Element element) throws IOException {
        int attributeCount = in.readInt();
        int i = 0;
        while (i < attributeCount) {
            int key = in.readInt();
            int value = in.readInt();
            Matcher arrayKeyMatcher = ARRAY_KEY_PATTERN.matcher(s[key]);
            if (arrayKeyMatcher.matches()) {
                String arrayKey = arrayKeyMatcher.group(1);
                String arrayIndex = arrayKeyMatcher.group(2);
                element.setAttribute(String.valueOf(arrayKey) + "-" + arrayIndex, s[value]);
            } else {
                element.setAttribute(s[key], s[value]);
            }
            ++i;
        }
        int elementCount = in.readInt();
        int i2 = 0;
        while (i2 < elementCount) {
            int nameIndex = in.readInt();
            Element child = element.getOwnerDocument().createElement(s[nameIndex]);
            element.appendChild(child);
            ChunkMetadata.loadElement(in, s, child);
            ++i2;
        }
    }

    private static Element createElement(String tagName) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document document = dbf.newDocumentBuilder().newDocument();
        return document.createElement(tagName);
    }

    static class AnnotatedElement {
        private static final String ANNOTATION_DESCRIPTION = "jdk.jfr.Description";
        private static final String ANNOTATION_LABEL = "jdk.jfr.Label";
        private static final String ANNOTATION_EXPERIMENTAL = "jdk.jfr.Experimental";
        @XmlElement(name="annotation")
        List<AnnotationElement> annotations;
        String label;
        String description;
        boolean experimental;

        AnnotatedElement() {
        }

        void resolveAnnotation(String typeIdentifier, Map<QName, String> values) throws InvalidJfrFileException {
            switch (typeIdentifier) {
                case "jdk.jfr.Label": {
                    this.label = values.get(VALUE);
                    return;
                }
                case "jdk.jfr.Description": {
                    this.description = values.get(VALUE);
                    return;
                }
                case "jdk.jfr.Experimental": {
                    this.experimental = true;
                    return;
                }
            }
        }
    }

    static class AnnotationElement {
        @XmlAttribute(name="class")
        long classId;
        @XmlAnyAttribute
        Map<QName, String> values;

        AnnotationElement() {
        }
    }

    static class ClassElement
    extends AnnotatedElement {
        private static final String ANNOTATION_CATEGORY = "jdk.jfr.Category";
        private static final String SUPER_TYPE_EVENT = "jdk.jfr.Event";
        @XmlAttribute(name="id")
        long classId;
        @XmlAttribute(name="name")
        String typeIdentifier;
        @XmlAttribute(name="superType")
        String superType;
        @XmlAttribute(name="simpleType")
        Boolean simpleType;
        @XmlElement(name="field")
        List<FieldElement> fields;
        @XmlElement(name="setting")
        List<SettingElement> settings;
        String[] category;

        ClassElement() {
        }

        @Override
        void resolveAnnotation(String typeIdentifier, Map<QName, String> values) throws InvalidJfrFileException {
            switch (typeIdentifier) {
                case "jdk.jfr.Category": {
                    String s;
                    ArrayList<String> list = new ArrayList<String>();
                    int index = 0;
                    while ((s = values.get(new QName("value-" + index++))) != null) {
                        list.add(s);
                    }
                    this.category = list.toArray(new String[list.size()]);
                    return;
                }
            }
            super.resolveAnnotation(typeIdentifier, values);
        }

        int getFieldCount() {
            return this.fields == null ? 0 : this.fields.size();
        }

        boolean isSimpleType() {
            return this.simpleType != null && this.simpleType != false;
        }

        boolean isEventType() {
            return SUPER_TYPE_EVENT.equals(this.superType);
        }
    }

    static class FieldElement
    extends AnnotatedElement {
        private static final String ANNOTATION_TIMESTAMP = "jdk.jfr.Timestamp";
        private static final String ANNOTATION_TIMESPAN = "jdk.jfr.Timespan";
        private static final String ANNOTATION_MEMORY_ADDRESS = "jdk.jfr.MemoryAddress";
        private static final String ANNOTATION_PERCENTAGE = "jdk.jfr.Percentage";
        private static final String ANNOTATION_MEMORY_AMOUNT = "jdk.jfr.MemoryAmount";
        private static final String ANNOTATION_DATA_AMOUNT = "jdk.jfr.DataAmount";
        private static final String ANNOTATION_UNSIGNED = "jdk.jfr.Unsigned";
        private static final String UNIT_S = "SECONDS";
        private static final String UNIT_MS = "MILLISECONDS";
        private static final String UNIT_NS = "NANOSECONDS";
        private static final String UNIT_TICKS = "TICKS";
        private static final String UNIT_S_SINCE_EPOCH = "SECONDS_SINCE_EPOCH";
        private static final String UNIT_MS_SINCE_EPOCH = "MILLISECONDS_SINCE_EPOCH";
        private static final String UNIT_NS_SINCE_EPOCH = "NANOSECONDS_SINCE_EPOCH";
        @XmlAttribute(name="name")
        String fieldIdentifier;
        @XmlAttribute(name="class")
        long classId;
        @XmlAttribute(name="constantPool")
        Boolean constantPool;
        @XmlAttribute(name="dimension")
        Integer dimension;
        IUnit unit;
        KindOfQuantity<?> ticksUnitKind;
        boolean unsigned;

        FieldElement() {
        }

        @Override
        void resolveAnnotation(String typeIdentifier, Map<QName, String> values) throws InvalidJfrFileException {
            switch (typeIdentifier) {
                case "jdk.jfr.Unsigned": {
                    this.unsigned = true;
                    return;
                }
                case "jdk.jfr.MemoryAmount": 
                case "jdk.jfr.DataAmount": {
                    this.unit = UnitLookup.BYTES;
                    return;
                }
                case "jdk.jfr.Percentage": {
                    this.unit = UnitLookup.PERCENT_UNITY;
                    return;
                }
                case "jdk.jfr.MemoryAddress": {
                    this.unit = UnitLookup.ADDRESS_UNITY;
                    return;
                }
                case "jdk.jfr.Timespan": {
                    String unitId;
                    switch (unitId = values.get(VALUE)) {
                        case "TICKS": {
                            this.ticksUnitKind = UnitLookup.TIMESPAN;
                            return;
                        }
                        case "NANOSECONDS": {
                            this.unit = UnitLookup.NANOSECONDS;
                            return;
                        }
                        case "MILLISECONDS": {
                            this.unit = UnitLookup.MILLISECONDS;
                            return;
                        }
                        case "SECONDS": {
                            this.unit = UnitLookup.SECONDS;
                            return;
                        }
                    }
                    return;
                }
                case "jdk.jfr.Timestamp": {
                    String unitId;
                    switch (unitId = values.get(VALUE)) {
                        case "TICKS": {
                            this.ticksUnitKind = UnitLookup.TIMESTAMP;
                            return;
                        }
                        case "NANOSECONDS_SINCE_EPOCH": {
                            this.unit = UnitLookup.EPOCHNANOS;
                            return;
                        }
                        case "MILLISECONDS_SINCE_EPOCH": {
                            this.unit = UnitLookup.EPOCHMILLIS;
                            return;
                        }
                        case "SECONDS_SINCE_EPOCH": {
                            this.unit = UnitLookup.EPOCHSECONDS;
                            return;
                        }
                    }
                    return;
                }
            }
            super.resolveAnnotation(typeIdentifier, values);
        }

        boolean isStoredInPool() {
            return this.constantPool != null && this.constantPool != false;
        }

        boolean isArray() throws InvalidJfrFileException {
            if (this.dimension == null || this.dimension == 0) {
                return false;
            }
            if (this.dimension == 1) {
                return true;
            }
            throw new InvalidJfrFileException("Array dimension " + this.dimension + " is not supported");
        }
    }

    static class MetadataElement {
        @XmlElement(name="class")
        List<ClassElement> classes;

        MetadataElement() {
        }
    }

    static class RegionElement {
        @XmlAttribute(name="locale")
        String locale;
        @XmlAttribute(name="gmtOffset")
        String gmtOffset;
        @XmlAttribute(name="ticksToMillis")
        String ticksToMillis;

        RegionElement() {
        }
    }

    @XmlRootElement(name="root")
    static class RootElement {
        @XmlElement(name="metadata")
        MetadataElement metadata;
        @XmlElement(name="region")
        RegionElement region;

        RootElement() {
        }
    }

    static class SettingElement
    extends AnnotatedElement {
        @XmlAttribute(name="name")
        String name;
        @XmlAttribute(name="class")
        long classId;

        SettingElement() {
        }
    }
}

