/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.parser.v1;

import com.oracle.jmc.flightrecorder.CouldNotLoadRecordingException;
import com.oracle.jmc.flightrecorder.internal.ChunkInfo;
import com.oracle.jmc.flightrecorder.internal.InvalidJfrFileException;
import com.oracle.jmc.flightrecorder.internal.parser.Chunk;
import com.oracle.jmc.flightrecorder.internal.parser.LoaderContext;
import com.oracle.jmc.flightrecorder.internal.parser.v1.ChunkMetadata;
import com.oracle.jmc.flightrecorder.internal.parser.v1.ChunkStructure;
import com.oracle.jmc.flightrecorder.internal.parser.v1.IDataInput;
import com.oracle.jmc.flightrecorder.internal.parser.v1.SeekableInputStream;
import com.oracle.jmc.flightrecorder.internal.parser.v1.TypeManager;
import com.oracle.jmc.flightrecorder.internal.util.ParserToolkit;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;

public class ChunkLoaderV1
implements Callable<byte[]> {
    private static final long CONSTANT_POOL_EVENT_TYPE = 1L;
    private final ChunkStructure header;
    private final byte[] data;
    private final LoaderContext context;

    public ChunkLoaderV1(ChunkStructure header, byte[] data, LoaderContext context) {
        this.header = header;
        this.data = data;
        this.context = context;
    }

    @Override
    public byte[] call() throws Exception {
        SeekableInputStream input = SeekableInputStream.build(this.data, this.header.isIntegersCompressed());
        input.seek(this.header.getMetadataOffset());
        List<ChunkMetadata.ClassElement> classes = ChunkMetadata.readMetadata((IDataInput)input).metadata.classes;
        TypeManager manager = new TypeManager(classes, this.context, this.header);
        long constantPoolOffset = 0L;
        long delta = this.header.getConstantPoolOffset();
        while (delta != 0L) {
            input.seek(constantPoolOffset += delta);
            delta = ChunkLoaderV1.readConstantPoolEvent(input, manager);
        }
        manager.resolveConstants();
        long index = this.header.getBodyStartOffset();
        while (true) {
            input.seek(index);
            int size = input.readInt();
            long type = input.readLong();
            if (type == 0L) {
                return this.data;
            }
            if (type != 1L) {
                manager.readEvent(type, input);
            }
            index += (long)size;
        }
    }

    private static long readConstantPoolEvent(IDataInput input, TypeManager manager) throws IOException, InvalidJfrFileException {
        input.readInt();
        ParserToolkit.assertValue(input.readLong(), 1L);
        input.readLong();
        input.readLong();
        long delta = input.readLong();
        input.readBoolean();
        int poolCount = input.readInt();
        int i = 0;
        while (i < poolCount) {
            long classId = input.readLong();
            int constantCount = input.readInt();
            manager.readConstants(classId, input, constantCount);
            ++i;
        }
        return delta;
    }

    public static Callable<byte[]> create(Chunk input, LoaderContext context) throws IOException, CouldNotLoadRecordingException {
        ChunkStructure header = new ChunkStructure(input);
        byte[] data = input.fill(header.getChunkSize());
        return new ChunkLoaderV1(header, data, context);
    }

    public static ChunkInfo getInfo(Chunk input, long position) throws IOException, CouldNotLoadRecordingException {
        ChunkStructure header = new ChunkStructure(input);
        return new ChunkInfo(position, header.getChunkSize(), header.getChunkRange());
    }
}

