/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.parser.v0.factories;

import com.oracle.jmc.common.IMCType;
import com.oracle.jmc.common.unit.ContentType;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.MethodToolkit;
import com.oracle.jmc.flightrecorder.internal.parser.v0.factories.IPoolFactory;
import com.oracle.jmc.flightrecorder.internal.parser.v0.model.ValueDescriptor;
import com.oracle.jmc.flightrecorder.internal.util.CanonicalConstantMap;

final class TypeFactory
implements IPoolFactory<IMCType> {
    private final int m_nameIndex;
    private final CanonicalConstantMap<IMCType> typeMap;

    public TypeFactory(ValueDescriptor[] descriptors, CanonicalConstantMap<IMCType> typeMap) {
        this.typeMap = typeMap;
        this.m_nameIndex = ValueDescriptor.getIndex(descriptors, "name");
    }

    @Override
    public IMCType createObject(long identifier, Object s) {
        String refType;
        Object[] o = (Object[])s;
        if (identifier == 0L && s == null) {
            return null;
        }
        if (this.m_nameIndex != -1 && o != null && (refType = (String)o[this.m_nameIndex]) != null) {
            return this.typeMap.canonicalize(MethodToolkit.typeFromReference((String)refType));
        }
        return null;
    }

    @Override
    public ContentType<IMCType> getContentType() {
        return UnitLookup.CLASS;
    }
}

