/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.parser.v0.factories;

import com.oracle.jmc.common.IMCThread;
import com.oracle.jmc.common.unit.ContentType;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.flightrecorder.internal.model.JfrThread;
import com.oracle.jmc.flightrecorder.internal.parser.v0.factories.IPoolFactory;
import com.oracle.jmc.flightrecorder.internal.util.CanonicalConstantMap;

final class OSThreadFactory
implements IPoolFactory<IMCThread> {
    private final CanonicalConstantMap<JfrThread> threadsMap;

    OSThreadFactory(CanonicalConstantMap<JfrThread> threadsMap) {
        this.threadsMap = threadsMap;
    }

    @Override
    public IMCThread createObject(long identifier, Object o) {
        int osThreadId = (int)identifier;
        if (osThreadId == 0) {
            return null;
        }
        String name = (String)o;
        JfrThread thread = this.threadsMap.canonicalize(new JfrThread(osThreadId));
        thread.addName(name);
        return thread;
    }

    @Override
    public ContentType<IMCThread> getContentType() {
        return UnitLookup.THREAD;
    }
}

