/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.parser.v0.factories;

import com.oracle.jmc.common.IMCThread;
import com.oracle.jmc.common.unit.ContentType;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.flightrecorder.internal.model.JfrThread;
import com.oracle.jmc.flightrecorder.internal.model.ThreadGroup;
import com.oracle.jmc.flightrecorder.internal.parser.v0.factories.IPoolFactory;
import com.oracle.jmc.flightrecorder.internal.parser.v0.model.ValueDescriptor;

final class JavaThreadFactory
implements IPoolFactory<IMCThread> {
    private final int m_osThread;
    private final int m_threadGroup;

    public JavaThreadFactory(ValueDescriptor[] descriptors) {
        this.m_osThread = ValueDescriptor.getIndex(descriptors, "thread");
        this.m_threadGroup = ValueDescriptor.getIndex(descriptors, "group");
    }

    @Override
    public IMCThread createObject(long identifier, Object o) {
        if (o != null) {
            Object[] objects = (Object[])o;
            JfrThread thread = (JfrThread)objects[this.m_osThread];
            ThreadGroup group = (ThreadGroup)objects[this.m_threadGroup];
            if (group != null) {
                thread.addThreadGroupName(group.getName());
            }
            thread.addJavaId(identifier);
            return thread;
        }
        return null;
    }

    @Override
    public ContentType<IMCThread> getContentType() {
        return UnitLookup.THREAD;
    }
}

