/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.parser.v0.factories;

import com.oracle.jmc.flightrecorder.internal.InvalidJfrFileException;
import com.oracle.jmc.flightrecorder.internal.parser.LoaderContext;
import com.oracle.jmc.flightrecorder.internal.parser.v0.factories.IPoolFactory;
import com.oracle.jmc.flightrecorder.internal.parser.v0.factories.JavaThreadFactory;
import com.oracle.jmc.flightrecorder.internal.parser.v0.factories.MethodFactory;
import com.oracle.jmc.flightrecorder.internal.parser.v0.factories.OSThreadFactory;
import com.oracle.jmc.flightrecorder.internal.parser.v0.factories.StackTraceFactory;
import com.oracle.jmc.flightrecorder.internal.parser.v0.factories.ThreadGroupFactory;
import com.oracle.jmc.flightrecorder.internal.parser.v0.factories.TypeFactory;
import com.oracle.jmc.flightrecorder.internal.parser.v0.model.ContentTypeDescriptor;
import com.oracle.jmc.flightrecorder.internal.parser.v0.model.ValueDescriptor;

public final class GlobalObjectPool {
    public static IPoolFactory<?> getFactory(ContentTypeDescriptor contentType, LoaderContext context) throws InvalidJfrFileException {
        String name = contentType.getName();
        ValueDescriptor[] dataStructure = contentType.getDataStructure();
        if ("Method".equals(name)) {
            return new MethodFactory(dataStructure, context.getConstantPool(name));
        }
        if ("StackTrace".equals(name)) {
            return new StackTraceFactory(dataStructure, context.getConstantPool(name));
        }
        if ("JavaThread".equals(name)) {
            return new JavaThreadFactory(dataStructure);
        }
        if ("Thread".equals(name)) {
            return new OSThreadFactory(context.getConstantPool(name));
        }
        if ("Class".equals(name)) {
            return new TypeFactory(dataStructure, context.getConstantPool(name));
        }
        if ("ThreadGroup".equals(name)) {
            return new ThreadGroupFactory(dataStructure);
        }
        return null;
    }
}

