/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.parser.v0;

import com.oracle.jmc.flightrecorder.internal.InvalidJfrFileException;
import com.oracle.jmc.flightrecorder.internal.parser.v0.IArrayElementParser;
import com.oracle.jmc.flightrecorder.internal.parser.v0.NumberReaders;
import com.oracle.jmc.flightrecorder.internal.parser.v0.Offset;

class TypedArrayParser<T> {
    private final IArrayElementParser<T> elementParser;

    public TypedArrayParser(IArrayElementParser<T> elementParser) {
        this.elementParser = elementParser;
    }

    public T[] read(byte[] data, Offset offset) throws InvalidJfrFileException {
        int arraySize = NumberReaders.readInt(data, offset);
        T[] array = this.elementParser.createArray(arraySize);
        int n = 0;
        while (n < arraySize) {
            array[n] = this.elementParser.readElement(data, offset);
            ++n;
        }
        return array;
    }
}

