/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.parser.v0;

import com.oracle.jmc.common.unit.ContentType;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.flightrecorder.internal.InvalidJfrFileException;
import com.oracle.jmc.flightrecorder.internal.parser.v0.IValueReader;
import com.oracle.jmc.flightrecorder.internal.parser.v0.NumberReaders;
import com.oracle.jmc.flightrecorder.internal.parser.v0.Offset;
import java.io.UnsupportedEncodingException;

final class StringReader
implements IValueReader {
    public static final StringReader INSTANCE = new StringReader();
    private static final String CHARSET = "UTF-16";
    private static final int UNREASONABLE_STRING_LENGTH = 100000000;

    StringReader() {
    }

    @Override
    public Object readValue(byte[] data, Offset offset, long timestamp) throws InvalidJfrFileException {
        return StringReader.readString(data, offset);
    }

    public static String readString(byte[] data, Offset offset) throws InvalidJfrFileException {
        int byteCount = StringReader.readStringByteCount(data, offset);
        int index = offset.get();
        offset.increase(byteCount);
        try {
            return new String(data, index, byteCount, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static int readStringByteCount(byte[] data, Offset offset) throws InvalidJfrFileException {
        int stringLength = NumberReaders.readInt(data, offset);
        if (stringLength < 0 || stringLength > 100000000) {
            throw new InvalidJfrFileException();
        }
        return stringLength * 2;
    }

    @Override
    public ContentType<?> getValueType() {
        return UnitLookup.PLAIN_TEXT;
    }
}

