/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.parser.v0;

import com.oracle.jmc.common.collection.FastAccessNumberMap;
import com.oracle.jmc.common.unit.ContentType;
import com.oracle.jmc.common.unit.DecimalPrefix;
import com.oracle.jmc.common.unit.IPrefix;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.common.util.LabeledIdentifier;
import com.oracle.jmc.flightrecorder.internal.InvalidJfrFileException;
import com.oracle.jmc.flightrecorder.internal.parser.LoaderContext;
import com.oracle.jmc.flightrecorder.internal.parser.v0.ArrayReader;
import com.oracle.jmc.flightrecorder.internal.parser.v0.BooleanReader;
import com.oracle.jmc.flightrecorder.internal.parser.v0.ChunkMetadata;
import com.oracle.jmc.flightrecorder.internal.parser.v0.CompositeReader;
import com.oracle.jmc.flightrecorder.internal.parser.v0.ConstantMap;
import com.oracle.jmc.flightrecorder.internal.parser.v0.ConstantReader;
import com.oracle.jmc.flightrecorder.internal.parser.v0.IValueReader;
import com.oracle.jmc.flightrecorder.internal.parser.v0.NumberReaders;
import com.oracle.jmc.flightrecorder.internal.parser.v0.Offset;
import com.oracle.jmc.flightrecorder.internal.parser.v0.QuantityReader;
import com.oracle.jmc.flightrecorder.internal.parser.v0.StringReader;
import com.oracle.jmc.flightrecorder.internal.parser.v0.UTFStringParser;
import com.oracle.jmc.flightrecorder.internal.parser.v0.factories.GlobalObjectPool;
import com.oracle.jmc.flightrecorder.internal.parser.v0.factories.IPoolFactory;
import com.oracle.jmc.flightrecorder.internal.parser.v0.model.ContentTypeDescriptor;
import com.oracle.jmc.flightrecorder.internal.parser.v0.model.DataType;
import com.oracle.jmc.flightrecorder.internal.parser.v0.model.EventTypeDescriptor;
import com.oracle.jmc.flightrecorder.internal.parser.v0.model.ProducerDescriptor;
import com.oracle.jmc.flightrecorder.internal.parser.v0.model.ValueDescriptor;

class ReaderFactory {
    private final FastAccessNumberMap<ConstantMap> constants = new FastAccessNumberMap(100, 5);
    private final ChunkMetadata metadata;
    private final FastAccessNumberMap<LabeledIdentifier> types = new FastAccessNumberMap();

    ReaderFactory(ChunkMetadata metadata, byte[] chunkData, LoaderContext context) throws InvalidJfrFileException {
        this.metadata = metadata;
        ProducerDescriptor[] producerDescriptorArray = metadata.getProducers();
        int n = producerDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProducerDescriptor pd = producerDescriptorArray[n2];
            Object[] objectArray = pd.getContentTypes();
            int n3 = objectArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ContentTypeDescriptor ct = objectArray[n4];
                IValueReader reader = this.createReader(ct.getDataStructure());
                IPoolFactory<?> factory = GlobalObjectPool.getFactory(ct, context);
                this.getConstantMap(ct.getContentTypeId()).init(reader, ct.getDataType(), factory);
                ++n4;
            }
            objectArray = pd.getEventTypeDescriptors();
            n3 = objectArray.length;
            n4 = 0;
            while (n4 < n3) {
                Object etd = objectArray[n4];
                this.types.put((long)((EventTypeDescriptor)etd).getIdentifier(), (Object)new LabeledIdentifier(String.valueOf(pd.getURIString()) + ((EventTypeDescriptor)etd).getPath(), (long)((EventTypeDescriptor)etd).getIdentifier(), ((EventTypeDescriptor)etd).getLabel(), ((EventTypeDescriptor)etd).getDescription()));
                ++n4;
            }
            ++n2;
        }
        int prevCpOffset = metadata.getPreviousCheckPoint();
        while (prevCpOffset != 0) {
            Offset offset = new Offset(chunkData, prevCpOffset);
            offset.increase(4);
            long timestamp = this.readTicksTimestamp(chunkData, offset);
            prevCpOffset = (int)NumberReaders.readLong(chunkData, offset);
            while (offset.get() < offset.getEnd()) {
                int contentTypeId = NumberReaders.readInt(chunkData, offset);
                int entries = NumberReaders.readInt(chunkData, offset);
                ConstantMap entry = this.getConstantMap(contentTypeId);
                int n5 = 0;
                while (n5 < entries) {
                    entry.readValue(chunkData, offset, timestamp);
                    ++n5;
                }
            }
        }
        for (ConstantMap cp : this.constants) {
            cp.setLoadDone();
        }
        ConstantMap threadPool = (ConstantMap)this.constants.get(8L);
        if (threadPool != null) {
            threadPool.touchAll();
        }
    }

    long readTicksTimestamp(byte[] data, Offset offset) throws InvalidJfrFileException {
        return this.metadata.asNanoTimestamp(NumberReaders.readLong(data, offset));
    }

    private ConstantMap getConstantMap(int contentTypeId) {
        ConstantMap constantMap = (ConstantMap)this.constants.get((long)contentTypeId);
        if (constantMap == null) {
            constantMap = new ConstantMap();
            this.constants.put((long)contentTypeId, (Object)constantMap);
        }
        return constantMap;
    }

    private IValueReader createReader(ValueDescriptor[] vds) throws InvalidJfrFileException {
        if (vds.length == 1) {
            return this.createReader(vds[0], null);
        }
        IValueReader[] readers = new IValueReader[vds.length];
        int i = 0;
        while (i < readers.length) {
            readers[i] = this.createReader(vds[i], null);
            ++i;
        }
        return new CompositeReader(readers);
    }

    IValueReader createReader(ValueDescriptor vd, String valueType) throws InvalidJfrFileException {
        if (vd.getDataType().isPrimitive()) {
            return this.createPrimitiveReader(vd.getDataType(), vd.getContentType(), valueType);
        }
        if (vd.getDataType() == DataType.ARRAY) {
            return new ArrayReader(this.createPrimitiveReader(vd.getInnerDataType(), vd.getContentType(), valueType));
        }
        if (vd.getDataType() == DataType.STRUCTARRAY) {
            return new ArrayReader(this.createReader(vd.getChildren()));
        }
        if (vd.getDataType() == DataType.STRUCT) {
            return this.createReader(vd.getChildren());
        }
        throw new InvalidJfrFileException();
    }

    private IValueReader createPrimitiveReader(DataType dataType, int contentType, String valueType) throws InvalidJfrFileException {
        if (dataType.isNumeric()) {
            switch (contentType) {
                case 2: {
                    return new QuantityReader(dataType, (IUnit)UnitLookup.EPOCHMILLIS);
                }
                case 3: {
                    return new QuantityReader(dataType, (IUnit)UnitLookup.MILLISECONDS);
                }
                case 4: {
                    return new QuantityReader(dataType, (IUnit)UnitLookup.TIMESPAN.getUnit((IPrefix)DecimalPrefix.NANO));
                }
                case 5: {
                    return new QuantityReader(dataType, (IUnit)this.metadata.getTicksUnit());
                }
                case 11: {
                    return new QuantityReader(dataType, (IUnit)UnitLookup.PERCENT_UNITY);
                }
                case 1: {
                    return new QuantityReader(dataType, (IUnit)UnitLookup.BYTES);
                }
                case 6: {
                    return new QuantityReader(dataType, (IUnit)UnitLookup.ADDRESS_UNITY);
                }
                case 0: {
                    if ("com.oracle.jmc.flightrecorder.value_interpretation.type_identifier".equals(valueType)) {
                        return new TypeIdentifierReader(dataType);
                    }
                    IUnit unit = UnitLookup.getUnitOrNull((String)valueType);
                    if (unit != null) {
                        return new QuantityReader(dataType, unit);
                    }
                    return new QuantityReader(dataType, (IUnit)UnitLookup.NUMBER_UNITY);
                }
            }
            return this.createConstantReader(dataType, contentType);
        }
        if (dataType == DataType.BOOLEAN) {
            return BooleanReader.INSTANCE;
        }
        if (dataType == DataType.STRING) {
            return StringReader.INSTANCE;
        }
        if (dataType == DataType.UTF8) {
            return UTFStringParser.INSTANCE;
        }
        throw new InvalidJfrFileException();
    }

    IValueReader createConstantReader(DataType dataType, int contentType) throws InvalidJfrFileException {
        return new ConstantReader(this.getConstantMap(contentType), dataType);
    }

    private class TypeIdentifierReader
    implements IValueReader {
        private final DataType dataType;

        TypeIdentifierReader(DataType dataType) {
            this.dataType = dataType;
        }

        @Override
        public Object readValue(byte[] bytes, Offset offset, long timestamp) throws InvalidJfrFileException {
            long typeId = NumberReaders.readKey(bytes, offset, this.dataType);
            return ReaderFactory.this.types.get(typeId);
        }

        @Override
        public ContentType<?> getValueType() {
            return UnitLookup.LABELED_IDENTIFIER;
        }
    }
}

