/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.parser.v0;

import com.oracle.jmc.common.unit.ContentType;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.flightrecorder.internal.InvalidJfrFileException;
import com.oracle.jmc.flightrecorder.internal.parser.v0.IValueReader;
import com.oracle.jmc.flightrecorder.internal.parser.v0.NumberReaders;
import com.oracle.jmc.flightrecorder.internal.parser.v0.Offset;
import com.oracle.jmc.flightrecorder.internal.parser.v0.model.DataType;

class QuantityReader
implements IValueReader {
    private final IUnit unit;
    private final DataType dataType;

    QuantityReader(DataType dataType, IUnit unit) {
        this.dataType = dataType;
        this.unit = unit;
    }

    @Override
    public Object readValue(byte[] bytes, Offset offset, long timestamp) throws InvalidJfrFileException {
        switch (this.dataType) {
            case BYTE: 
            case U1: {
                return this.unit.quantity((long)NumberReaders.readByte(bytes, offset));
            }
            case SHORT: 
            case U2: {
                return this.unit.quantity((long)NumberReaders.readShort(bytes, offset));
            }
            case INTEGER: 
            case U4: {
                return this.unit.quantity((long)NumberReaders.readInt(bytes, offset));
            }
            case LONG: 
            case U8: {
                return this.unit.quantity(NumberReaders.readLong(bytes, offset));
            }
            case FLOAT: {
                float value = NumberReaders.readFloat(bytes, offset);
                return Float.isNaN(value) ? null : this.unit.quantity((double)value);
            }
            case DOUBLE: {
                double value = NumberReaders.readDouble(bytes, offset);
                return Double.isNaN(value) ? null : this.unit.quantity(value);
            }
        }
        throw new InvalidJfrFileException();
    }

    @Override
    public ContentType<?> getValueType() {
        return this.unit.getContentType();
    }
}

