/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.parser.v0;

import com.oracle.jmc.common.collection.FastAccessNumberMap;
import com.oracle.jmc.common.unit.IUnit;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.internal.EventAppearance;
import com.oracle.jmc.flightrecorder.internal.InvalidJfrFileException;
import com.oracle.jmc.flightrecorder.internal.parser.LoaderContext;
import com.oracle.jmc.flightrecorder.internal.parser.v0.IValueReader;
import com.oracle.jmc.flightrecorder.internal.parser.v0.Offset;
import com.oracle.jmc.flightrecorder.internal.parser.v0.QuantityReader;
import com.oracle.jmc.flightrecorder.internal.parser.v0.ReaderFactory;
import com.oracle.jmc.flightrecorder.internal.parser.v0.model.DataType;
import com.oracle.jmc.flightrecorder.internal.parser.v0.model.EventTypeDescriptor;
import com.oracle.jmc.flightrecorder.internal.parser.v0.model.ProducerDescriptor;
import com.oracle.jmc.flightrecorder.internal.parser.v0.model.ValueDescriptor;
import com.oracle.jmc.flightrecorder.messages.internal.Messages;
import com.oracle.jmc.flightrecorder.parser.IEventSink;
import com.oracle.jmc.flightrecorder.parser.IEventSinkFactory;
import com.oracle.jmc.flightrecorder.parser.ValueField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class EventParserManager {
    static final int METADATA_EVENT_TYPE_INDEX = 0;
    static final int CHECK_POINT_EVENT_TYPE_INDEX = 1;
    static final int LOST_EVENT_TYPE_INDEX = 2;
    static final int CONTENT_TYPE_POOL_NONE = 0;
    static final int CONTENT_TYPE_MEMORY = 1;
    static final int CONTENT_TYPE_EPOCHMILLIS = 2;
    static final int CONTENT_TYPE_MILLIS = 3;
    static final int CONTENT_TYPE_NANOS = 4;
    static final int CONTENT_TYPE_TICKS = 5;
    static final int CONTENT_TYPE_ADDRESS = 6;
    static final int CONTENT_TYPE_THREADID = 7;
    static final int CONTENT_TYPE_JAVATHREADID = 8;
    static final int CONTENT_TYPE_STACKTRACEID = 9;
    static final int CONTENT_TYPE_PERCENTAGE = 11;
    private final FastAccessNumberMap<EventTypeEntry> eventTypes = new FastAccessNumberMap(100, 5);
    private final ReaderFactory readerFactory;
    private final LoaderContext context;

    public EventParserManager(ReaderFactory readerFactory, LoaderContext context, ProducerDescriptor ... producers) throws InvalidJfrFileException {
        this.readerFactory = readerFactory;
        this.context = context;
        ProducerDescriptor[] producerDescriptorArray = producers;
        int n = producers.length;
        int n2 = 0;
        while (n2 < n) {
            ProducerDescriptor pd = producerDescriptorArray[n2];
            EventTypeDescriptor[] eventTypeDescriptorArray = pd.getEventTypeDescriptors();
            int n3 = eventTypeDescriptorArray.length;
            int n4 = 0;
            while (n4 < n3) {
                EventTypeDescriptor etd = eventTypeDescriptorArray[n4];
                String path = etd.getPath();
                String id = String.valueOf(pd.getURIString()) + path;
                EventTypeBuilder eventSpec = new EventTypeBuilder(id, etd);
                String[] category = EventAppearance.getHumanSegmentArray(path);
                category = Arrays.copyOf(category, category.length - 1);
                IEventSink sink = context.getSinkFactory().create(id, etd.getLabel(), category, etd.getDescription(), eventSpec.getValueFields());
                this.eventTypes.put((long)etd.getIdentifier(), (Object)new EventTypeEntry(sink, etd.hasStartTime(), eventSpec.getValueReaders()));
                ++n4;
            }
            ++n2;
        }
        this.eventTypes.put(2L, (Object)this.createBufferLostEntry(context.getSinkFactory()));
    }

    void loadEvent(byte[] data, Offset offset, int eventTypeId) throws InvalidJfrFileException {
        EventTypeEntry ep = (EventTypeEntry)this.eventTypes.get((long)eventTypeId);
        if (ep == null) {
            throw new IllegalArgumentException("Event type " + eventTypeId + " is not described in the file");
        }
        long endTime = this.readerFactory.readTicksTimestamp(data, offset);
        int valueIndex = 0;
        if (ep.hasStartTime) {
            ((EventTypeEntry)ep).values[valueIndex++] = UnitLookup.EPOCHNANOS.quantity(this.readerFactory.readTicksTimestamp(data, offset));
        }
        ((EventTypeEntry)ep).values[valueIndex++] = UnitLookup.EPOCHNANOS.quantity(endTime);
        int n = 0;
        while (n < ep.parsers.length) {
            ((EventTypeEntry)ep).values[valueIndex++] = ep.parsers[n].readValue(data, offset, endTime);
            ++n;
        }
        ep.sink.addEvent(ep.values);
    }

    private EventTypeEntry createBufferLostEntry(IEventSinkFactory esf) throws InvalidJfrFileException {
        EventTypeBuilder eventReader = new EventTypeBuilder();
        eventReader.addThreadField();
        eventReader.addMemoryDroppedField();
        IEventSink sink = esf.create("com.oracle.jmc.flightrecorder.bufferlosttypeid", Messages.getString("EventParserManager_TYPE_BUFFER_LOST"), EventAppearance.getHumanSegmentArray("recordings"), Messages.getString("EventParserManager_TYPE_BUFFER_LOST_DESC"), eventReader.getValueFields());
        return new EventTypeEntry(sink, false, eventReader.getValueReaders());
    }

    private class EventTypeBuilder {
        private final List<IValueReader> readers = new ArrayList<IValueReader>();
        private final List<ValueField> valueFields = new ArrayList<ValueField>();

        EventTypeBuilder() {
            this.valueFields.add(new ValueField(JfrAttributes.END_TIME));
        }

        EventTypeBuilder(String typeId, EventTypeDescriptor etd) throws InvalidJfrFileException {
            if (etd.hasStartTime()) {
                this.valueFields.add(new ValueField(JfrAttributes.START_TIME));
            }
            this.valueFields.add(new ValueField(JfrAttributes.END_TIME));
            if (etd.hasThread()) {
                this.addThreadField();
            }
            if (etd.canHaveStacktrace()) {
                this.addStacktraceField();
            }
            ValueDescriptor[] valueDescriptorArray = etd.getDataStructure();
            int n = valueDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                ValueDescriptor vd = valueDescriptorArray[n2];
                this.add(typeId, vd);
                ++n2;
            }
        }

        void add(String typeId, ValueDescriptor vd) throws InvalidJfrFileException {
            if (vd.getDataType() == DataType.STRUCT) {
                ValueDescriptor[] valueDescriptorArray = vd.getChildren();
                int n = valueDescriptorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ValueDescriptor child = valueDescriptorArray[n2];
                    this.add(typeId, child, String.valueOf(vd.getIdentifier()) + ":" + child.getIdentifier(), String.valueOf(vd.getName()) + " : " + child.getName());
                    ++n2;
                }
            } else {
                this.add(typeId, vd, vd.getIdentifier(), vd.getName());
            }
        }

        private void add(String typeId, ValueDescriptor vd, String identifier, String name) throws InvalidJfrFileException {
            String valueType = EventParserManager.this.context.getValueInterpretation(typeId, identifier);
            IValueReader r = EventParserManager.this.readerFactory.createReader(vd, valueType);
            this.readers.add(r);
            this.valueFields.add(new ValueField(identifier, name, vd.getDescription(), r.getValueType()));
        }

        private void addThreadField() throws InvalidJfrFileException {
            this.readers.add(EventParserManager.this.readerFactory.createConstantReader(DataType.U4, 7));
            this.valueFields.add(new ValueField(JfrAttributes.EVENT_THREAD));
        }

        private void addStacktraceField() throws InvalidJfrFileException {
            this.readers.add(EventParserManager.this.readerFactory.createConstantReader(DataType.U8, 9));
            this.valueFields.add(new ValueField(JfrAttributes.EVENT_STACKTRACE));
        }

        private void addMemoryDroppedField() throws InvalidJfrFileException {
            this.readers.add(new QuantityReader(DataType.U4, (IUnit)UnitLookup.BYTES));
            this.valueFields.add(new ValueField(JfrAttributes.FLR_DATA_LOST));
        }

        IValueReader[] getValueReaders() {
            return this.readers.toArray(new IValueReader[this.readers.size()]);
        }

        List<ValueField> getValueFields() {
            return Collections.unmodifiableList(this.valueFields);
        }
    }

    private static class EventTypeEntry {
        private final Object[] values;
        private final IValueReader[] parsers;
        private final IEventSink sink;
        private final boolean hasStartTime;

        public EventTypeEntry(IEventSink sink, boolean hasStartTime, IValueReader[] valueParsers) {
            this.parsers = valueParsers;
            this.sink = sink;
            this.hasStartTime = hasStartTime;
            this.values = new Object[(hasStartTime ? 2 : 1) + this.parsers.length];
        }
    }
}

