/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.parser.v0;

import com.oracle.jmc.common.unit.ContentType;
import com.oracle.jmc.flightrecorder.internal.InvalidJfrFileException;
import com.oracle.jmc.flightrecorder.internal.parser.v0.ConstantMap;
import com.oracle.jmc.flightrecorder.internal.parser.v0.IValueReader;
import com.oracle.jmc.flightrecorder.internal.parser.v0.NumberReaders;
import com.oracle.jmc.flightrecorder.internal.parser.v0.Offset;
import com.oracle.jmc.flightrecorder.internal.parser.v0.model.DataType;

class ConstantReader
implements IValueReader {
    private final ConstantMap pool;
    private final DataType keyType;

    public ConstantReader(ConstantMap pool, DataType keyType) {
        this.pool = pool;
        this.keyType = keyType;
    }

    @Override
    public Object readValue(byte[] bytes, Offset offset, long timestamp) throws InvalidJfrFileException {
        long key = NumberReaders.readKey(bytes, offset, this.keyType);
        return this.pool.get(key, timestamp);
    }

    @Override
    public ContentType<?> getValueType() {
        return this.pool.getContentType();
    }
}

