/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.parser.v0;

import com.oracle.jmc.common.unit.ContentType;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.flightrecorder.internal.InvalidJfrFileException;
import com.oracle.jmc.flightrecorder.internal.parser.v0.IValueReader;
import com.oracle.jmc.flightrecorder.internal.parser.v0.Offset;

final class CompositeReader
implements IValueReader {
    private final IValueReader[] readers;

    CompositeReader(IValueReader[] readers) {
        this.readers = readers;
    }

    @Override
    public Object readValue(byte[] bytes, Offset offset, long timestamp) throws InvalidJfrFileException {
        Object[] objects = new Object[this.readers.length];
        int n = 0;
        while (n < objects.length) {
            objects[n] = this.readers[n].readValue(bytes, offset, timestamp);
            ++n;
        }
        return objects;
    }

    @Override
    public ContentType<?> getValueType() {
        return UnitLookup.UNKNOWN;
    }
}

