/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.parser.v0;

import com.oracle.jmc.flightrecorder.internal.InvalidJfrFileException;
import com.oracle.jmc.flightrecorder.internal.parser.Chunk;
import com.oracle.jmc.flightrecorder.internal.util.DataInputToolkit;
import java.io.IOException;

class ChunkStructure {
    private final int metadataOffset;
    private final int bodyStartOffset;
    private final long chunkSize;

    ChunkStructure(Chunk input) throws InvalidJfrFileException, IOException {
        int position = input.getPosition();
        this.bodyStartOffset = position + 8;
        byte[] buffer = input.fill(this.bodyStartOffset);
        this.metadataOffset = (int)DataInputToolkit.readLong(buffer, position);
        buffer = input.fill(this.metadataOffset + 4);
        int metadataLength = DataInputToolkit.readInt(buffer, this.metadataOffset);
        this.chunkSize = this.metadataOffset + metadataLength;
    }

    int getBodyStartOffset() {
        return this.bodyStartOffset;
    }

    int getMetadataOffset() {
        return this.metadataOffset;
    }

    long getChunkSize() {
        return this.chunkSize;
    }
}

