/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.parser.v0;

import com.oracle.jmc.common.unit.DecimalPrefix;
import com.oracle.jmc.common.unit.IPrefix;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.LinearUnit;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.flightrecorder.internal.InvalidJfrFileException;
import com.oracle.jmc.flightrecorder.internal.parser.v0.NumberReaders;
import com.oracle.jmc.flightrecorder.internal.parser.v0.Offset;
import com.oracle.jmc.flightrecorder.internal.parser.v0.ProducerParser;
import com.oracle.jmc.flightrecorder.internal.parser.v0.TypedArrayParser;
import com.oracle.jmc.flightrecorder.internal.parser.v0.model.ProducerDescriptor;

class ChunkMetadata {
    private final ProducerDescriptor[] producers;
    private final IQuantity startTime;
    private final IQuantity endTime;
    private final long startTimeNanos;
    private final long startTicks;
    private final double ticksPerNano;
    private final int previousCheckPoint;
    private final LinearUnit ticksUnit;
    private static final TypedArrayParser<ProducerDescriptor> PRODUCERS_PARSER = new TypedArrayParser<ProducerDescriptor>(new ProducerParser());

    ChunkMetadata(byte[] data, int metadataOffset) throws InvalidJfrFileException {
        Offset offset = new Offset(data, metadataOffset);
        offset.increase(4);
        this.producers = PRODUCERS_PARSER.read(data, offset);
        long startTimeMillis = NumberReaders.readLong(data, offset);
        this.startTime = UnitLookup.EPOCHMILLIS.quantity(startTimeMillis);
        this.startTimeNanos = startTimeMillis * 1000L * 1000L;
        this.endTime = UnitLookup.EPOCHMILLIS.quantity(NumberReaders.readLong(data, offset));
        this.startTicks = NumberReaders.readLong(data, offset);
        this.ticksPerNano = (double)NumberReaders.readLong(data, offset) / 1.0E9;
        this.previousCheckPoint = (int)NumberReaders.readLong(data, offset);
        this.ticksUnit = UnitLookup.TIMESPAN.makeUnit("ticks", UnitLookup.TIMESPAN.getUnit((IPrefix)DecimalPrefix.NANO).quantity(1.0 / this.ticksPerNano));
    }

    ProducerDescriptor[] getProducers() {
        return this.producers;
    }

    IQuantity getStartTime() {
        return this.startTime;
    }

    IQuantity getEndTime() {
        return this.endTime;
    }

    long getStartTicks() {
        return this.startTicks;
    }

    LinearUnit getTicksUnit() {
        return this.ticksUnit;
    }

    int getPreviousCheckPoint() {
        return this.previousCheckPoint;
    }

    long asNanoTimestamp(long relativeTicks) {
        return this.startTimeNanos + (long)((double)(relativeTicks - this.startTicks) / this.ticksPerNano);
    }
}

