/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.parser.v0;

import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.IRange;
import com.oracle.jmc.common.unit.QuantityRange;
import com.oracle.jmc.flightrecorder.CouldNotLoadRecordingException;
import com.oracle.jmc.flightrecorder.internal.ChunkInfo;
import com.oracle.jmc.flightrecorder.internal.parser.Chunk;
import com.oracle.jmc.flightrecorder.internal.parser.LoaderContext;
import com.oracle.jmc.flightrecorder.internal.parser.v0.ChunkMetadata;
import com.oracle.jmc.flightrecorder.internal.parser.v0.ChunkStructure;
import com.oracle.jmc.flightrecorder.internal.parser.v0.EventParserManager;
import com.oracle.jmc.flightrecorder.internal.parser.v0.NumberReaders;
import com.oracle.jmc.flightrecorder.internal.parser.v0.Offset;
import com.oracle.jmc.flightrecorder.internal.parser.v0.ReaderFactory;
import java.io.IOException;
import java.util.concurrent.Callable;

public class ChunkLoaderV0
implements Callable<byte[]> {
    private final ChunkStructure structure;
    private final byte[] data;
    private final LoaderContext context;

    private ChunkLoaderV0(ChunkStructure structure, byte[] data, LoaderContext context) {
        this.structure = structure;
        this.data = data;
        this.context = context;
    }

    @Override
    public byte[] call() throws Exception {
        ChunkMetadata metadata = new ChunkMetadata(this.data, this.structure.getMetadataOffset());
        ReaderFactory readerFactory = new ReaderFactory(metadata, this.data, this.context);
        EventParserManager eventParser = new EventParserManager(readerFactory, this.context, metadata.getProducers());
        int nextEventIndex = this.structure.getBodyStartOffset();
        while (nextEventIndex < this.structure.getMetadataOffset()) {
            Offset offset = new Offset(this.data, nextEventIndex);
            nextEventIndex = offset.getEnd();
            int eventTypeId = NumberReaders.readInt(this.data, offset);
            if (eventTypeId == 0 || eventTypeId == 1) continue;
            eventParser.loadEvent(this.data, offset, eventTypeId);
        }
        return this.data;
    }

    public static Callable<byte[]> create(Chunk input, LoaderContext context) throws IOException, CouldNotLoadRecordingException {
        ChunkStructure structure = new ChunkStructure(input);
        byte[] buffer = input.fill(structure.getChunkSize());
        return new ChunkLoaderV0(structure, buffer, context);
    }

    public static ChunkInfo getInfo(Chunk input, long position) throws IOException, CouldNotLoadRecordingException {
        ChunkStructure structure = new ChunkStructure(input);
        byte[] buffer = input.fill(structure.getChunkSize());
        ChunkMetadata metadata = new ChunkMetadata(buffer, structure.getMetadataOffset());
        return new ChunkInfo(position, structure.getChunkSize(), (IRange<IQuantity>)QuantityRange.createWithEnd((IQuantity)metadata.getStartTime(), (IQuantity)metadata.getEndTime()));
    }
}

