/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.parser.v0;

import com.oracle.jmc.common.unit.ContentType;
import com.oracle.jmc.common.unit.UnitLookup;
import com.oracle.jmc.flightrecorder.internal.InvalidJfrFileException;
import com.oracle.jmc.flightrecorder.internal.parser.v0.IValueReader;
import com.oracle.jmc.flightrecorder.internal.parser.v0.Offset;
import com.oracle.jmc.flightrecorder.internal.parser.v0.model.DataType;
import com.oracle.jmc.flightrecorder.internal.util.DataInputToolkit;

final class ArrayReader
implements IValueReader {
    private final IValueReader reader;
    private static final int UNREASONABLE_ARRAY_LENGTH = 10000000;

    ArrayReader(IValueReader reader) {
        this.reader = reader;
    }

    @Override
    public Object readValue(byte[] bytes, Offset offset, long timestamp) throws InvalidJfrFileException {
        int arraySize = ArrayReader.readArraySize(bytes, offset.get());
        offset.increase(DataType.INTEGER.getSize());
        Object[] array = new Object[arraySize];
        int n = 0;
        while (n < arraySize) {
            array[n] = this.reader.readValue(bytes, offset, timestamp);
            ++n;
        }
        return array;
    }

    private static int readArraySize(byte[] data, int offset) throws InvalidJfrFileException {
        int length = DataInputToolkit.readInt(data, offset);
        if (length < 0 || length > 10000000) {
            throw new InvalidJfrFileException();
        }
        return length;
    }

    @Override
    public ContentType<?> getValueType() {
        return UnitLookup.UNKNOWN;
    }
}

