/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.parser;

import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.collection.SimpleArray;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.common.unit.StructContentType;
import com.oracle.jmc.flightrecorder.JfrAttributes;
import com.oracle.jmc.flightrecorder.internal.parser.ItemBuilder;
import com.oracle.jmc.flightrecorder.internal.util.DisjointBuilder;
import com.oracle.jmc.flightrecorder.parser.IEventSink;
import com.oracle.jmc.flightrecorder.parser.IEventSinkFactory;
import com.oracle.jmc.flightrecorder.parser.ValueField;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

class RepositoryBuilder
implements IEventSinkFactory {
    private static final Logger LOGGER = Logger.getLogger(RepositoryBuilder.class.getName());
    private final Map<String, EventTypeEntry> eventTypes = new HashMap<String, EventTypeEntry>();
    private static final DisjointBuilder.ArrayFactory<IItem> ARRAY_FACTORY = new DisjointBuilder.ArrayFactory<IItem>(){

        public IItem[] createArray(int size) {
            return new IItem[size];
        }
    };

    RepositoryBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IEventSink create(String identifier, String label, String[] category, String description, List<ValueField> dataStructure) {
        Map<String, EventTypeEntry> map = this.eventTypes;
        synchronized (map) {
            EventTypeEntry eventTypeEntry = this.eventTypes.get(identifier);
            if (eventTypeEntry == null) {
                eventTypeEntry = RepositoryBuilder.createEventTypeEntry(identifier, label, category, description, dataStructure);
                this.eventTypes.put(identifier, eventTypeEntry);
                return eventTypeEntry.createSink();
            }
            while (true) {
                if (eventTypeEntry.isCompatibleWith(dataStructure)) {
                    return eventTypeEntry.createSink();
                }
                if (eventTypeEntry.next == null) {
                    eventTypeEntry.next = RepositoryBuilder.createEventTypeEntry(String.valueOf(identifier) + UUID.randomUUID().toString(), label, category, description, dataStructure);
                    LOGGER.log(Level.WARNING, MessageFormat.format("Created new event type entry for {0} because the fields did not match those of the previously created one. New identifier is {1}", identifier, ((EventTypeEntry)eventTypeEntry).next.eventType.getIdentifier()));
                    return eventTypeEntry.next.createSink();
                }
                eventTypeEntry = eventTypeEntry.next;
            }
        }
    }

    private static EventTypeEntry createEventTypeEntry(String identifier, String label, String[] category, String description, List<ValueField> dataStructure) {
        StructContentType eventType = new StructContentType(identifier, label, description);
        ItemBuilder.IItemFactory itemFactory = ItemBuilder.createItemFactory((StructContentType<IItem>)eventType, dataStructure);
        IMemberAccessor stAccessor = JfrAttributes.START_TIME.getAccessor((IType)eventType);
        IMemberAccessor etAccessor = JfrAttributes.END_TIME.getAccessor((IType)eventType);
        if (stAccessor != null && stAccessor != etAccessor) {
            return new DurationEventTypeEntry((StructContentType<IItem>)eventType, category, itemFactory, dataStructure, (IMemberAccessor<IQuantity, IItem>)stAccessor, (IMemberAccessor<IQuantity, IItem>)etAccessor);
        }
        return new InstantEventTypeEntry((StructContentType<IItem>)eventType, category, itemFactory, dataStructure, (IMemberAccessor<IQuantity, IItem>)etAccessor);
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<EventTypeEntry> getEventTypes() {
        Map<String, EventTypeEntry> map = this.eventTypes;
        synchronized (map) {
            final Iterator<EventTypeEntry> it = this.eventTypes.values().iterator();
            return new Iterator<EventTypeEntry>(){
                private EventTypeEntry rem;

                @Override
                public boolean hasNext() {
                    return this.rem != null || it.hasNext();
                }

                @Override
                public EventTypeEntry next() {
                    EventTypeEntry tmp = this.rem == null ? (EventTypeEntry)it.next() : this.rem;
                    this.rem = tmp.next;
                    return tmp;
                }

                @Override
                public final void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class DurationEventTypeEntry
    extends EventTypeEntry {
        private final List<DisjointBuilder<IItem>> eventsLanes = new ArrayList<DisjointBuilder<IItem>>();
        private final IMemberAccessor<IQuantity, IItem> startAccessor;
        private final IMemberAccessor<IQuantity, IItem> endAccessor;

        public DurationEventTypeEntry(StructContentType<IItem> eventType, String[] category, ItemBuilder.IItemFactory itemFactory, List<ValueField> dataStructure, IMemberAccessor<IQuantity, IItem> startAccessor, IMemberAccessor<IQuantity, IItem> endAccessor) {
            super(eventType, category, itemFactory, dataStructure);
            this.startAccessor = startAccessor;
            this.endAccessor = endAccessor;
        }

        @Override
        synchronized Collection<IItem[]> buildSortedArrays() {
            return DisjointBuilder.toArrays(this.eventsLanes, ARRAY_FACTORY);
        }

        private synchronized DisjointBuilder<IItem> createLane() {
            DisjointBuilder<IItem> lane = new DisjointBuilder<IItem>(this.startAccessor, this.endAccessor);
            this.eventsLanes.add(lane);
            return lane;
        }

        @Override
        public IEventSink createSink() {
            return new IEventSink(){
                private final DisjointBuilder<IItem> events;
                {
                    this.events = DurationEventTypeEntry.this.createLane();
                }

                @Override
                public void addEvent(Object ... values) {
                    this.events.add(DurationEventTypeEntry.this.itemFactory.createEvent(values));
                }
            };
        }
    }

    static abstract class EventTypeEntry {
        final StructContentType<IItem> eventType;
        final String[] category;
        final ItemBuilder.IItemFactory itemFactory;
        final List<ValueField> dataStructure;
        private EventTypeEntry next;

        public EventTypeEntry(StructContentType<IItem> eventType, String[] category, ItemBuilder.IItemFactory itemFactory, List<ValueField> dataStructure) {
            this.eventType = eventType;
            this.category = category;
            this.itemFactory = itemFactory;
            this.dataStructure = dataStructure;
        }

        private boolean isCompatibleWith(List<ValueField> fields) {
            if (this.dataStructure.size() == fields.size()) {
                int i = 0;
                while (i < this.dataStructure.size()) {
                    ValueField vf1 = this.dataStructure.get(i);
                    ValueField vf2 = fields.get(i);
                    if (!vf1.getIdentifier().equals(vf2.getIdentifier()) || !vf1.getContentType().equals(vf2.getContentType())) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        abstract Collection<IItem[]> buildSortedArrays();

        abstract IEventSink createSink();
    }

    private static class InstantEventTypeEntry
    extends EventTypeEntry {
        private final List<SimpleArray<IItem>> eventsLanes = new ArrayList<SimpleArray<IItem>>();
        private final IMemberAccessor<IQuantity, IItem> order;

        public InstantEventTypeEntry(StructContentType<IItem> eventType, String[] category, ItemBuilder.IItemFactory itemFactory, List<ValueField> dataStructure, IMemberAccessor<IQuantity, IItem> order) {
            super(eventType, category, itemFactory, dataStructure);
            this.order = order;
        }

        @Override
        synchronized Collection<IItem[]> buildSortedArrays() {
            int eventCount = 0;
            for (SimpleArray<IItem> a : this.eventsLanes) {
                eventCount += a.size();
            }
            if (eventCount == 0) {
                return Collections.emptyList();
            }
            Object[] events = new IItem[eventCount];
            int offset = 0;
            for (SimpleArray<IItem> a : this.eventsLanes) {
                a.copyTo(offset, events);
                offset += a.size();
            }
            if (this.order != null) {
                Arrays.sort(events, new Comparator<IItem>(){

                    @Override
                    public int compare(IItem o1, IItem o2) {
                        return ((IQuantity)InstantEventTypeEntry.this.order.getMember((Object)o1)).compareTo((Object)((IQuantity)InstantEventTypeEntry.this.order.getMember((Object)o2)));
                    }
                });
            }
            return Arrays.asList(new IItem[][]{events});
        }

        private synchronized SimpleArray<IItem> createLane() {
            SimpleArray lane = new SimpleArray((Object[])new IItem[3]);
            this.eventsLanes.add((SimpleArray<IItem>)lane);
            return lane;
        }

        @Override
        public IEventSink createSink() {
            return new IEventSink(){
                private final SimpleArray<IItem> events;
                {
                    this.events = InstantEventTypeEntry.this.createLane();
                }

                @Override
                public void addEvent(Object ... values) {
                    this.events.add((Object)InstantEventTypeEntry.this.itemFactory.createEvent(values));
                }
            };
        }
    }
}

