/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.internal.model;

import com.oracle.jmc.common.IMCThread;
import com.oracle.jmc.flightrecorder.messages.internal.Messages;

public final class JfrThread
implements IMCThread {
    private final int m_platformId;
    private volatile String m_name;
    private volatile String m_threadGroupName;
    private volatile Long m_javaId;

    public JfrThread(int platformId) {
        this.m_platformId = platformId;
    }

    public Long getJavaId() {
        return this.m_javaId;
    }

    public synchronized void addJavaId(long javaId) {
        this.m_javaId = JfrThread.getAny(this.m_javaId, javaId);
    }

    public String getName() {
        return this.m_name;
    }

    public synchronized void addName(String name) {
        this.m_name = JfrThread.getAny(this.m_name, name);
    }

    public int getPlatformId() {
        return this.m_platformId;
    }

    public String toString() {
        return this.getThreadName();
    }

    public Long getThreadId() {
        return this.getJavaId();
    }

    public String getThreadName() {
        return this.m_name == null ? Messages.getString("JfrThread_UNKNOWN_THREAD_NAME") : this.m_name;
    }

    public String getThreadGroupName() {
        return this.m_threadGroupName == null ? Messages.getString("JfrThread_UNKNOWN_THREAD_GROUP") : this.m_threadGroupName;
    }

    public synchronized void addThreadGroupName(String threadGroupName) {
        this.m_threadGroupName = JfrThread.getAny(this.m_threadGroupName, threadGroupName);
    }

    public int hashCode() {
        return this.m_platformId;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof JfrThread && this.m_platformId == ((JfrThread)obj).m_platformId;
    }

    private static <T extends Comparable<T>> T getAny(T a, T b) {
        if (a == null || b != null && a.compareTo(b) < 0) {
            return b;
        }
        return a;
    }
}

