/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder;

import com.oracle.jmc.common.IDescribable;
import com.oracle.jmc.common.IMCFrame;
import com.oracle.jmc.common.IMCMethod;
import com.oracle.jmc.common.IMCStackTrace;
import com.oracle.jmc.common.IMCType;
import com.oracle.jmc.common.IMemberAccessor;
import com.oracle.jmc.common.item.IAccessorKey;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemIterable;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.item.ItemToolkit;
import com.oracle.jmc.common.unit.IQuantity;
import com.oracle.jmc.flightrecorder.CouldNotLoadRecordingException;
import com.oracle.jmc.flightrecorder.JfrLoaderToolkit;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Map;

public final class RecordingPrinter {
    private final Verbosity verbosity;
    private final boolean formatValues;
    private final PrintWriter out;

    public RecordingPrinter(PrintWriter output, Verbosity verbosity, boolean formatValues) {
        this.out = output;
        this.verbosity = verbosity;
        this.formatValues = formatValues;
    }

    public static void main(String[] args) throws IOException, InterruptedException, CouldNotLoadRecordingException {
        if (args.length > 0) {
            IItemCollection events = JfrLoaderToolkit.loadEvents(new File(args[args.length - 1]));
            try {
                RecordingPrinter printer = RecordingPrinter.buildFromOptions(new PrintWriter(System.out), args);
                printer.print(events);
                return;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        RecordingPrinter.printHelp();
    }

    public void print(IItemCollection events) {
        this.out.println("<?xml version=\"1.0\"?>");
        Iterator itemIterable = events.iterator();
        while (itemIterable.hasNext()) {
            Iterator itemIterator = ((IItemIterable)itemIterable.next()).iterator();
            while (itemIterator.hasNext()) {
                this.printEvent((IItem)itemIterator.next());
                this.out.println();
            }
        }
        this.out.flush();
    }

    private static RecordingPrinter buildFromOptions(PrintWriter output, String[] args) throws ParseException {
        Verbosity verbosity = Verbosity.HIGH;
        boolean formatValues = false;
        int n = 0;
        while (n < args.length - 1) {
            if (args[n].equals("-formatValues")) {
                formatValues = true;
            } else if (args[n].equals("-brief")) {
                verbosity = Verbosity.LOW;
            } else {
                throw new ParseException("Unknown command " + args[n], n);
            }
            ++n;
        }
        return new RecordingPrinter(output, verbosity, formatValues);
    }

    private static void printHelp() {
        System.out.println("Usage:");
        System.out.println("filename The name of the flight recording file to print.");
    }

    public void printEvent(IItem e) {
        this.out.println("<event name=\"" + e.getType().getName() + "\" path=\"" + e.getType().getIdentifier() + "\">");
        if (this.verbosity != Verbosity.LOW) {
            this.printValues(e);
        }
        this.out.print("</event>");
    }

    private void printValues(IItem event) {
        IType itemType = ItemToolkit.getItemType((IItem)event);
        for (Map.Entry e : itemType.getAccessorKeys().entrySet()) {
            IMemberAccessor accessor = itemType.getAccessor((IAccessorKey)e.getKey());
            this.printValue((IAccessorKey)e.getKey(), (IDescribable)e.getValue(), accessor.getMember((Object)event));
        }
    }

    private void printValue(IAccessorKey<?> attribute, IDescribable desc, Object value) {
        if (value instanceof IMCStackTrace) {
            this.printTrace((IMCStackTrace)value);
        } else {
            this.out.print("  <" + attribute.getIdentifier() + " name=\"" + desc.getName() + "\">");
            if (value == null) {
                this.out.print("null");
            } else {
                this.out.print(this.stringify("", value));
            }
            this.out.println("</" + attribute.getIdentifier() + ">");
        }
    }

    private String stringify(String indent, Object value) {
        if (value instanceof IMCMethod) {
            return String.valueOf(indent) + RecordingPrinter.stringifyMethod((IMCMethod)value);
        }
        if (value instanceof IMCType) {
            return String.valueOf(indent) + RecordingPrinter.stringifyType((IMCType)value);
        }
        if (value instanceof IQuantity) {
            if (this.formatValues) {
                return ((IQuantity)value).displayUsing("auto");
            }
            return ((IQuantity)value).persistableString();
        }
        if (value instanceof IDescribable) {
            String name = ((IDescribable)value).getName();
            return name != null ? name : value.toString();
        }
        if (value == null) {
            return "null";
        }
        if (value.getClass().isArray()) {
            StringBuffer buffer = new StringBuffer();
            Object[] values = (Object[])value;
            buffer.append(" [" + values.length + "]");
            Object[] objectArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                buffer.append(indent);
                buffer.append(this.stringify(String.valueOf(indent) + "  ", o));
                ++n2;
            }
            return buffer.toString();
        }
        return value.toString();
    }

    private void printTrace(IMCStackTrace trace) {
        this.out.println("  <stackTrace>");
        if (this.verbosity == Verbosity.HIGH) {
            for (IMCFrame frame : trace.getFrames()) {
                RecordingPrinter.printFrame("     ", frame, this.out);
            }
        }
        this.out.println("  </stackTrace>");
    }

    private static void printFrame(String indent, IMCFrame frame, PrintWriter out) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(indent);
        buffer.append("<frame ");
        Integer lineNumber = frame.getFrameLineNumber();
        IMCMethod method = frame.getMethod();
        buffer.append("method=\"");
        if (method != null) {
            buffer.append(RecordingPrinter.stringifyMethod(method));
        } else {
            buffer.append("null");
        }
        buffer.append(" line=\"");
        buffer.append(String.valueOf(lineNumber));
        buffer.append("\" type=\"" + frame.getType() + "\"/>");
        out.println(buffer.toString());
    }

    private static String stringifyType(IMCType type) {
        StringBuffer sb = new StringBuffer();
        String packageName = type.getPackageName();
        if (packageName == null) {
            sb.append("null");
        } else {
            sb.append(RecordingPrinter.formatPackageName(packageName));
        }
        sb.append(".");
        sb.append(String.valueOf(type.getTypeName()));
        return sb.toString();
    }

    private static String stringifyMethod(IMCMethod method) {
        StringBuffer buffer = new StringBuffer();
        Integer modifier = method.getModifier();
        buffer.append(RecordingPrinter.formatPackageName(method.getType().getPackageName()));
        buffer.append(".");
        buffer.append(method.getType().getTypeName());
        buffer.append("#");
        buffer.append(method.getMethodName());
        buffer.append(method.getFormalDescriptor());
        buffer.append("\"");
        if (modifier != null) {
            buffer.append(" modifier=\"");
            buffer.append(Modifier.toString(method.getModifier()));
            buffer.append("\"");
        }
        return buffer.toString();
    }

    private static String formatPackageName(String packageName) {
        if (packageName.length() == 0) {
            return "(default package)";
        }
        return packageName;
    }

    public static enum Verbosity {
        HIGH,
        MEDIUM,
        LOW;

    }
}

