/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder;

import com.oracle.jmc.common.io.IOToolkit;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.flightrecorder.CouldNotLoadRecordingException;
import com.oracle.jmc.flightrecorder.EventCollection;
import com.oracle.jmc.flightrecorder.internal.EventArray;
import com.oracle.jmc.flightrecorder.internal.FlightRecordingLoader;
import com.oracle.jmc.flightrecorder.parser.IParserExtension;
import com.oracle.jmc.flightrecorder.parser.ParserExtensionRegistry;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class JfrLoaderToolkit {
    private static EventArray[] loadFile(File file, List<? extends IParserExtension> extensions) throws IOException, CouldNotLoadRecordingException {
        InputStream stream = IOToolkit.openUncompressedStream((File)file);
        try {
            EventArray[] eventArrayArray = FlightRecordingLoader.loadStream(stream, extensions, false);
            return eventArrayArray;
        }
        finally {
            IOToolkit.closeSilently((Closeable)stream);
        }
    }

    public static IItemCollection loadEvents(File file) throws IOException, CouldNotLoadRecordingException {
        return JfrLoaderToolkit.loadEvents(file, ParserExtensionRegistry.getParserExtensions());
    }

    public static IItemCollection loadEvents(File file, List<? extends IParserExtension> extensions) throws IOException, CouldNotLoadRecordingException {
        return EventCollection.build(JfrLoaderToolkit.loadFile(file, extensions));
    }
}

