/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder;

import com.oracle.jmc.common.IPredicate;
import com.oracle.jmc.common.collection.IteratorToolkit;
import com.oracle.jmc.common.item.IAggregator;
import com.oracle.jmc.common.item.IItem;
import com.oracle.jmc.common.item.IItemCollection;
import com.oracle.jmc.common.item.IItemConsumer;
import com.oracle.jmc.common.item.IItemFilter;
import com.oracle.jmc.common.item.IItemIterable;
import com.oracle.jmc.common.item.IType;
import com.oracle.jmc.common.util.PredicateToolkit;
import com.oracle.jmc.flightrecorder.internal.EventArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class EventCollection
implements IItemCollection {
    private final Set<IType<IItem>> types = new HashSet<IType<IItem>>();
    private final ArrayList<EventTypeEntry> items;

    static IItemCollection build(EventArray[] events) {
        ArrayList<EventTypeEntry> items = new ArrayList<EventTypeEntry>(events.length);
        EventArray[] eventArrayArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            EventArray ea = eventArrayArray[n2];
            EventTypeEntry entry = new EventTypeEntry(ea);
            items.add(entry);
            ++n2;
        }
        return new EventCollection(items);
    }

    private EventCollection(ArrayList<EventTypeEntry> items) {
        this.items = items;
        for (EventTypeEntry e : items) {
            this.types.add(e.events.getType());
        }
    }

    public EventCollection apply(IItemFilter filter) {
        ArrayList<EventTypeEntry> newEntries = new ArrayList<EventTypeEntry>();
        for (EventTypeEntry e : this.items) {
            IItemIterable newEntry = e.apply(filter.getPredicate(e.events.getType()));
            if (PredicateToolkit.isTrueGuaranteed(newEntry.predicate)) {
                newEntries.add(e);
                continue;
            }
            if (PredicateToolkit.isFalseGuaranteed(newEntry.predicate)) continue;
            newEntries.add((EventTypeEntry)newEntry);
        }
        return new EventCollection(newEntries);
    }

    private static Iterator<IItem> buildIterator(IItem[] array, IPredicate<? super IItem> filter) {
        if (EventCollection.isFiltered(filter)) {
            return IteratorToolkit.filter((Iterator)IteratorToolkit.of((Object[])array), filter);
        }
        return IteratorToolkit.of((Object[])array);
    }

    private static boolean isFiltered(IPredicate<?> filter) {
        return filter != null && !PredicateToolkit.isTrueGuaranteed(filter);
    }

    public Iterator<IItemIterable> iterator() {
        return Collections.unmodifiableList(this.items).iterator();
    }

    public boolean hasItems() {
        Iterator<EventTypeEntry> ii = this.items.iterator();
        while (ii.hasNext()) {
            if (!((IItemIterable)ii.next()).iterator().hasNext()) continue;
            return true;
        }
        return false;
    }

    public <V, C extends IItemConsumer<C>> V getAggregate(IAggregator<V, C> aggregator) {
        return EventCollection.aggregate(aggregator, this.items.iterator());
    }

    private static <V, C extends IItemConsumer<C>> V aggregate(final IAggregator<V, C> aggregator, final Iterator<? extends IItemIterable> items) {
        return (V)aggregator.getValue((Object)new Iterator<C>(){
            IItemIterable next = this.findNext();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public C next() {
                IItemConsumer calc = aggregator.newItemConsumer(this.next.getType());
                Iterator iterator = this.next.iterator();
                while (iterator.hasNext()) {
                    calc.consume((IItem)iterator.next());
                }
                this.next = this.findNext();
                return calc;
            }

            IItemIterable findNext() {
                while (items.hasNext()) {
                    IItemIterable ii = (IItemIterable)items.next();
                    if (!aggregator.acceptType(ii.getType())) continue;
                    return ii;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }

    private static class EventTypeEntry
    implements IItemIterable {
        final EventArray events;
        final IPredicate<IItem> predicate;

        EventTypeEntry(EventArray events) {
            this.events = events;
            this.predicate = PredicateToolkit.truePredicate();
        }

        EventTypeEntry(EventArray events, IPredicate<IItem> predicate) {
            this.events = events;
            this.predicate = predicate;
        }

        public IType<IItem> getType() {
            return this.events.getType();
        }

        public Iterator<IItem> iterator() {
            return EventCollection.buildIterator(this.events.getEvents(), (IPredicate<? super IItem>)this.predicate);
        }

        public boolean hasItems() {
            return this.iterator().hasNext();
        }

        public long getItemCount() {
            if (EventCollection.isFiltered(this.predicate)) {
                long c = 0L;
                Iterator<IItem> it = this.iterator();
                while (it.hasNext()) {
                    it.next();
                    ++c;
                }
                return c;
            }
            return this.events.getEvents().length;
        }

        public EventTypeEntry apply(IPredicate<IItem> filter) {
            IPredicate newPredicate = PredicateToolkit.and(Arrays.asList(filter, this.predicate));
            return new EventTypeEntry(this.events, (IPredicate<IItem>)newPredicate);
        }
    }
}

