/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.hirt.greychart.AbstractAxis;
import se.hirt.greychart.GreyChartPanel;
import se.hirt.greychart.TickDensity;
import se.hirt.greychart.TickFormatter;
import se.hirt.greychart.YAxis;
import se.hirt.greychart.impl.DefaultXYGreyChart;
import se.hirt.greychart.impl.DoubleFormatter;
import se.hirt.greychart.impl.OptimizingProvider;
import se.hirt.greychart.util.ChartRenderingToolkit;

public class DefaultYAxis
extends AbstractAxis
implements YAxis {
    private static final double RELATIVE_TICK_SIZE = 0.25;
    private boolean m_markZero = true;
    private Number m_tickSize;
    private double m_autoPadding;
    private boolean m_alwaysShowZero = true;
    private boolean m_autoRangeEnabled;
    private YAxis.Position m_position;
    private boolean m_titleLegendEnabled;
    private String m_contentType;
    private double m_oldMax;
    private double m_oldMin;
    private String m_oldContentType;
    private TickDensity m_oldTickDensity;
    private TickFormatter m_oldFormatter;
    private int m_oldDrawingAreaHeight;
    private int m_oldYAxisHeight;
    private double m_tickInterval;
    private List m_tickLabels = new ArrayList();
    private int m_minimumWidth;

    public DefaultYAxis(DefaultXYGreyChart owner) {
        super(owner);
        this.setTickMarksEnabled(true);
        this.setNumberOfTicks(10);
        this.setPaintGridLinesEnabled(true);
        this.setFormatter(new DoubleFormatter());
    }

    @Override
    protected DefaultXYGreyChart getOwner() {
        return (DefaultXYGreyChart)super.getOwner();
    }

    @Override
    public void render(Graphics2D ctx, Rectangle targetArea, Rectangle plotRect) {
        this.setRenderedBounds(targetArea);
        if (targetArea.width <= 0 || targetArea.height <= 0) {
            return;
        }
        AffineTransform originalTrans = ctx.getTransform();
        if (GreyChartPanel.DEBUG) {
            ChartRenderingToolkit.markBoundary(ctx, targetArea.x, targetArea.y, targetArea.width, targetArea.height, Color.BLUE);
        }
        ctx.translate(targetArea.x, targetArea.y);
        AffineTransform labelTrans = ctx.getTransform();
        this.drawBackground(ctx, targetArea);
        this.drawAxisLine(ctx);
        if (this.isTickMarksEnabled()) {
            Font oldfont = ctx.getFont();
            ctx.setFont(this.getFontToUse(oldfont));
            FontMetrics fm = ctx.getFontMetrics();
            int titleHeight = -1;
            if (this.hasTitle()) {
                titleHeight = this.getMaxHeight(fm);
            }
            this.paintTickMarks(ctx, fm, plotRect, targetArea, titleHeight);
            if (this.hasTitle()) {
                this.paintTitle(ctx, labelTrans, this.getTitleTransform(ctx, targetArea, originalTrans, labelTrans));
            }
            ctx.setFont(oldfont);
        }
        ctx.setTransform(originalTrans);
    }

    private void drawBackground(Graphics2D ctx, Rectangle targetArea) {
        ctx.setColor(this.getBackground());
        ctx.fillRect(0, 0, targetArea.width, targetArea.height);
    }

    private void drawAxisLine(Graphics2D ctx) {
        ctx.setColor(this.getForeground());
        if (this.getPosition() == YAxis.Position.LEFT) {
            ctx.drawLine(this.getRenderedWidth(), 0, this.getRenderedWidth(), this.getRenderedHeight());
        } else {
            ctx.drawLine(0, 0, 0, this.getRenderedHeight());
        }
    }

    private void paintTitle(Graphics2D ctx, AffineTransform labelTrans, AffineTransform titleTrans) {
        ctx.setTransform(titleTrans);
        ctx.setColor(this.getTitleColor());
        int boxSize = Math.max(2, ctx.getFontMetrics().getHeight() / 2);
        int padding = Math.max(1, Math.round((float)boxSize * 0.5f));
        Rectangle titleBounds = ctx.getFontMetrics().getStringBounds(this.getTitle(), ctx).getBounds();
        int textWidth = titleBounds.width;
        OptimizingProvider[] providers = new OptimizingProvider[]{};
        OptimizingProvider yAxisProvider = this.getOwner().getYAxisProvider(this.getPosition());
        if (yAxisProvider != null) {
            providers = yAxisProvider.getChildren();
        }
        if (this.isTitleLegendEnabled()) {
            titleBounds.width += (boxSize + padding) * providers.length;
        }
        int yPosition = this.getPosition() == YAxis.Position.LEFT ? -titleBounds.y : this.getRenderedWidth() - ctx.getFontMetrics().getMaxDescent();
        ctx.drawString(this.getTitle(), -titleBounds.width / 2, yPosition);
        if (this.isTitleLegendEnabled()) {
            this.drawTitleLegend(ctx, providers, padding, textWidth + padding - titleBounds.width / 2, yPosition - boxSize, boxSize);
        }
        ctx.setTransform(labelTrans);
    }

    private AffineTransform getTitleTransform(Graphics2D ctx, Rectangle targetArea, AffineTransform originalTrans, AffineTransform labelTrans) {
        ctx.setTransform(originalTrans);
        ctx.translate(targetArea.x, targetArea.y + targetArea.height / 2);
        ctx.rotate(-1.5707963267948966);
        AffineTransform titleTrans = ctx.getTransform();
        ctx.setTransform(labelTrans);
        return titleTrans;
    }

    private void drawTitleLegend(Graphics2D ctx, OptimizingProvider[] optimizingProviders, int padding, int startX, int startY, int boxSize) {
        OptimizingProvider[] optimizingProviderArray = optimizingProviders;
        int n = optimizingProviders.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            Color fillColor = this.getOwner().getMetadataProvider().getTopColor(provider.getDataSeries());
            if (fillColor == null) {
                fillColor = this.getOwner().getMetadataProvider().getLineColor(provider.getDataSeries());
            }
            fillColor = fillColor == null ? this.getBackground() : fillColor;
            Color lineColor = this.getForeground();
            ctx.setColor(fillColor);
            ctx.fillRect(startX, startY, boxSize, boxSize);
            ctx.setColor(lineColor);
            ctx.drawRect(startX, startY, boxSize, boxSize);
            startX += boxSize + padding;
            ++n2;
        }
    }

    private double getNiceMinTick(double min) {
        return Math.ceil(min / this.m_tickInterval) * this.m_tickInterval;
    }

    private double getNiceMaxTick(double min, double max) {
        return ChartRenderingToolkit.fastFloor((max - min) / this.m_tickInterval) * this.m_tickInterval + min;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private void paintTickMarks(Graphics2D ctx, FontMetrics fm, Rectangle plotRect, Rectangle targetArea, int titleHeight) {
        block6: {
            double d;
            double tickVal;
            int i;
            double maxPlotValue;
            int tickSize;
            double min;
            block5: {
                double max;
                if (this.hasContentChanged() || targetArea.height != this.m_oldYAxisHeight) {
                    this.calculateAndGenerateTickLabels(fm, targetArea);
                    this.m_oldYAxisHeight = targetArea.height;
                }
                if ((max = this.getNiceMaxTick(min = this.getNiceMinTick(this.getMin().doubleValue()), this.getMax().doubleValue())) == min) {
                    this.m_tickInterval = Math.max(Math.abs(max), 1.0);
                }
                tickSize = this.calculateTickSize(targetArea, titleHeight, this.getMaxHeight(fm));
                maxPlotValue = max;
                i = 0;
                if (!true) break block5;
                tickVal = min + (double)i * this.m_tickInterval;
                if (!(d <= maxPlotValue) || i >= this.m_tickLabels.size()) break block6;
            }
            do {
                int y = this.convertAxisValueToDrawingCoordinate(tickVal);
                this.paintTick(ctx, tickSize, tickVal, y);
                if (this.isPaintGridLinesEnabled()) {
                    this.paintGridLine(ctx, plotRect, tickSize, tickVal, y);
                }
                this.drawLabel(ctx, fm, (String)this.m_tickLabels.get(i), tickSize, y);
                ++i;
                tickVal = min + (double)i * this.m_tickInterval;
            } while (d <= maxPlotValue && i < this.m_tickLabels.size());
        }
    }

    private boolean hasContentChanged() {
        return this.getMax().doubleValue() != this.m_oldMax || this.getMin().doubleValue() != this.m_oldMin || this.m_oldContentType == null || !this.m_oldContentType.equals(this.getContentType()) || this.getTickDensity() != this.m_oldTickDensity || this.getFormatter() != this.m_oldFormatter;
    }

    private void calculateAndGenerateTickLabels(FontMetrics fm, Rectangle targetArea) {
        double max = this.getMax().doubleValue();
        double min = this.getMin().doubleValue();
        String contentType = this.getContentType();
        int fontHeight = fm.getMaxAscent();
        double minTickDistance = max - this.convertDrawingCoordinateToAxisValue(Math.max(this.getMinTickDistance(), fontHeight), targetArea.height);
        double coarseTickDistance = this.calculateCoarseTickDistance(max - min, max - this.convertDrawingCoordinateToAxisValue(fontHeight, targetArea.height));
        this.m_tickInterval = this.calculateNiceTickDistance(Math.max(coarseTickDistance, minTickDistance), minTickDistance);
        this.generateTickLabels(max, min);
        this.m_oldMax = max;
        this.m_oldMin = min;
        this.m_oldContentType = contentType;
        this.m_oldTickDensity = this.getTickDensity();
        this.m_oldFormatter = this.getFormatter();
    }

    private double calculateCoarseTickDistance(double height, double fontHeight) {
        TickDensity density = this.getTickDensity();
        switch (density) {
            case VERY_SPARSE: {
                return fontHeight * 5.0;
            }
            case SPARSE: {
                return fontHeight * 3.5;
            }
            case NORMAL: {
                return fontHeight * 2.5;
            }
            case DENSE: {
                return fontHeight * 1.7;
            }
            case VERY_DENSE: {
                return fontHeight * 1.0;
            }
        }
        return height / (double)this.getNumberOfTicks();
    }

    private void drawLabel(Graphics2D ctx, FontMetrics fm, String text, int tickSize, int y) {
        Rectangle bounds = fm.getStringBounds(text, ctx).getBounds();
        int xPosition = this.getPosition() == YAxis.Position.LEFT ? this.getRenderedWidth() - tickSize * 2 - bounds.width : tickSize * 2;
        ctx.drawString(text, xPosition, y - bounds.height / 2 - bounds.y);
    }

    private void paintTick(Graphics2D ctx, int tickSize, double tickVal, int y) {
        if (this.getPosition() == YAxis.Position.LEFT) {
            ctx.drawLine(this.getRenderedWidth() - tickSize, y, this.getRenderedWidth() + tickSize, y);
        } else {
            ctx.drawLine(0 - tickSize, y, 0 + tickSize, y);
        }
    }

    private void paintGridLine(Graphics2D ctx, Rectangle plotRect, int tickSize, double tickVal, int y) {
        Stroke oldStroke = ctx.getStroke();
        if (this.m_markZero && tickVal == 0.0) {
            ctx.setColor(this.getForeground());
        } else {
            ctx.setColor(this.getTitleColor());
        }
        ctx.setStroke(DASH_STROKE);
        if (this.getPosition() == YAxis.Position.LEFT) {
            ctx.drawLine(this.getRenderedWidth() + tickSize, y, plotRect.width + plotRect.x, y);
        } else {
            ctx.drawLine(0 - plotRect.width, y, 0 - tickSize, y);
        }
        ctx.setColor(this.getForeground());
        ctx.setStroke(oldStroke);
    }

    private int calculateTickSize(Rectangle targetArea, int titleHeight, int labelHeight) {
        int tickSize;
        if (this.m_tickSize != null) {
            tickSize = this.m_tickSize.intValue();
        } else {
            tickSize = (int)((double)labelHeight * 0.25);
            if (titleHeight != -1) {
                int width = targetArea.width - titleHeight;
                tickSize = Math.min(tickSize, (int)((double)width * 0.5));
            }
        }
        tickSize = Math.max(tickSize, 1);
        return tickSize;
    }

    @Override
    public double convertDrawingCoordinateToAxisValue(int coordinate) {
        return this.convertDrawingCoordinateToAxisValue(coordinate, this.getRenderedHeight());
    }

    private double convertDrawingCoordinateToAxisValue(int coordinate, int renderedHeight) {
        return this.getMax().doubleValue() - (double)coordinate * (this.getMax().doubleValue() - this.getMin().doubleValue()) / (double)renderedHeight;
    }

    private void generateTickLabels(double max, double min) {
        double tickVal;
        double tickInterval = this.m_tickInterval;
        max = this.getNiceMaxTick(min = this.getNiceMinTick(min), max);
        if (max == min) {
            tickInterval = Math.max(Math.abs(max), 1.0);
        }
        ArrayList<String> tickLabels = new ArrayList<String>();
        int i = 0;
        while ((tickVal = min + (double)i * tickInterval) <= max) {
            tickLabels.add(this.getFormatter().format(tickVal, min, max, tickInterval));
            ++i;
        }
        this.m_tickLabels = tickLabels;
    }

    @Override
    public Dimension getPreferredDimensions(Graphics2D ctx, Rectangle totalDrawingArea) {
        if (!this.isVisible()) {
            return new Dimension(0, totalDrawingArea.height);
        }
        Font oldfont = ctx.getFont();
        Font newfont = this.getFontToUse(oldfont);
        FontMetrics fm = ctx.getFontMetrics(newfont);
        if (this.hasContentChanged() || totalDrawingArea.height != this.m_oldDrawingAreaHeight) {
            this.calculateAndGenerateTickLabels(fm, totalDrawingArea);
            this.m_oldDrawingAreaHeight = totalDrawingArea.height;
        }
        Iterator tickIter = this.m_tickLabels.iterator();
        int longestLabelWidth = 0;
        while (tickIter.hasNext()) {
            String currentLabel = (String)tickIter.next();
            longestLabelWidth = Math.max(longestLabelWidth, fm.getStringBounds((String)currentLabel, (Graphics)ctx).getBounds().width);
        }
        int tickSize = (int)Math.max((double)this.getMaxHeight(fm) * 0.25, 1.0);
        int width = Math.max(this.m_minimumWidth, longestLabelWidth + tickSize * 3);
        if (this.hasTitle()) {
            width += this.getMaxHeight(ctx.getFontMetrics(newfont));
        }
        return new Dimension(width, totalDrawingArea.height);
    }

    private Font getFontToUse(Font oldfont) {
        Font newfont = oldfont;
        float fontSize = this.getActualFontSize(oldfont.getSize());
        if (fontSize != (float)oldfont.getSize()) {
            newfont = oldfont.deriveFont(fontSize);
        }
        return newfont;
    }

    private int getMaxHeight(FontMetrics fm) {
        return fm.getMaxAscent() + fm.getMaxDescent();
    }

    public boolean isMarkZero() {
        return this.m_markZero;
    }

    public void setMarkZero(boolean markZero) {
        this.m_markZero = markZero;
    }

    private double calculateNiceTickDistance(double coarseTickDistance, double minTickDistance) {
        if (coarseTickDistance == 0.0) {
            coarseTickDistance = 1.0;
        }
        if ("bytes".equals(this.getContentType())) {
            return this.calculateNiceByteTickDistance(coarseTickDistance, minTickDistance);
        }
        double exp = ChartRenderingToolkit.log10(coarseTickDistance);
        double calcExp = ChartRenderingToolkit.fastFloor(exp);
        double magnitude = Math.pow(10.0, calcExp);
        double fact = coarseTickDistance / magnitude;
        if ((magnitude = this.adjustMagnitude(magnitude, fact)) <= minTickDistance) {
            magnitude *= 2.0;
        }
        if ("count".equals(this.getContentType()) || "time".equals(this.getContentType())) {
            return Math.max(1, (int)magnitude);
        }
        return magnitude;
    }

    private double adjustMagnitude(double magnitude, double fact) {
        if (fact > 8.0) {
            magnitude *= 10.0;
        } else if (fact >= 3.0) {
            magnitude *= 5.0;
        } else if (fact >= 1.5) {
            magnitude *= 2.0;
        }
        return magnitude;
    }

    private double adjustByteMagnitude(double magnitude, double fact) {
        double maxExp;
        double exp = ChartRenderingToolkit.fastFloor(ChartRenderingToolkit.log2(fact));
        double minExp = Math.pow(2.0, exp);
        if (fact - minExp > (maxExp = Math.pow(2.0, exp + 1.0)) - fact) {
            return magnitude * maxExp;
        }
        return magnitude * minExp;
    }

    private double calculateNiceByteTickDistance(double coarseTickDistance, double minTickDistance) {
        double sign = Math.signum(coarseTickDistance);
        double absVal = Math.abs(coarseTickDistance);
        int byteExp = this.getByteExp(absVal);
        double magnitude = Math.pow(1024.0, byteExp);
        double fact = coarseTickDistance / magnitude;
        if ((magnitude = this.adjustByteMagnitude(magnitude, fact)) <= minTickDistance) {
            magnitude *= 2.0;
        }
        return Math.max(1.0, magnitude * sign);
    }

    private int getByteExp(double absVal) {
        int exp = 0;
        while (absVal > 1024.0) {
            absVal /= 1024.0;
            ++exp;
        }
        return exp;
    }

    @Override
    public int convertAxisValueToDrawingCoordinate(double value) {
        int height = this.getRenderedHeight();
        double min = this.getMin().doubleValue();
        double max = this.getMax().doubleValue();
        double plotHeight = max - min;
        double plotValue = value - min;
        double coordinate = (double)height - (double)height / plotHeight * plotValue;
        return Math.round((float)coordinate);
    }

    public void setTickSize(Number n) {
        this.m_tickSize = n;
    }

    public void setAutoPadding(double fraction) {
        this.m_autoPadding = fraction;
    }

    public void setAlwaysShowZero(boolean alwaysShow) {
        this.m_alwaysShowZero = alwaysShow;
    }

    @Override
    public Number getMax() {
        double minValue;
        double maxValue;
        Number max = super.getMax();
        OptimizingProvider provider = this.getOwner().getYAxisProvider(this.getPosition());
        if (max == null || this.isAutoRangeEnabled()) {
            if (provider == null) {
                return 1;
            }
            maxValue = provider.getMaxY();
            minValue = provider.getMinY();
        } else {
            maxValue = max.doubleValue();
            minValue = super.getMin().doubleValue();
        }
        if (Double.isNaN(minValue) || Double.isInfinite(minValue)) {
            minValue = 0.0;
            maxValue = 0.0;
        }
        if (this.m_alwaysShowZero && minValue > 0.0) {
            minValue = 0.0;
        }
        maxValue = maxValue == minValue ? (maxValue == 0.0 ? 1.0 : (maxValue += Math.abs(maxValue) * 0.1)) : (maxValue += this.m_autoPadding * (maxValue - minValue));
        if (this.m_alwaysShowZero && maxValue < 0.0) {
            return 0.0;
        }
        return maxValue;
    }

    @Override
    public Number getMin() {
        double minValue;
        double maxValue;
        Number min = super.getMin();
        OptimizingProvider provider = this.getOwner().getYAxisProvider(this.getPosition());
        if (min == null || this.isAutoRangeEnabled()) {
            if (provider == null) {
                return 0;
            }
            maxValue = provider.getMaxY();
            minValue = provider.getMinY();
        } else {
            minValue = min.doubleValue();
            maxValue = super.getMax().doubleValue();
        }
        if (Double.isNaN(maxValue) || Double.isInfinite(maxValue)) {
            maxValue = 0.0;
            minValue = 0.0;
        }
        if (this.m_alwaysShowZero && maxValue < 0.0) {
            maxValue = 0.0;
        }
        double paddedValue = maxValue == minValue ? (minValue != 0.0 ? minValue * 0.9 : 0.0) : minValue - this.m_autoPadding * (maxValue - minValue);
        if (minValue > 0.0) {
            minValue = Math.max(paddedValue, 0.0);
        }
        if (this.m_alwaysShowZero && minValue > 0.0) {
            return 0.0;
        }
        return minValue;
    }

    public void setAutoRangeEnabled(boolean enable) {
        this.m_autoRangeEnabled = enable;
        this.m_max = null;
        this.m_min = null;
    }

    public boolean isAutoRangeEnabled() {
        return this.m_autoRangeEnabled;
    }

    public void setRange(Number min, Number max) {
        this.setMin(min);
        this.setMax(max);
    }

    @Override
    public YAxis.Position getPosition() {
        return this.m_position;
    }

    public void setPosition(YAxis.Position position) {
        this.m_position = position;
    }

    public boolean isTitleLegendEnabled() {
        return this.m_titleLegendEnabled;
    }

    public void setTitleLegendEnabled(boolean show) {
        this.m_titleLegendEnabled = show;
    }

    public void setContentType(String contentType) {
        this.m_contentType = contentType;
    }

    @Override
    public String getContentType() {
        return this.m_contentType;
    }

    @Override
    public void setMinimumWidth(int width) {
        this.m_minimumWidth = width;
    }

    public int getMinimumWidth() {
        return this.m_minimumWidth;
    }
}

