/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart;

import java.awt.Color;
import java.util.ArrayList;
import se.hirt.greychart.ChartChangeEvent;
import se.hirt.greychart.ChartChangeListener;
import se.hirt.greychart.ChartRenderer;
import se.hirt.greychart.FontAndColors;
import se.hirt.greychart.IndexRenderer;
import se.hirt.greychart.SeriesGreyChart;
import se.hirt.greychart.SeriesMetadataProvider;
import se.hirt.greychart.SeriesPlotRenderer;
import se.hirt.greychart.data.DataSeriesProvider;

public abstract class AbstractGreyChart<T>
implements SeriesGreyChart<T> {
    private String m_title;
    private boolean m_useAntialiasing = true;
    private DataSeriesProvider<T> m_dataProvider;
    private SeriesPlotRenderer m_plotRenderer;
    protected Color m_background = FontAndColors.getDefaultBackground();
    protected Color m_foreground = FontAndColors.getDefaultForeground();
    private final ArrayList m_graphChangeListeners = new ArrayList(5);
    protected ChartRenderer m_titleRenderer;
    protected IndexRenderer m_indexRenderer;
    private SeriesMetadataProvider m_metadataProvider;

    public AbstractGreyChart(String title) {
        this.setTitle(title);
    }

    protected void setPlotRenderer(SeriesPlotRenderer plotRenderer) {
        this.m_plotRenderer = plotRenderer;
    }

    @Override
    public void setTitle(String title) {
        this.m_title = title;
    }

    @Override
    public String getTitle() {
        return this.m_title;
    }

    @Override
    public void setDataProvider(DataSeriesProvider<T> provider) {
        this.m_dataProvider = provider;
        this.fireChangeEvent(new ChartChangeEvent(this, ChartChangeEvent.ChangeType.DATA_STRUCTURE_CHANGED));
    }

    @Override
    public DataSeriesProvider<T> getDataProvider() {
        return this.m_dataProvider;
    }

    @Override
    public void removeChangeListener(ChartChangeListener l) {
        this.m_graphChangeListeners.remove(l);
    }

    @Override
    public void addChangeListener(ChartChangeListener l) {
        if (l == null) {
            throw new IllegalArgumentException("May not add null as chart change listener!");
        }
        this.m_graphChangeListeners.add(l);
    }

    @Override
    public SeriesPlotRenderer getPlotRenderer() {
        return this.m_plotRenderer;
    }

    protected void fireChangeEvent(ChartChangeEvent event) {
        int i = 0;
        int size = this.m_graphChangeListeners.size();
        while (i < size) {
            ((ChartChangeListener)this.m_graphChangeListeners.get(i)).onChartChanged(event);
            ++i;
        }
    }

    @Override
    public boolean isAntaliasingEnabled() {
        return this.m_useAntialiasing;
    }

    @Override
    public void setAntialiasingEnabled(boolean enable) {
        this.m_useAntialiasing = enable;
    }

    @Override
    public Color getBackground() {
        return this.m_background;
    }

    @Override
    public void setBackground(Color bgColor) {
        this.m_background = bgColor;
    }

    @Override
    public Color getForeground() {
        return this.m_foreground;
    }

    @Override
    public void setForeground(Color fgColor) {
        this.m_foreground = fgColor;
    }

    @Override
    public SeriesMetadataProvider getMetadataProvider() {
        return this.m_metadataProvider;
    }

    public void setMetadataProvider(SeriesMetadataProvider smdp) {
        this.m_metadataProvider = smdp;
    }

    @Override
    public void setIndexRenderer(IndexRenderer indexRenderer) {
        this.m_indexRenderer = indexRenderer;
    }

    @Override
    public IndexRenderer getIndexRenderer() {
        return this.m_indexRenderer;
    }

    @Override
    public void setTitleRenderer(ChartRenderer titleRenderer) {
        this.m_titleRenderer = titleRenderer;
    }

    @Override
    public ChartRenderer getTitleRenderer() {
        return this.m_titleRenderer;
    }
}

