/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.uitoolkit.impl.awt;

import com.sun.deploy.config.OSType;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.impl.awt.ui.AWTDialog;
import com.sun.deploy.uitoolkit.ui.AbstractDialog;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedList;
import sun.awt.AWTAccessor;
import sun.awt.ModalityEvent;
import sun.awt.ModalityListener;
import sun.awt.SunToolkit;
import sun.plugin2.applet.Plugin2Manager;
import sun.plugin2.main.client.ModalityInterface;
import sun.plugin2.os.windows.FLASHWINFO;
import sun.plugin2.os.windows.Windows;
import sun.plugin2.uitoolkit.ui.ModalityHelper;

public class AWTModalityHelper
implements ModalityHelper {
    private final LinkedList<Plugin2Manager> managersShowingSystemDialogs = new LinkedList();
    private static Reactivator reactivator;

    AWTModalityHelper() {
    }

    @Override
    public boolean installModalityListener(ModalityInterface modalityInterface) {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (toolkit instanceof SunToolkit) {
                SunToolkit sunToolkit = (SunToolkit)toolkit;
                sunToolkit.addModalityListener(new PluginModalityListener(modalityInterface));
                Trace.println((String)"Added plugin modalityListener", (TraceLevel)TraceLevel.UI);
                return true;
            }
            Trace.println((String)("Not a SunToolkit: " + toolkit), (TraceLevel)TraceLevel.UI);
        }
        catch (Throwable throwable) {
            Trace.ignored((Throwable)throwable);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushManagerShowingSystemDialog() {
        Plugin2Manager plugin2Manager = Plugin2Manager.getCurrentManager();
        LinkedList<Plugin2Manager> linkedList = this.managersShowingSystemDialogs;
        synchronized (linkedList) {
            this.managersShowingSystemDialogs.addFirst(plugin2Manager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Plugin2Manager getManagerShowingSystemDialog() {
        LinkedList<Plugin2Manager> linkedList = this.managersShowingSystemDialogs;
        synchronized (linkedList) {
            if (!this.managersShowingSystemDialogs.isEmpty()) {
                return this.managersShowingSystemDialogs.getFirst();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void popManagerShowingSystemDialog() {
        Plugin2Manager plugin2Manager = Plugin2Manager.getCurrentManager();
        LinkedList<Plugin2Manager> linkedList = this.managersShowingSystemDialogs;
        synchronized (linkedList) {
            Iterator iterator = this.managersShowingSystemDialogs.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != plugin2Manager) continue;
                iterator.remove();
                break;
            }
        }
    }

    @Override
    public void reactivateDialog(AbstractDialog abstractDialog) {
        if (abstractDialog instanceof AWTDialog) {
            this.getReactivator().reactivate(((AWTDialog)abstractDialog).getDialog());
        } else {
            Trace.println((String)"reactivateDialog: not an AWTDialog");
        }
    }

    private Reactivator getReactivator() {
        if (reactivator == null) {
            reactivator = OSType.isWin() ? new WindowsReactivator() : new NoopReactivator();
        }
        return reactivator;
    }

    static class PluginModalityListener
    implements ModalityListener {
        private ModalityInterface modality;

        PluginModalityListener(ModalityInterface modalityInterface) {
            this.modality = modalityInterface;
        }

        @Override
        public void modalityPushed(ModalityEvent modalityEvent) {
            this.modality.modalityPushed((AbstractDialog)AWTDialog.getAWTDialog((Dialog)((Dialog)modalityEvent.getSource())));
        }

        @Override
        public void modalityPopped(ModalityEvent modalityEvent) {
            this.modality.modalityPopped((AbstractDialog)AWTDialog.getAWTDialog((Dialog)((Dialog)modalityEvent.getSource())));
        }
    }

    static class WindowsReactivator
    implements Reactivator {
        private Method getHWndMethod;

        WindowsReactivator() {
        }

        @Override
        public void reactivate(Dialog dialog) {
            if (this.getHWndMethod == null) {
                try {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            try {
                                Class<?> clazz = Class.forName("sun.awt.windows.WComponentPeer");
                                Method method = clazz.getDeclaredMethod("getHWnd", new Class[0]);
                                WindowsReactivator.this.getHWndMethod = method;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return null;
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            long l = 0L;
            try {
                Object t = AWTAccessor.getComponentAccessor().getPeer(dialog);
                l = (Long)this.getHWndMethod.invoke(t, (Object[])null);
                Windows.MessageBeep(0);
                FLASHWINFO fLASHWINFO = FLASHWINFO.create();
                fLASHWINFO.cbSize(FLASHWINFO.size());
                fLASHWINFO.hwnd(l);
                fLASHWINFO.dwFlags(1);
                fLASHWINFO.uCount(3);
                fLASHWINFO.dwTimeout(64);
                Windows.FlashWindowEx(fLASHWINFO);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class NoopReactivator
    implements Reactivator {
        NoopReactivator() {
        }

        @Override
        public void reactivate(Dialog dialog) {
        }
    }

    static interface Reactivator {
        public void reactivate(Dialog var1);
    }
}

