/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.controlpanel.ui.configuration.model.xml;

import com.oracle.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLAttribute;
import com.oracle.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLNode;
import com.oracle.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLNodeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class XMLTag
extends XMLNode {
    private final List<XMLTag> m_tags = new ArrayList<XMLTag>();
    private final List<XMLAttribute> m_attributes = new ArrayList<XMLAttribute>();

    public XMLTag(String name) {
        super(name, XMLNodeType.ELEMENT);
    }

    public XMLTag(String name, XMLNodeType type) {
        super(name, type);
    }

    public List<XMLTag> getTags() {
        return this.m_tags;
    }

    public List<XMLAttribute> getAttributes() {
        return this.m_attributes;
    }

    public void add(XMLNode ... nodes) {
        XMLNode[] xMLNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            XMLNode node = xMLNodeArray[n2];
            if (node instanceof XMLTag) {
                this.m_tags.add((XMLTag)node);
            }
            if (node instanceof XMLAttribute) {
                this.m_attributes.add((XMLAttribute)node);
            }
            ++n2;
        }
    }

    public String toString() {
        return "Tag: " + this.getName();
    }

    public boolean accepts(Map<String, String> attributes) {
        return true;
    }

    static class Predicated
    extends XMLTag {
        private final String key;
        private final String value;

        public Predicated(String name, XMLAttribute attribute, String value) {
            super(name);
            this.key = attribute.getName();
            this.value = value;
        }

        @Override
        public boolean accepts(Map<String, String> attributes) {
            return this.value.equals(attributes.get(this.key));
        }
    }
}

