/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.controlpanel.ui.configuration.model.xml;

import com.oracle.jmc.common.io.IOToolkit;
import com.oracle.jmc.common.util.XmlToolkit;
import com.oracle.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.IXMLValidator;
import com.oracle.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.PrettyPrinter;
import com.oracle.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLAttributeInstance;
import com.oracle.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLTagInstance;
import com.oracle.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLValidationResult;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLModel
extends Observable {
    private final XMLTagInstance m_root;
    private final Map<Object, XMLValidationResult> m_resultLookup = new LinkedHashMap<Object, XMLValidationResult>();
    private final IXMLValidator m_validator;
    private boolean m_dirty;

    XMLModel(XMLTagInstance root, IXMLValidator validator) {
        this.m_root = root;
        this.m_validator = validator;
        this.checkErrors();
    }

    public static XMLModel createEmpty(IXMLValidator validator, Map<String, String> attributes) {
        XMLTagInstance dummyRoot = new XMLTagInstance(null, validator.getRootElementType());
        XMLTagInstance container = dummyRoot.create(dummyRoot.getTag().getTags().get(0).getName(), attributes);
        for (XMLAttributeInstance attr : container.getAttributeInstances()) {
            if (!attr.getAttribute().isRequired()) continue;
            attr.setValue(attr.getValue());
        }
        return new XMLModel(container, validator);
    }

    public static XMLModel create(InputSource input, IXMLValidator validator) throws IOException, ParseException {
        try {
            XMLTagInstance dummyRoot = new XMLTagInstance(null, validator.getRootElementType());
            SAXParserFactory spf = XmlToolkit.createSAXParserFactory();
            SAXParser sp = spf.newSAXParser();
            XMLReader xr = sp.getXMLReader();
            XMLModelBuilder dataHandler = new XMLModelBuilder(dummyRoot);
            xr.setContentHandler(dataHandler);
            xr.parse(input);
            List<XMLTagInstance> instances = dummyRoot.getTagsInstances();
            if (instances.size() != 1) {
                throw new ParseException("There must be exactly one root element", 1);
            }
            return new XMLModel(instances.get(0), validator);
        }
        catch (SAXParseException sp) {
            ParseException pe = new ParseException(sp.getMessage(), sp.getLineNumber());
            pe.initCause(sp);
            throw pe;
        }
        catch (SAXException s) {
            ParseException pe = new ParseException("Could not parse XML", -1);
            pe.initCause(s);
            throw pe;
        }
        catch (ParserConfigurationException s) {
            ParseException pe = new ParseException("Could not parse XML", -1);
            pe.initCause(s);
            throw pe;
        }
    }

    public static void validate(InputStream xmlStream, String streamName, Schema schema) throws ParseException, IOException {
        try {
            XMLModel.validateAgainstSchema(xmlStream, schema);
        }
        catch (SAXParseException spe) {
            throw new ParseException(spe.getMessage(), spe.getLineNumber());
        }
        catch (SAXException e) {
            throw new IOException("Could not validate " + streamName, e);
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Could not validate " + streamName, e);
        }
        catch (IOException e) {
            throw new IOException("Could not validate " + streamName, e);
        }
    }

    private static void validateAgainstSchema(InputStream xmlStream, Schema schema) throws SAXException, ParserConfigurationException, IOException, ParseException {
        try {
            SAXParserFactory factory = XmlToolkit.createSAXParserFactory();
            factory.setNamespaceAware(true);
            factory.setSchema(schema);
            class SimpleErrorHandler
            implements ErrorHandler {
                private final List<SAXParseException> exceptions = new ArrayList<SAXParseException>();

                SimpleErrorHandler() {
                }

                @Override
                public void warning(SAXParseException se) throws SAXException {
                    this.exceptions.add(se);
                }

                @Override
                public void error(SAXParseException se) throws SAXException {
                    this.exceptions.add(se);
                }

                @Override
                public void fatalError(SAXParseException se) throws SAXException {
                    this.exceptions.add(se);
                }
            }
            SimpleErrorHandler seh = new SimpleErrorHandler();
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setErrorHandler(seh);
            reader.parse(new InputSource(xmlStream));
            if (!seh.exceptions.isEmpty()) {
                XMLModel.throwParseException(seh.exceptions);
            }
        }
        finally {
            IOToolkit.closeSilently((Closeable)xmlStream);
        }
    }

    private static void throwParseException(List<SAXParseException> exceptions) throws ParseException {
        StringBuilder sb = new StringBuilder();
        int firstError = -1;
        for (SAXParseException spe : exceptions) {
            if (firstError == -1) {
                firstError = spe.getLineNumber();
            }
            sb.append("Line " + spe.getLineNumber() + " " + spe.getMessage());
            sb.append("\r\n");
            sb.append("\r\n");
        }
        throw new ParseException(sb.toString(), firstError);
    }

    public void saveToFile(File file) throws IOException {
        Charset charset = Charset.forName("UTF-8");
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset);
        if (this.writeTo(osw)) {
            this.setDirty(false);
        }
    }

    public boolean writeTo(Writer writer) {
        PrintWriter pw = new PrintWriter(writer);
        try {
            PrettyPrinter pp = new PrettyPrinter(pw, this.m_validator.getElementsTooKeepOnOneLine());
            pp.print(this);
            pw.flush();
            boolean bl = !pw.checkError();
            return bl;
        }
        finally {
            IOToolkit.closeSilently((Closeable)pw);
        }
    }

    public XMLTagInstance getRoot() {
        return this.m_root;
    }

    public void markDirty() {
        if (!this.m_dirty) {
            this.m_dirty = true;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void setDirty(boolean dirty) {
        this.m_dirty = dirty;
    }

    public boolean isModified() {
        return this.m_dirty;
    }

    public void checkErrors() {
        this.m_resultLookup.clear();
        if (this.m_validator != null) {
            for (XMLValidationResult r : this.m_validator.validate(this)) {
                this.m_resultLookup.put(r.getObject(), r);
                if (!r.isError()) continue;
                System.out.println(r.getObject() + ": " + r.getText());
            }
        }
    }

    public Collection<XMLValidationResult> getResults() {
        return this.m_resultLookup.values();
    }

    public XMLValidationResult getResult(Object o) {
        return this.m_resultLookup.get(o);
    }

    public boolean hasErrors() {
        for (XMLValidationResult r : this.m_resultLookup.values()) {
            if (!r.isError()) continue;
            return true;
        }
        return false;
    }

    public XMLModel deepClone() {
        StringWriter sw = new StringWriter(2000);
        if (this.writeTo(sw)) {
            try {
                return XMLModel.create(new InputSource(new StringReader(sw.toString())), this.m_validator);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        throw new IllegalStateException("Could not write model to string");
    }

    public String toString() {
        StringWriter sw = new StringWriter(2000);
        this.writeTo(sw);
        return sw.toString();
    }

    private static final class XMLModelBuilder
    extends DefaultHandler {
        private final Stack<XMLTagInstance> m_stack = new Stack();
        private StringBuilder characterBuilder;

        public XMLModelBuilder(XMLTagInstance dummyRoot) {
            this.m_stack.push(dummyRoot);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            XMLTagInstance current = this.m_stack.peek();
            XMLTagInstance child = current.create(qName, this.createMap(attributes));
            this.m_stack.push(child);
            this.characterBuilder = new StringBuilder();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.characterBuilder.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            XMLTagInstance current;
            String content = this.characterBuilder.toString().trim();
            if (content.length() != 0 && this.m_stack.peek().hasContent()) {
                this.m_stack.peek().setContent(content);
            }
            if (!(current = this.m_stack.peek()).getTag().getName().equalsIgnoreCase(qName)) {
                throw new IllegalStateException("Unexpected <" + qName + "/>");
            }
            this.m_stack.pop();
        }

        private Map<String, String> createMap(Attributes attributes) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            int i = 0;
            while (i < attributes.getLength()) {
                map.put(attributes.getQName(i), attributes.getValue(i).trim());
                ++i;
            }
            return map;
        }
    }
}

