/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.controlpanel.ui.configuration.model.xml;

import com.oracle.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLNode;
import com.oracle.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLNodeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public final class XMLAttribute
extends XMLNode {
    private final Collection<String> m_validValues;
    private final String m_defaultValue;
    private final boolean m_required;

    public XMLAttribute(String name, boolean required, XMLNodeType type) {
        this(name, required, type, (String)null);
    }

    public XMLAttribute(String name, boolean required, XMLNodeType type, String defaultValue) {
        super(name, type);
        this.m_validValues = Collections.emptyList();
        this.m_defaultValue = defaultValue;
        this.m_required = required;
    }

    public XMLAttribute(String name, boolean required, XMLNodeType type, String ... values) {
        super(name, type);
        assert (values.length > 0);
        ArrayList<String> lowerCasedValues = new ArrayList<String>(values.length);
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            assert (value != null);
            lowerCasedValues.add(value.trim().toLowerCase());
            ++n2;
        }
        this.m_validValues = Collections.unmodifiableList(lowerCasedValues);
        this.m_defaultValue = (String)lowerCasedValues.get(0);
        this.m_required = required;
    }

    public boolean isRequired() {
        return this.m_required;
    }

    public Collection<String> getValidValues() {
        return this.m_validValues;
    }

    public String getDefaultValue() {
        return this.m_defaultValue;
    }

    public String toString() {
        return "Attribute: " + this.getName();
    }

    public String getLabel() {
        if (this.getName().length() >= 2) {
            return String.valueOf(this.getName().substring(0, 1).toUpperCase()) + this.getName().substring(1);
        }
        return this.getName();
    }
}

