/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jmc.flightrecorder.controlpanel.ui.configuration.model.gui;

final class Value {
    public static final Value NULL = new Value("");
    public static final Value TRUE = new Value(Boolean.TRUE.toString());
    public static final Value FALSE = new Value(Boolean.FALSE.toString());
    private final String m_value;

    private Value(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value can't be null. Use empty string!");
        }
        this.m_value = value;
    }

    public boolean isTrue() {
        return TRUE.equals(this);
    }

    public boolean isFalse() {
        return !this.isTrue();
    }

    public boolean equals(Object o) {
        if (o instanceof Value) {
            return this.m_value.equalsIgnoreCase(((Value)o).m_value);
        }
        return false;
    }

    public int hashCode() {
        return this.m_value.hashCode();
    }

    public static Value valueOf(String value) {
        if (Boolean.TRUE.toString().equalsIgnoreCase(value)) {
            return TRUE;
        }
        if (Boolean.FALSE.toString().equalsIgnoreCase(value)) {
            return FALSE;
        }
        return new Value(value);
    }

    public String toString() {
        return this.m_value;
    }

    public boolean isNull() {
        return "".equals(this.m_value);
    }

    public static Value valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }
}

