/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.uitoolkit.impl.awt;

import com.sun.applet2.Applet2Host;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BadCertificateDialog;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.security.CodeSource;
import java.security.cert.CertificateException;
import javax.swing.JPanel;
import sun.plugin.JavaRunTime;

public class AWTErrorPanel
extends JPanel
implements MouseListener,
ActionListener {
    private static final long serialVersionUID = 6597076230660095243L;
    private Image errorImage = null;
    private static final String ERROR_IMAGE_FILE = "graybox_error.png";
    private static final String BLOCKED_IMAGE_FILE = "cert_error16.png";
    private static final Color ERROR_BORDER = new Color(204, 204, 204);
    private final Color bg_color;
    private final Color fg_color;
    private PopupMenu popup;
    private MenuItem open_console;
    private MenuItem about_java;
    private MenuItem reload;
    private boolean offerReload = false;
    private Applet2Host host = null;
    private String title = null;
    private String message = null;
    private Throwable throwable;

    public AWTErrorPanel(Color bg_color, Color fg_color, Applet2Host h, boolean offerReload) {
        this.host = h;
        this.setBackground(bg_color);
        this.bg_color = bg_color;
        this.fg_color = fg_color;
        this.setToolTipText(ResourceManager.getString((String)"applet.error.message"));
        this.addMouseListener(this);
        this.offerReload = offerReload;
        if (offerReload) {
            TrustDecider.resetDenyStore();
        }
    }

    public void setMessage(String title, String message) {
        this.title = title;
        this.message = message;
    }

    private String getMasthead() {
        return this.title == null || this.title.length() == 0 ? ResourceManager.getString((String)"applet.error.generic.masthead") : this.title;
    }

    private String getMessage() {
        return this.message == null || this.message.length() == 0 ? ResourceManager.getString((String)"applet.error.generic.body") : this.message;
    }

    private synchronized Image getErrorImage() {
        if (this.errorImage == null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            this.errorImage = this.isBlockedCertificateException() ? ResourceManager.getImageResource((String)BLOCKED_IMAGE_FILE) : ResourceManager.getImageResource((String)ERROR_IMAGE_FILE);
            MediaTracker mt = new MediaTracker(this);
            mt.addImage(this.errorImage, 0);
            try {
                mt.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.errorImage;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        this.drawBorder(g2d, this.getSize());
        if (this.getWidth() > 24 && this.getHeight() > 24) {
            int xOffset = 4;
            int yOffset = 5;
            g2d.drawImage(this.getErrorImage(), xOffset, yOffset, this.bg_color, null);
            this.drawMessage(g2d, this.getAppletPaneMessage(), this.getErrorImage().getWidth(null) + xOffset + 7, this.getErrorImage().getHeight(null) + yOffset - 4);
        }
        g2d.dispose();
    }

    private String getAppletPaneMessage() {
        if (this.isBlockedCertificateException()) {
            String paneMsg = ResourceManager.getString((String)"applet.error.blocked.message");
            this.setToolTipText(paneMsg);
            return paneMsg;
        }
        return ResourceManager.getString((String)"applet.error.message");
    }

    private void drawBorder(Graphics g, Dimension d) {
        Color color = ERROR_BORDER;
        Color oldColor = g.getColor();
        g.setColor(color);
        g.drawRect(0, 0, d.width - 1, d.height - 1);
        g.setColor(oldColor);
    }

    private void drawMessage(Graphics2D g2d, String error, int x, int y) {
        Dimension d = this.getSize();
        FontMetrics fm = g2d.getFontMetrics();
        Rectangle2D strBounds = fm.getStringBounds((String)error, g2d);
        boolean fit = true;
        if (strBounds.getWidth() + (double)x > d.getWidth()) {
            int spaceIdx;
            fit = false;
            while (!fit && (spaceIdx = ((String)error).lastIndexOf(" ")) != -1) {
                error = ((String)error).substring(0, spaceIdx);
                strBounds = fm.getStringBounds((String)(error = (String)error + "..."), g2d);
                if (!(strBounds.getWidth() + (double)x < d.getWidth())) continue;
                fit = true;
            }
            if (!fit && (strBounds = fm.getStringBounds((String)(error = "..."), g2d)).getWidth() + (double)x < d.getWidth()) {
                fit = true;
            }
        }
        if (fit) {
            Color oldColor = g2d.getColor();
            g2d.setColor(this.fg_color);
            g2d.drawString((String)error, x, y);
            g2d.setColor(oldColor);
        }
    }

    private PopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = new PopupMenu();
            this.open_console = new MenuItem(ResourceManager.getString((String)"dialogfactory.menu.open_console"));
            this.popup.add(this.open_console);
            this.popup.add("-");
            this.about_java = new MenuItem(ResourceManager.getString((String)"dialogfactory.menu.about_java"));
            this.popup.add(this.about_java);
            if (this.offerReload) {
                this.reload = new MenuItem("Reload applet");
                this.popup.add("-");
                this.popup.add(this.reload);
                this.reload.addActionListener(this);
            }
            this.open_console.addActionListener(this);
            this.about_java.addActionListener(this);
            this.add(this.popup);
        }
        return this.popup;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
        } else if (e.getButton() == 1) {
            this.onLeftMouseClick();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
        } else if (e.getButton() == 1) {
            this.onLeftMouseClick();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    private void onLeftMouseClick() {
        int selection = -1;
        if (this.isBlockedCertificateException()) {
            BlockedException be = (BlockedException)this.throwable;
            BadCertificateDialog.showDialog((CodeSource)be.getCodeSource(), (AppInfo)be.getAppInfo(), (Exception)((Object)be));
        } else {
            selection = this.offerReload ? ToolkitStore.getUI().showMessageDialog(null, new AppInfo(this.throwable), 0, null, this.getMasthead(), this.getMessage(), null, "applet.error.details.btn", "applet.error.ignore.btn", "applet.error.reload.btn") : ToolkitStore.getUI().showMessageDialog(null, new AppInfo(this.throwable), 0, null, this.getMasthead(), this.getMessage(), null, "applet.error.details.btn", "applet.error.ignore.btn", null);
        }
        if (selection == 0) {
            JavaRunTime.showJavaConsole(true);
        } else if (selection != 1 && selection == 3) {
            this.reloadApplet();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.open_console) {
            JavaRunTime.showJavaConsole(true);
        } else if (e.getSource() == this.about_java) {
            ToolkitStore.getUI().showAboutJavaDialog();
        } else if (e.getSource() == this.reload) {
            this.reloadApplet();
        }
    }

    private void reloadApplet() {
        if (this.host != null) {
            MemoryCache.clearLoadedResources();
            this.host.reloadAppletPage();
        }
    }

    private boolean isBlockedCertificateException() {
        return BlockedException.class.isAssignableFrom(this.throwable.getClass()) && ((BlockedException)this.throwable).getCodeSource() != null && ((BlockedException)this.throwable).getCause() != null && CertificateException.class.isAssignableFrom(((BlockedException)this.throwable).getCause().getClass());
    }

    void setThrowable(Throwable t) {
        this.throwable = t;
        this.setToolTipText(this.getAppletPaneMessage());
    }
}

