/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.client;

import com.sun.applet2.AppletParameters;
import com.sun.deploy.Environment;
import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.BuiltInProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.OSType;
import com.sun.deploy.config.Platform;
import com.sun.deploy.config.PluginClientConfig;
import com.sun.deploy.nativesandbox.NativeSandboxBroker;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.SecureStaticVersioning;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.SynthesizedEventListener;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.Window;
import com.sun.deploy.uitoolkit.WindowFactory;
import com.sun.deploy.uitoolkit.ui.AbstractDialog;
import com.sun.deploy.uitoolkit.ui.DialogHook;
import com.sun.deploy.uitoolkit.ui.UIFactory;
import com.sun.deploy.util.ArgumentParsingUtil;
import com.sun.deploy.util.ArrayUtil;
import com.sun.deploy.util.Base64Wrapper;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.SafeThreadFactory;
import com.sun.deploy.util.SessionState;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.URLUtil;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.JREMatcher;
import com.sun.javaws.jnl.LaunchDesc;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import sun.plugin.util.ProgressMonitor;
import sun.plugin2.applet.Applet2ClassLoaderCache;
import sun.plugin2.applet.Applet2Environment;
import sun.plugin2.applet.Applet2Listener;
import sun.plugin2.applet.Applet2Manager;
import sun.plugin2.applet.Applet2Status;
import sun.plugin2.applet.JNLP2Manager;
import sun.plugin2.applet.JNLP2Tag;
import sun.plugin2.applet.ManagerCache;
import sun.plugin2.applet.Plugin2ConsoleController;
import sun.plugin2.applet.Plugin2Manager;
import sun.plugin2.applet.StopListener;
import sun.plugin2.jvm.RemoteJVMLauncher;
import sun.plugin2.liveconnect.RemoteJavaObject;
import sun.plugin2.main.client.Applet2DragContext;
import sun.plugin2.main.client.ClientJVMSelectionParameters;
import sun.plugin2.main.client.DisconnectedExecutionContext;
import sun.plugin2.main.client.HeartbeatThread;
import sun.plugin2.main.client.LiveConnectSupport;
import sun.plugin2.main.client.MessagePassingExecutionContext;
import sun.plugin2.main.client.ModalityInterface;
import sun.plugin2.main.client.PluginCookieSelector;
import sun.plugin2.main.client.PluginEmbeddedFrame;
import sun.plugin2.main.client.PluginProxySelector;
import sun.plugin2.main.client.ServiceDelegate;
import sun.plugin2.message.BestJREAvailableMessage;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.EventMessage;
import sun.plugin2.message.GetAppletMessage;
import sun.plugin2.message.GetNameSpaceMessage;
import sun.plugin2.message.HeartbeatMessage;
import sun.plugin2.message.JVMStartedMessage;
import sun.plugin2.message.JavaObjectOpMessage;
import sun.plugin2.message.JavaReplyMessage;
import sun.plugin2.message.LaunchJVMAppletMessage;
import sun.plugin2.message.MarkTaintedMessage;
import sun.plugin2.message.Message;
import sun.plugin2.message.ModalityChangeMessage;
import sun.plugin2.message.OverlayWindowMoveMessage;
import sun.plugin2.message.Pipe;
import sun.plugin2.message.PluginMessages;
import sun.plugin2.message.PrintAppletMessage;
import sun.plugin2.message.PrintAppletReplyMessage;
import sun.plugin2.message.ReleaseRemoteObjectMessage;
import sun.plugin2.message.RemoteCAContextIdMessage;
import sun.plugin2.message.SetAppletSizeMessage;
import sun.plugin2.message.SetJVMIDMessage;
import sun.plugin2.message.StartAppletAckMessage;
import sun.plugin2.message.StartAppletMessage;
import sun.plugin2.message.StopAppletAckMessage;
import sun.plugin2.message.StopAppletMessage;
import sun.plugin2.message.WindowActivationEventMessage;
import sun.plugin2.message.transport.SerializingTransport;
import sun.plugin2.message.transport.TransportFactory;
import sun.plugin2.uitoolkit.DragContext;
import sun.plugin2.uitoolkit.DragListener;
import sun.plugin2.uitoolkit.PluginUIToolkit;
import sun.plugin2.uitoolkit.PluginWindowFactory;
import sun.plugin2.uitoolkit.ui.ModalityHelper;
import sun.plugin2.uitoolkit.ui.PluginUIFactory;
import sun.plugin2.util.ColorUtil;
import sun.plugin2.util.PluginJVMUtil;

public class PluginMain
implements ModalityInterface {
    private static final boolean DEBUG = Config.getDebug();
    private static final boolean VERBOSE = Config.getVerbose();
    private static final boolean NO_HEARTBEAT = Environment.getenv((String)"JPI_PLUGIN2_NO_HEARTBEAT") != null;
    private TransportFactory transportFactory;
    private Pipe pipe;
    private int jvmID;
    private boolean jvmTainted = false;
    private boolean separateJVM;
    private boolean anyAppletRelaunchOccurred;
    private boolean isSecureJVM = true;
    private final Applet2ClassLoaderCache classLoaderCache = new Applet2ClassLoaderCache(Applet2Manager.getCacheEntryCreator());
    private final ManagerCache managerCache = new ManagerCache();
    private final Map<Integer, Plugin2Manager> applets = Collections.synchronizedMap(new HashMap());
    private final Set<Plugin2Manager> disconnectedManagers = Collections.synchronizedSet(new HashSet());
    private boolean usingModalityListener;
    private boolean sendConservativeModalNotifications;
    private long lastReactivationTime;
    private static final long MIN_REACTIVATION_DELAY = 500L;
    protected volatile boolean shouldShutdown;
    private Timer idleTimer = null;
    private HeartbeatThread hbt = null;
    private ThreadGroup mainThreadGroup;
    private int browserType;
    private static final int AWT_LIGHTGRAY = 0xC0C0C0;
    static final Object lock;
    static ModalityHelper theModalityHelper;
    private DragListener pluginMainDragListener;
    private static final long IDLE_TIMEOUT = 60000L;
    private final Map<AbstractDialog, ModalityLevel> modalityMap = new HashMap<AbstractDialog, ModalityLevel>();
    private boolean modalDialogHasPopped = false;

    private synchronized boolean isJVMTainted() {
        return this.jvmTainted;
    }

    private synchronized void startIdleTimer() {
        if (this.idleTimer == null) {
            this.idleTimer = new Timer();
            this.idleTimer.schedule((TimerTask)new AutoShutdownTask(), 60000L, 60000L);
        }
    }

    private synchronized void stopIdleTimer() {
        if (this.idleTimer != null) {
            this.idleTimer.cancel();
            this.idleTimer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModalityHelper getModalityHelper() {
        Object object = lock;
        synchronized (object) {
            UIFactory ui;
            if (theModalityHelper == null && (ui = ToolkitStore.getUI()) instanceof PluginUIFactory) {
                theModalityHelper = ((PluginUIFactory)ui).getModalityHelper();
            }
        }
        return theModalityHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(String[] args) throws IOException {
        block32: {
            block31: {
                long t0 = 0L;
                long pluginMainPerfStart = SystemUtils.microTime();
                long _appletLaunchTime = 0L;
                long _jvmLaunchTime = 0L;
                try {
                    _appletLaunchTime = Long.parseLong(System.getProperty("__applet_launched"));
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                }
                try {
                    _jvmLaunchTime = Long.parseLong(System.getProperty("__jvm_launched"));
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                }
                long pluginMainStartTime = SystemUtils.microTime();
                long appletLaunchTime = _appletLaunchTime > 0L ? _appletLaunchTime : pluginMainStartTime;
                long jvmLaunchTime = _jvmLaunchTime > 0L ? _jvmLaunchTime : pluginMainStartTime;
                long appletLaunchCosts = pluginMainStartTime - appletLaunchTime;
                Plugin2Manager.setAppletLaunchTime(appletLaunchTime, appletLaunchCosts);
                long jvmLaunchCosts = pluginMainStartTime - jvmLaunchTime;
                Plugin2Manager.setJVMLaunchTime(jvmLaunchTime, jvmLaunchCosts);
                PluginUIToolkit.initPluginToolkit();
                System.setProperty("javaplugin.version", BuiltInProperties.getProperty((String)"DEPLOY_VERSION"));
                ToolkitStore.get().createAppContext();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ToolkitStore.get().warmup();
                        ProgressMonitor.warmup();
                    }
                }).start();
                if (DEBUG && VERBOSE) {
                    System.out.print("PluginMain.run({");
                    for (int i = 0; i < args.length; ++i) {
                        if (i > 0) {
                            System.out.print(" ");
                        }
                        System.out.print(args[i]);
                    }
                    System.out.println("})");
                }
                this.mainThreadGroup = Thread.currentThread().getThreadGroup();
                this.transportFactory = TransportFactory.createForCurrentOS(args);
                SerializingTransport transport = this.transportFactory.getTransport();
                PluginMessages.register(transport);
                this.pipe = new Pipe(transport, false);
                MessagePassingExecutionContext.setBrowserPID(-1L);
                Plugin2Manager.setDefaultAppletExecutionContext(new MessagePassingExecutionContext(null, this.pipe, -1, null));
                try {
                    PluginProxySelector.initialize();
                }
                catch (Throwable t) {
                    if (!DEBUG) break block31;
                    System.err.println("Error initializing PluginProxySelector (this error is expected on 1.4.2):");
                    t.printStackTrace();
                }
            }
            try {
                PluginCookieSelector.initialize();
            }
            catch (Throwable t) {
                if (!DEBUG) break block32;
                System.err.println("Error initializing PluginCookieSelector (this error is expected on 1.4.2):");
                t.printStackTrace();
            }
        }
        this.startIdleTimer();
        try {
            this.mainLoop();
        }
        catch (RuntimeException e) {
            if (DEBUG) {
                e.printStackTrace();
            }
        }
        catch (Error e) {
            if (DEBUG) {
                e.printStackTrace();
            }
        }
        finally {
            this.managerCache.clear();
            this.pipe.shutdown();
            this.transportFactory.dispose();
            if (this.disconnectedManagers.isEmpty()) {
                if (DEBUG) {
                    System.out.println("Exiting cleanly");
                    if (VERBOSE) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {}
                    }
                }
                this.exit(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterApplet(Integer appletID, Plugin2Manager manager) {
        Plugin2Manager mappedManager = this.applets.get(appletID);
        Trace.println((String)("PluginMain.unregisterApplet: " + appletID + " from mananger " + mappedManager), (TraceLevel)TraceLevel.BASIC);
        if (mappedManager != null && !manager.equals(mappedManager)) {
            Exception e = new Exception("PluginMain.unregisterApplet: " + appletID + ". Manager confusion: msg: " + manager + ", map: " + mappedManager);
            e.printStackTrace();
        }
        if (this.separateJVM && !this.anyAppletRelaunchOccurred) {
            if (DEBUG && VERBOSE) {
                System.out.println("Exiting JVM because only applet in separate JVM just exited");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            this.exitJVM(false);
        }
        LiveConnectSupport.appletStopped(appletID);
        PluginUIToolkit ptk = (PluginUIToolkit)ToolkitStore.get();
        ptk.getDragHelper().unregister(Applet2DragContext.getDragContext(manager));
        Map<Integer, Plugin2Manager> map = this.applets;
        synchronized (map) {
            this.applets.remove(appletID);
            if (this.applets.isEmpty()) {
                this.startIdleTimer();
            }
        }
    }

    private void registerApplet(Integer appletID, Plugin2Manager manager) {
        if (DEBUG && VERBOSE) {
            Plugin2Manager prevMgr = this.applets.get(appletID);
            System.out.println("PluginMain.registerApplet: " + appletID + " -> " + manager + ", previous manager: " + prevMgr);
        }
        this.applets.put(appletID, manager);
        LiveConnectSupport.appletStarted(appletID, manager);
    }

    private void abortStartApplet(Plugin2Manager manager) {
        Integer appletID = manager.getAppletID();
        if (DEBUG) {
            System.out.println("PluginMain.abortStartApplet for applet ID " + appletID);
        }
        this.unregisterApplet(appletID, manager);
        this.sendAppletAck(appletID, 3);
    }

    private void sendAppletAck(Integer appletID, int status) {
        try {
            this.pipe.send(new StartAppletAckMessage(null, appletID, status));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void mainLoop() {
        while (!this.shouldShutdown) {
            Message msg;
            try {
                msg = this.pipe.receive(0L);
            }
            catch (Exception ex) {
                if (DEBUG) {
                    ex.printStackTrace();
                }
                this.shouldShutdown = true;
                break;
            }
            try {
                this.handleMessage(msg);
            }
            catch (Throwable t) {
                if (DEBUG) {
                    t.printStackTrace();
                }
                if (t instanceof IOException) {
                    this.shouldShutdown = true;
                    continue;
                }
                if (!(t instanceof Error)) continue;
                Trace.flush();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.exit(-1);
            }
        }
    }

    protected void handleMessage(Message msg) throws Exception {
        if (msg != null) {
            switch (msg.getID()) {
                case 1: {
                    this.handleMessageSetJVMID((SetJVMIDMessage)msg);
                    break;
                }
                case 3: {
                    this.handleMessageStartApplet((StartAppletMessage)msg);
                    break;
                }
                case 18: {
                    this.handleLaunchJVM((LaunchJVMAppletMessage)msg);
                    break;
                }
                case 5: {
                    this.handleMessageSetAppletSize((SetAppletSizeMessage)msg);
                    break;
                }
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    this.handleSyntheticEvent((EventMessage)msg);
                    break;
                }
                case 80: {
                    this.handleMessageOverlayWindowMove((OverlayWindowMoveMessage)msg);
                    break;
                }
                case 7: {
                    this.handleMessageSynthesizeWindowActivation((WindowActivationEventMessage)msg);
                    break;
                }
                case 8: {
                    this.handleMessagePrintApplet((PrintAppletMessage)msg);
                    break;
                }
                case 12: {
                    this.handleMessageStopApplet((StopAppletMessage)msg);
                    break;
                }
                case 31: {
                    this.handleMessageGetApplet((GetAppletMessage)msg);
                    break;
                }
                case 32: {
                    this.handleMessageGetNameSpace((GetNameSpaceMessage)msg);
                    break;
                }
                case 33: {
                    if (DEBUG && VERBOSE) {
                        System.out.println("PluginMain: processing JavaObjectOpMessage");
                    }
                    LiveConnectSupport.doObjectOp((JavaObjectOpMessage)msg);
                    break;
                }
                case 35: {
                    if (DEBUG && VERBOSE) {
                        System.out.println("PluginMain: processing ReleaseRemoteObjectMessage");
                    }
                    RemoteJavaObject remote = new RemoteJavaObject(-1, -1, ((ReleaseRemoteObjectMessage)msg).getObjectID(), false);
                    LiveConnectSupport.releaseRemoteObject(remote);
                    break;
                }
                case 15: {
                    if (this.hbt == null) {
                        if (DEBUG) {
                            System.out.println("PluginMain: starting heartbeat");
                        }
                        if (NO_HEARTBEAT) break;
                        this.hbt = new Heartbeat((HeartbeatMessage)msg);
                        this.hbt.start();
                        break;
                    }
                    if (!DEBUG) break;
                    System.out.println("Main loop got more heartbeat after the initial one");
                    break;
                }
                case 14: {
                    if (DEBUG && VERBOSE) {
                        System.out.println("PluginMain: processing ShutdownJVMMessage");
                    }
                    if (NO_HEARTBEAT || !this.disconnectedManagers.isEmpty()) break;
                    this.managerCache.clear();
                    this.exitJVM(true);
                    break;
                }
                default: {
                    System.err.println("sun.plugin2.main.client.PluginMain: unrecognized message ID " + msg.getID());
                }
            }
        }
    }

    protected void cleanup() throws IOException {
        if (this.pipe != null) {
            this.pipe.shutdown();
        }
        if (this.transportFactory != null) {
            this.transportFactory.dispose();
        }
    }

    private void exitJVM(boolean cleanly) {
        try {
            if (cleanly) {
                this.cleanup();
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (!Platform.get().getRunInNativeSandbox()) {
                this.exit(0);
            }
        }
    }

    protected void exit(int statusCode) {
        MemoryCache.shutdown();
        this.classLoaderCache.shutdown();
        PluginMain.sureExit(statusCode);
    }

    public static void sureExit(int statusCode) {
        try {
            if (DEBUG) {
                new Throwable("DEBUG: System.exit(." + statusCode + ");").printStackTrace();
            }
            if (Platform.get().getRunInNativeSandbox()) {
                Platform.get().waitForNativeSandboxProcess();
            }
            System.exit(statusCode);
        }
        catch (IllegalThreadStateException e) {
            Runtime.getRuntime().halt(statusCode);
        }
    }

    private void handleMessageSetJVMID(SetJVMIDMessage jvmMsg) throws IOException, JNLPException {
        this.jvmID = jvmMsg.getJVMID();
        if (DEBUG && VERBOSE) {
            System.out.println("PluginMain: processing SetJVMIDMessage, params:");
        }
        if (System.getProperty("jnlpx.session.data") != null) {
            SessionState.init((String)System.getProperty("jnlpx.session.data"));
            System.setProperty("jnlpx.session.data", "");
        }
        this.separateJVM = jvmMsg.isSeparateJVM();
        String[][] paramsArrays = jvmMsg.getParameters();
        JVMParameters params = new JVMParameters();
        params.getFromStringArrays(paramsArrays);
        if (DEBUG && VERBOSE) {
            List subordinateArgs = params.getCommandLineArguments(null, false);
            for (String arg : subordinateArgs) {
                System.out.println("\t<" + arg + ">");
            }
        }
        this.isSecureJVM = params.isSecure();
        this.setupModality(jvmMsg.isModalityDisabled());
        params.setHtmlJavaArgs(jvmMsg.isHtmlJavaArgs());
        if (DEBUG) {
            System.out.println("PluginMain: The running JVM is " + (this.isSecureJVM ? "" : "NOT ") + "secure+\n\tJVMParameters: " + params);
        }
        JVMParameters.setRunningJVMParameters((JVMParameters)params);
        if (DEBUG && VERBOSE) {
            System.out.println("Running JVMParams: " + params + "\n\t-> " + JVMParameters.getRunningJVMParameters());
        }
        this.browserType = jvmMsg.getBrowserType();
        ServiceDelegate.initialize(jvmMsg.getBrowserType());
        String userHome = jvmMsg.getUserHome();
        if (userHome != null) {
            Platform.get().setUserHomeOverride(userHome);
        }
        this.initializeApplet2Environment(params);
        JNLP2Manager.initializeExecutionEnvironment();
        LiveConnectSupport.initialize(this.pipe, jvmMsg.getJVMID());
        this.pipe.send(new JVMStartedMessage(null));
    }

    protected void initializeApplet2Environment(JVMParameters params) {
        String args = null;
        try {
            List argsList = params.getCommandLineArguments(null, false, false, false, true, false);
            args = ArgumentParsingUtil.serializeArgumentListForDebugging((List)argsList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Applet2Environment.initialize(args, true, false, new Plugin2ConsoleController(this.classLoaderCache, this.managerCache), new MessagePassingExecutionContext(null, this.pipe, -1, null), this.getDialogHook());
    }

    private void handleMessageSetAppletSize(SetAppletSizeMessage setSizeMessage) {
        if (DEBUG && VERBOSE) {
            System.out.println("PluginMain: processing SetAppletSizeMessage");
        }
        this.setAppletSize(setSizeMessage.getAppletID(), setSizeMessage.getWidth(), setSizeMessage.getHeight());
    }

    private void setAppletSize(Integer appletID, int width, int height) {
        Plugin2Manager manager = this.applets.get(appletID);
        if (manager != null) {
            if (DEBUG) {
                System.out.println("PluginMain: setting size of applet " + appletID + " to (" + width + ", " + height + ")");
            }
            manager.setAppletSize(width, height);
        }
    }

    private void handleMessageOverlayWindowMove(OverlayWindowMoveMessage moveMessage) {
        if (DEBUG && VERBOSE) {
            System.out.println("PluginMain: processing OverlayWindowMoveMessage");
        }
        this.moveAppletWindow(moveMessage.getAppletID(), (int)moveMessage.getLocation().x, (int)moveMessage.getLocation().y);
    }

    private void moveAppletWindow(Integer appletID, int x, int y) {
        Plugin2Manager manager = this.applets.get(appletID);
        if (manager != null) {
            if (DEBUG) {
                System.out.println("PluginMain: setting location of applet window" + appletID + " to (" + x + ", " + y + ")");
            }
            manager.getAppletParent().setPosition(x, y);
        }
    }

    private void handleMessageStartApplet(final StartAppletMessage startMessage) {
        boolean tweakedAppletLaunchTime;
        long t0 = SystemUtils.microTime();
        long appletLaunchTime = startMessage.getAppletLaunchTime();
        if (appletLaunchTime > t0) {
            appletLaunchTime = t0;
            tweakedAppletLaunchTime = true;
        } else {
            tweakedAppletLaunchTime = false;
        }
        long appletLaunchCosts = t0 - appletLaunchTime;
        if (DEBUG && VERBOSE) {
            System.out.println("PluginMain: processing StartAppletMessage");
        }
        this.stopIdleTimer();
        AppletParameters params = startMessage.getParameters();
        final boolean isForDummyApplet = startMessage.isForDummyApplet();
        String tmpDocBase = startMessage.getDocumentBase();
        try {
            tmpDocBase = URLUtil.canonicalize((String)tmpDocBase);
            tmpDocBase = URLUtil.canonicalizeDocumentBaseURL((String)tmpDocBase);
            tmpDocBase = new URL(tmpDocBase).toString();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String documentBase = tmpDocBase;
        if (documentBase == null) {
            if (DEBUG && VERBOSE) {
                System.out.println("PluginMain: Couldn't retrieve a document base - exiting");
            }
            this.sendAppletAck(startMessage.getAppletID(), 3);
            return;
        }
        String jnlpFile = null;
        try {
            jnlpFile = (String)params.get((Object)JNLP2Tag.JNLP_HREF);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String jnlpString = (String)params.get((Object)"jnlp_embedded");
        byte[] jnlpBytes = null;
        if (jnlpString != null) {
            try {
                jnlpBytes = Base64Wrapper.decodeFromString((String)jnlpString);
            }
            catch (Exception ee) {
                Trace.ignored((Throwable)ee);
            }
        }
        boolean relaunched = Boolean.parseBoolean((String)params.get((Object)"__applet_relaunched"));
        boolean isJNLP = jnlpFile != null || jnlpBytes != null;
        Plugin2Manager _mgr = this.managerCache.get(documentBase, params);
        if (_mgr == null) {
            if (isJNLP) {
                if (jnlpFile != null) {
                    jnlpFile = URLUtil.canonicalize((String)jnlpFile);
                }
                String codebase = null;
                try {
                    codebase = (String)params.get((Object)"java_codebase");
                    if (codebase == null) {
                        codebase = (String)params.get((Object)"codebase");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    URL documentBaseURL = new URL(documentBase);
                    _mgr = new JNLP2Manager(this.managerCache, codebase, documentBaseURL, jnlpFile, jnlpBytes, relaunched);
                }
                catch (Exception e) {
                    System.out.println("PluginMain: JNLP2Manager creation: " + e);
                    e.printStackTrace();
                }
            } else {
                Applet2ClassLoaderCache loaderCache = isForDummyApplet ? null : this.getClassLoaderCache(params);
                _mgr = new Applet2Manager(loaderCache, this.managerCache, relaunched);
            }
        }
        final Integer appletID = startMessage.getAppletID();
        if (null == _mgr) {
            if (DEBUG && VERBOSE) {
                System.out.println("PluginMain: Couldn't deduce a Plugin2Manager - bail out");
            }
            this.sendAppletAck(appletID, 3);
            return;
        }
        final Plugin2Manager manager = _mgr;
        manager.setAppletID(appletID);
        manager.setBrowserPluginMode(true);
        if (isForDummyApplet) {
            manager.setForDummyApplet(true);
        } else {
            AppletParameters param = startMessage.getParameters();
            String appName = startMessage.getDocumentBase() + ": " + ArrayUtil.mapToString((Map)param);
            Config.getHooks().storeAppName(appName);
        }
        manager.setSecureFlag(this.isSecureJVM);
        if (DEBUG) {
            System.out.println("PluginMain: starting applet ID " + appletID + " in parent window 0x" + Long.toHexString(startMessage.getParentNativeWindowHandle()) + " with parameters:");
            System.out.println("    Document base = " + documentBase);
            for (String key : params.keySet()) {
                System.out.println("    " + key + "=" + params.get((Object)key));
            }
        }
        manager.setAppletExecutionContext(new MessagePassingExecutionContext(params, this.pipe, appletID, documentBase));
        final AppContext appContext = manager.getAppletAppContext();
        this.registerApplet(appletID, manager);
        new Thread(appContext.getThreadGroup(), new Runnable(){

            @Override
            public void run() {
                AppletFrameCreator frameCreator = new AppletFrameCreator(manager, startMessage, PluginMain.this.usingModalityListener ? null : PluginMain.this);
                StartAppletRunner runner = new StartAppletRunner(manager, startMessage);
                if (!isForDummyApplet) {
                    appContext.invokeLater((Runnable)frameCreator);
                    if (!PluginMain.this.initManager(manager)) {
                        return;
                    }
                    appContext.invokeLater((Runnable)runner);
                } else {
                    manager.startWorkerThread("Applet " + appletID + " start thread", runner);
                }
            }
        }).start();
    }

    protected void setupModality(boolean isModalityDisabled) {
        if (OSType.isWin() && !isModalityDisabled) {
            this.usingModalityListener = this.getModalityHelper().installModalityListener(this);
            this.sendConservativeModalNotifications = !this.usingModalityListener;
        } else {
            this.usingModalityListener = true;
        }
    }

    private synchronized DragListener getDragListener() {
        if (this.pluginMainDragListener == null) {
            this.pluginMainDragListener = new PluginMainDragListener();
        }
        return this.pluginMainDragListener;
    }

    private boolean initManager(final Plugin2Manager manager) {
        try {
            manager.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
            Trace.println((String)("Error while initializing manager: " + e + ", bail out"));
            AppContext appContext = manager.getAppletAppContext();
            final Exception exception = e;
            appContext.invokeLater(new Runnable(){

                @Override
                public void run() {
                    manager.getApplet2Adapter().doShowError("Error while initializing managers", (Throwable)exception, false);
                }
            });
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Plugin2Manager getActiveOrDisconnectedApplet(int appletID) {
        Integer key = appletID;
        Plugin2Manager manager2 = this.applets.get(key);
        if (manager2 != null) {
            return manager2;
        }
        Set<Plugin2Manager> set = this.disconnectedManagers;
        synchronized (set) {
            for (Plugin2Manager manager2 : this.disconnectedManagers) {
                if (!key.equals(manager2.getAppletID())) continue;
                return manager2;
            }
        }
        return null;
    }

    private void handleLaunchJVM(LaunchJVMAppletMessage message) {
        Trace.println((String)("Remote relaunch: " + message), (TraceLevel)TraceLevel.BASIC);
        final Integer appletID = message.getAppletID();
        final Plugin2Manager manager = this.applets.get(appletID);
        if (manager == null) {
            Trace.println((String)"Hosting manager is null, can't continue remote launch JVM", (TraceLevel)TraceLevel.BASIC);
            return;
        }
        JREInfo jreInfo = JREInfo.findByJREPath((String)message.getJavaHome());
        JVMParameters defaultParams = PluginJVMUtil.getDefaultVmArgs(jreInfo);
        AppletParameters appletParams = manager.getParametersToRelaunch();
        String v = (String)appletParams.get((Object)"__applet_relaunched");
        if (!Boolean.parseBoolean(v)) {
            Trace.println((String)"Expect parameter __applet_relaunched", (TraceLevel)TraceLevel.BASIC);
            return;
        }
        String docbase = manager.getAppletExecutionContext().getDocumentBase(manager);
        boolean includeExtendedASCIIValues = false;
        if (manager instanceof JNLP2Manager) {
            LaunchDesc ld = ((JNLP2Manager)manager).getLaunchDesc();
            includeExtendedASCIIValues = (ld.getSecurityModel() == 1 || ld.getSecurityModel() == 2) && ld.isSigned();
        }
        JVMParameters params = PluginJVMUtil.extractAppletParamsToJVMParameters(appletParams, docbase, true, includeExtendedASCIIValues);
        ClientJVMSelectionParameters deployParams = ClientJVMSelectionParameters.extract(appletParams);
        params = PluginJVMUtil.prepareJVMParameter(params, jreInfo, defaultParams, deployParams, true);
        RemoteJVMLauncher launcher = new RemoteJVMLauncher(this.pipe, message, params, manager);
        launcher.start();
        Trace.println((String)("handleLaunchJVM(): RemoteJVMLauncer.setCallBack for " + appletID));
        launcher.setCallBack(new RemoteJVMLauncher.CallBack(){

            @Override
            public void jvmStarted() {
                Trace.println((String)("handleLaunchJVM(): now unregisterApplet " + appletID));
                PluginMain.this.unregisterApplet(appletID, manager);
            }
        });
    }

    private void handleMessageSynthesizeWindowActivation(final WindowActivationEventMessage message) {
        Integer appletID;
        Plugin2Manager manager;
        if (DEBUG && VERBOSE) {
            System.out.println("PluginMain: processing SynthesizeWindowActivationMessage");
        }
        if ((manager = this.applets.get(appletID = Integer.valueOf(message.getAppletID()))) != null) {
            final Container container = manager.getAppletParentContainer();
            Window w = null;
            if (container == null) {
                w = OSType.isMac() ? manager.getAppletParent() : null;
            }
            final Window fxWindow = w;
            manager.getAppletAppContext().invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractDialog blocker;
                    if (DEBUG && VERBOSE) {
                        System.out.println("Calling synthesizeWindowActivation(" + message.getActive() + ") for applet " + message.getAppletID());
                    }
                    if (container != null && !PluginMain.this.modalDialogHasPopped) {
                        try {
                            ((PluginEmbeddedFrame)container).synthesizeWindowActivation(message.getActive());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {}
                    } else if (fxWindow instanceof SynthesizedEventListener) {
                        HashMap<Object, Object> eventData = new HashMap<Object, Object>();
                        message.flattenInto(eventData);
                        ((SynthesizedEventListener)fxWindow).synthesizeEvent(eventData);
                    }
                    if (PluginMain.this.modalDialogHasPopped) {
                        PluginMain.this.modalDialogHasPopped = false;
                    }
                    if (message.getActive() && (blocker = PluginMain.this.getModalDialogForApplet(appletID)) != null) {
                        blocker.toFront();
                        blocker.requestFocus();
                        if (DEBUG) {
                            System.out.println("  Called Dialog.toFront() / requestFocus() for blocker of applet ID " + appletID);
                        }
                        if (PluginMain.this.lastReactivationTime == 0L || System.currentTimeMillis() > PluginMain.this.lastReactivationTime + 500L) {
                            PluginMain.this.getModalityHelper().reactivateDialog(blocker);
                            PluginMain.this.lastReactivationTime = System.currentTimeMillis();
                        }
                    }
                }
            });
        }
    }

    private void handleSyntheticEvent(final EventMessage msg) {
        Plugin2Manager manager;
        if (DEBUG && VERBOSE) {
            System.out.println("PluginMain: processing EventMessage");
        }
        Integer appletID = msg.getAppletID();
        if (DEBUG && VERBOSE) {
            System.out.println("PluginMain: for applet ID = " + appletID);
        }
        if ((manager = this.applets.get(appletID)) != null) {
            SynthesizedEventListener localContainer = (SynthesizedEventListener)manager.getAppletParentContainer();
            if (localContainer == null) {
                localContainer = (SynthesizedEventListener)manager.getAppletParent();
            }
            final SynthesizedEventListener container = localContainer;
            manager.getAppletAppContext().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (DEBUG && VERBOSE) {
                        System.out.println("Calling synthesizeEvent() for applet " + msg.getAppletID());
                    }
                    if (container != null) {
                        HashMap<Object, Object> eventData = new HashMap<Object, Object>();
                        msg.flattenInto(eventData);
                        container.synthesizeEvent(eventData);
                    }
                }
            });
        }
    }

    private void handleMessagePrintApplet(final PrintAppletMessage printAppletMessage) {
        Plugin2Manager manager;
        if (DEBUG && VERBOSE) {
            System.out.println("PluginMain: processing PrintAppletMessage");
        }
        if ((manager = this.getActiveOrDisconnectedApplet(printAppletMessage.getAppletID())) != null) {
            if (DEBUG) {
                System.out.println("PluginMain: printing applet " + printAppletMessage.getAppletID() + " isPrinterDC = " + printAppletMessage.getIsPrinterDC());
            }
            manager.getAppletAppContext().invokeLater(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            PluginUIToolkit ptk = (PluginUIToolkit)ToolkitStore.get();
                            boolean res = ptk.printApplet(manager, printAppletMessage.getAppletID(), PluginMain.this.pipe, printAppletMessage.getHDC(), printAppletMessage.getIsPrinterDC(), printAppletMessage.getX(), printAppletMessage.getY(), printAppletMessage.getWidth(), printAppletMessage.getHeight());
                            PrintAppletReplyMessage reply = new PrintAppletReplyMessage(printAppletMessage.getConversation(), printAppletMessage.getAppletID(), res);
                            PluginMain.this.pipe.send(reply);
                        }
                        catch (IOException e) {
                            if (!DEBUG) break block2;
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessageStopApplet(StopAppletMessage stopMessage) throws IOException {
        Object f_manager;
        Integer key;
        Plugin2Manager manager2;
        if (DEBUG) {
            System.out.println("PluginMain: processing StopAppletMessage, applet ID " + stopMessage.getAppletID());
        }
        if ((manager2 = this.applets.get(key = Integer.valueOf(stopMessage.getAppletID()))) != null) {
            f_manager = manager2;
            Runnable afterStopRunnable = new Runnable((Plugin2Manager)f_manager){
                final /* synthetic */ Plugin2Manager val$f_manager;
                {
                    this.val$f_manager = plugin2Manager;
                }

                @Override
                public void run() {
                    PluginMain.this.unregisterApplet(key, this.val$f_manager);
                }
            };
            if (!this.isJVMTainted()) {
                StopListener listener = new StopListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void stopFailed() {
                        block6: {
                            PluginMain pluginMain = PluginMain.this;
                            synchronized (pluginMain) {
                                if (PluginMain.this.jvmTainted) {
                                    return;
                                }
                                PluginMain.this.jvmTainted = true;
                            }
                            MarkTaintedMessage message = new MarkTaintedMessage(null);
                            try {
                                PluginMain.this.pipe.send(message);
                            }
                            catch (IOException e) {
                                if (!DEBUG) break block6;
                                e.printStackTrace();
                            }
                        }
                    }
                };
                manager2.stop(afterStopRunnable, listener);
            } else {
                manager2.stop(afterStopRunnable);
            }
        } else {
            f_manager = this.disconnectedManagers;
            synchronized (f_manager) {
                for (Plugin2Manager manager2 : this.disconnectedManagers) {
                    if (!key.equals(manager2.getAppletID())) continue;
                    String documentBase = manager2.getAppletExecutionContext().getDocumentBase(manager2);
                    AppletParameters params = manager2.getAppletExecutionContext().getAppletParameters();
                    manager2.setDisconnected();
                    manager2.setAppletExecutionContext(new DisconnectedExecutionContext(params, documentBase));
                    if (!manager2.isEagerInstall()) {
                        manager2.installShortcuts();
                    }
                    LiveConnectSupport.appletStopped(key);
                    break;
                }
            }
        }
        StopAppletAckMessage reply = new StopAppletAckMessage(stopMessage.getConversation(), stopMessage.getAppletID());
        this.pipe.send(reply);
    }

    private void handleMessageGetApplet(GetAppletMessage getMsg) throws IOException {
        Plugin2Manager manager;
        if (DEBUG && VERBOSE) {
            System.out.println("PluginMain: processing GetAppletMessage");
        }
        if ((manager = this.getActiveOrDisconnectedApplet(getMsg.getAppletID())) != null) {
            if (manager.hasErrorOccurred()) {
                this.pipe.send(new JavaReplyMessage(getMsg.getConversation(), getMsg.getResultID(), null, false, "Applet ID " + getMsg.getAppletID() + manager.getErrorMessage()));
                return;
            }
            manager.waitUntilAppletStartDone();
        }
        if (manager == null || !manager.getApplet2Adapter().isInstantiated()) {
            this.pipe.send(new JavaReplyMessage(getMsg.getConversation(), getMsg.getResultID(), null, false, "Applet ID " + getMsg.getAppletID() + " is not currently running"));
        } else {
            Applet2Status status = manager.getAppletStatus();
            if (status != null) {
                if (status.getAdapter().isInstantiated()) {
                    Object result = LiveConnectSupport.exportObject(status.getAdapter().getLiveConnectObject(), getMsg.getAppletID(), false, true);
                    this.pipe.send(new JavaReplyMessage(getMsg.getConversation(), getMsg.getResultID(), result, false, null));
                } else {
                    String errorMessage = status.getErrorMessage();
                    if (errorMessage == null) {
                        errorMessage = "Unspecified error while fetching applet";
                    }
                    this.pipe.send(new JavaReplyMessage(getMsg.getConversation(), getMsg.getResultID(), null, false, errorMessage));
                }
            }
        }
    }

    private void handleMessageGetNameSpace(GetNameSpaceMessage getMsg) throws IOException {
        if (DEBUG && VERBOSE) {
            System.out.println("PluginMain: processing GetNameSpaceMessage");
        }
        this.pipe.send(new JavaReplyMessage(getMsg.getConversation(), getMsg.getResultID(), null, false, "Java namespace is no longer supported"));
    }

    private synchronized void pushDialogForApplet(Integer appletID, Plugin2Manager manager, AbstractDialog dialog) {
        ModalityLevel level = this.modalityMap.get(dialog);
        if (level == null) {
            level = new ModalityLevel(appletID, manager);
            this.modalityMap.put(dialog, level);
            manager.increaseModalityLevel();
        }
        level.push();
    }

    private synchronized AbstractDialog getModalDialogForApplet(Integer appletID) {
        Plugin2Manager manager = this.applets.get(appletID);
        if (manager == null) {
            return null;
        }
        for (AbstractDialog dialog : this.modalityMap.keySet()) {
            ModalityLevel level = this.modalityMap.get(dialog);
            if (!manager.isInSameAppContext(level.getManager())) continue;
            return dialog;
        }
        return null;
    }

    private synchronized ModalityLevel popDialog(AbstractDialog d) {
        ModalityLevel level = this.modalityMap.get(d);
        if (level == null) {
            return null;
        }
        if (level.pop() == 0) {
            this.modalityMap.remove(d);
            this.modalDialogHasPopped = true;
            level.getManager().decreaseModalityLevel();
        }
        return level;
    }

    private boolean skipManagerForModalOperation(Plugin2Manager manager) {
        return manager.isDisconnected() || this.disconnectedManagers.contains(manager);
    }

    @Override
    public void modalityPushed(AbstractDialog source) {
        Plugin2Manager manager = Plugin2Manager.getCurrentManager();
        if (manager == null && (manager = this.getModalityHelper().getManagerShowingSystemDialog()) == null) {
            Trace.println((String)"Skip modalityPush: manager null.", (TraceLevel)TraceLevel.UI);
            return;
        }
        if (this.skipManagerForModalOperation(manager)) {
            Trace.println((String)"Skip modalityPush: manager disconnected.", (TraceLevel)TraceLevel.UI);
            return;
        }
        Integer appletID = manager.getAppletID();
        if (appletID == null) {
            Trace.println((String)"Skip modalityPush: manager has no appletID.", (TraceLevel)TraceLevel.UI);
            return;
        }
        this.pushDialogForApplet(appletID, manager, source);
        if (Trace.isEnabled((TraceLevel)TraceLevel.UI)) {
            Trace.println((String)("Pushing modality for applet ID " + appletID + " with dialog " + source), (TraceLevel)TraceLevel.UI);
        }
        try {
            this.pipe.send(new ModalityChangeMessage(null, appletID, true));
        }
        catch (IOException e) {
            Trace.ignored((Throwable)e);
        }
    }

    @Override
    public void modalityPopped(AbstractDialog source) {
        ModalityLevel level = this.popDialog(source);
        if (level == null) {
            return;
        }
        int appletID = level.getAppletID();
        if (DEBUG) {
            System.out.println("modalityPopped for applet ID " + appletID);
        }
        try {
            this.pipe.send(new ModalityChangeMessage(null, appletID, false));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendConservativeModalPush() {
        Plugin2Manager manager;
        if (this.sendConservativeModalNotifications && (manager = Plugin2Manager.getCurrentManager()) != null) {
            Integer appletID = manager.getAppletID();
            try {
                this.pipe.send(new ModalityChangeMessage(null, appletID, true));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void sendConservativeModalPop() {
        Plugin2Manager manager;
        if (this.sendConservativeModalNotifications && (manager = Plugin2Manager.getCurrentManager()) != null) {
            Integer appletID = manager.getAppletID();
            try {
                this.pipe.send(new ModalityChangeMessage(null, appletID, false));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private DialogHook getDialogHook() {
        return new DialogHook(){

            public Object beforeDialog(Object owner) {
                Plugin2Manager manager = Plugin2Manager.getCurrentManager();
                if (manager != null && !PluginMain.this.skipManagerForModalOperation(manager)) {
                    PluginMain.this.sendConservativeModalPush();
                    PluginMain.this.getModalityHelper().pushManagerShowingSystemDialog();
                    return manager.getAppletParentContainer();
                }
                return null;
            }

            public void afterDialog() {
                PluginMain.this.getModalityHelper().popManagerShowingSystemDialog();
                PluginMain.this.sendConservativeModalPop();
            }

            public boolean ignoreOwnerVisibility() {
                return true;
            }
        };
    }

    public static boolean performSSVValidation(Plugin2Manager hostingManager) throws BlockedException {
        int plusIndex;
        boolean SSVValidated = Boolean.parseBoolean(hostingManager.getParameter("__applet_ssv_validated"));
        if (SSVValidated) {
            return false;
        }
        URL loc = hostingManager.getCodeBase();
        DeploymentRuleSet drs = hostingManager.getMainDeploymentRuleSet(loc);
        String drsVersion = drs.getVersionString();
        String runningVersion = System.getProperty("java.version");
        int dashIndex = runningVersion.indexOf("-");
        if (dashIndex != -1) {
            runningVersion = runningVersion.substring(0, dashIndex);
        }
        if ((plusIndex = runningVersion.indexOf("+")) != -1) {
            runningVersion = runningVersion.substring(0, plusIndex);
        }
        String requestedVersion = hostingManager.getParameter("__applet_ssv_version");
        String requestedVersionRange = hostingManager.getParameter("__applet_request_version");
        String javaVersionParam = hostingManager.getParameter("java_version");
        if (javaVersionParam != null && javaVersionParam.length() == 0) {
            javaVersionParam = null;
        }
        Trace.println((String)("SSV validation:\n    running: " + runningVersion + "\n    requested: " + requestedVersion + "\n    range: " + requestedVersionRange + "\n    javaVersionParam: " + javaVersionParam + "\n    Rule Set version: " + drsVersion), (TraceLevel)TraceLevel.SECURITY);
        if (drsVersion == null && (new VersionID(runningVersion).equals((Object)new VersionID(requestedVersion)) || requestedVersion == null && new VersionString(requestedVersionRange).contains(runningVersion))) {
            Trace.println((String)"continue with running version", (TraceLevel)TraceLevel.SECURITY);
            return false;
        }
        String selectedVersion = null;
        if (drsVersion != null) {
            String selectedDRSVersion = JREMatcher.getJREVersionFromDRS((DeploymentRuleSet)drs);
            if (drs.isVersionForced()) {
                selectedVersion = selectedDRSVersion;
            } else if (javaVersionParam != null && new VersionString(javaVersionParam).contains(selectedDRSVersion)) {
                selectedVersion = selectedDRSVersion;
            }
        }
        if (selectedVersion != null) {
            hostingManager.setParameter("__applet_ssv_version", selectedVersion);
        } else if (hostingManager instanceof JNLP2Manager) {
            LaunchDesc ld = ((JNLP2Manager)hostingManager).getLaunchDesc();
            if (requestedVersion == null) {
                if (requestedVersionRange != null) {
                    Trace.println((String)"Ask user or DRS to use latest", (TraceLevel)TraceLevel.SECURITY);
                    SecureStaticVersioning.useLatest((AppInfo)ld.getAppInfo(), (DeploymentRuleSet)drs, (String)requestedVersionRange, (int)2);
                }
                Trace.println((String)"continue with running version", (TraceLevel)TraceLevel.SECURITY);
                return false;
            }
            if (SecureStaticVersioning.canUse((AppInfo)ld.getAppInfo(), (DeploymentRuleSet)drs, (String)requestedVersion)) {
                selectedVersion = requestedVersion;
            }
        } else {
            AppInfo ai = hostingManager.getAppInfo();
            if (drsVersion != null && javaVersionParam == null) {
                requestedVersion = JREMatcher.getJREVersionFromDRS((DeploymentRuleSet)drs);
                if (requestedVersion != null) {
                    hostingManager.setParameter("__applet_ssv_version", requestedVersion);
                }
                Trace.println((String)("Set parameter SSV_VERSION to: " + requestedVersion), (TraceLevel)TraceLevel.SECURITY);
            }
            if (requestedVersion != null) {
                Trace.println((String)("Ask user to use: " + requestedVersion), (TraceLevel)TraceLevel.SECURITY);
                if (SecureStaticVersioning.canUse((AppInfo)ai, (DeploymentRuleSet)drs, (String)requestedVersion)) {
                    selectedVersion = requestedVersion;
                }
            } else {
                if (requestedVersionRange != null) {
                    Trace.println((String)"Ask user or DRS to use latest", (TraceLevel)TraceLevel.SECURITY);
                    String showVersion = javaVersionParam == null ? requestedVersionRange : javaVersionParam;
                    SecureStaticVersioning.useLatest((AppInfo)ai, (DeploymentRuleSet)drs, (String)showVersion, (int)2);
                }
                Trace.println((String)"continue with running version", (TraceLevel)TraceLevel.SECURITY);
                return false;
            }
        }
        if (selectedVersion != null) {
            Trace.println((String)("SSV - Selected version: " + selectedVersion), (TraceLevel)TraceLevel.SECURITY);
            hostingManager.getAppletClassLoader().setSSVDialogShown(true);
            if (selectedVersion.contains(".ea")) {
                selectedVersion = selectedVersion.replace(".ea", "-ea");
            } else if (selectedVersion.contains(".internal")) {
                selectedVersion = selectedVersion.replace(".internal", "-internal");
            }
            int dashIndex1 = selectedVersion.indexOf("-");
            if (dashIndex1 != -1) {
                selectedVersion = selectedVersion.substring(0, dashIndex1);
            }
            return !new VersionID(selectedVersion).equals((Object)new VersionID(runningVersion));
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            Trace.redirectStdioStderr();
            Config.setInstance((Config)new PluginClientConfig());
            new PluginMain().run(args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            Trace.flush();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            PluginMain.sureExit(1);
        }
    }

    private Applet2ClassLoaderCache getClassLoaderCache(AppletParameters params) {
        String value = (String)params.get((Object)"classloader_cache");
        if (value != null && value.equalsIgnoreCase("false")) {
            return null;
        }
        if (!this.classLoaderCache.isInUse()) {
            return null;
        }
        return this.classLoaderCache;
    }

    static {
        Platform.get().loadDeployNativeLib();
        SystemUtils.installPluginProtocolHandlers();
        lock = new Object();
        theModalityHelper = null;
    }

    private static class ModalityLevel {
        private int level;
        private final int appletID;
        private final Plugin2Manager manager;

        public ModalityLevel(int appletID, Plugin2Manager manager) {
            this.appletID = appletID;
            this.manager = manager;
        }

        public int getAppletID() {
            return this.appletID;
        }

        public Plugin2Manager getManager() {
            return this.manager;
        }

        public synchronized void push() {
            ++this.level;
        }

        public synchronized int pop() {
            return --this.level;
        }
    }

    private class AutoShutdownTask
    extends TimerTask {
        private AutoShutdownTask() {
        }

        @Override
        public void run() {
            if (PluginMain.this.disconnectedManagers.isEmpty() && PluginMain.this.applets.isEmpty() && PluginMain.this.managerCache.isEmpty()) {
                if (DEBUG) {
                    System.out.println("JVM instance exiting due to no applets running");
                }
                PluginMain.this.exit(0);
            }
        }
    }

    private class Heartbeat
    extends HeartbeatThread {
        public Heartbeat(HeartbeatMessage beat) {
            super("JVM[id=" + PluginMain.this.jvmID + "]", PluginMain.this.pipe);
            this.conversation = beat.getConversation();
            this.beat = beat;
        }

        @Override
        protected void handleStop() {
            PluginMain.this.shouldShutdown = true;
            if (PluginMain.this.disconnectedManagers.isEmpty()) {
                PluginMain.this.managerCache.clear();
                if (DEBUG) {
                    System.out.println("JVM exiting due to no heartbeat reply");
                    if (VERBOSE) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                PluginMain.this.exit(0);
            }
        }
    }

    class StartAppletListener
    implements Applet2Listener {
        final Plugin2Manager manager;
        StartAppletMessage startMessage;
        boolean _ssvValidated = false;

        StartAppletListener(Plugin2Manager manager, StartAppletMessage startMessage) {
            this.manager = manager;
            this.startMessage = startMessage;
        }

        @Override
        public String getBestJREVersion(Plugin2Manager bostingManager, String javaVersionStr, String jfxVersionStr) {
            String bestJREVersion = null;
            if (javaVersionStr != null) {
                Conversation c = PluginMain.this.pipe.beginConversation();
                BestJREAvailableMessage bestJREMessage = new BestJREAvailableMessage(c, 1, javaVersionStr, jfxVersionStr);
                try {
                    PluginMain.this.pipe.send(bestJREMessage);
                    BestJREAvailableMessage replyMessage = (BestJREAvailableMessage)PluginMain.this.pipe.receive(0L, c);
                    if (replyMessage.isReply()) {
                        bestJREVersion = replyMessage.getJavaVersion();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return bestJREVersion;
        }

        @Override
        public boolean appletSSVValidation(Plugin2Manager hostingManager) throws ExitException {
            try {
                boolean result = PluginMain.performSSVValidation(hostingManager);
                this._ssvValidated = true;
                return result;
            }
            catch (BlockedException be) {
                throw new ExitException((Throwable)be, 0);
            }
        }

        @Override
        public boolean isAppletRelaunchSupported() {
            return true;
        }

        @Override
        public void appletJRERelaunch(Plugin2Manager hostingManager, String javaVersion, String untrustedJvmArgs) {
            block13: {
                File f;
                PluginMain.this.anyAppletRelaunchOccurred = true;
                this.startMessage.setIsNativeSandbox(Platform.get().getRunInNativeSandbox());
                this.startMessage.collectJVMHealthData();
                Conversation conversation = this.startMessage.getConversation();
                assert (conversation == null);
                if (null != javaVersion && hostingManager.isAppletRelaunched()) {
                    throw new InternalError("appletJRERelaunch: incorrectly looped in relaunch code");
                }
                AppletParameters appletParams = this.startMessage.getParameters();
                if (null != javaVersion) {
                    appletParams.put((Object)"__applet_ssv_version", (Object)javaVersion);
                } else {
                    appletParams.remove((Object)"__applet_ssv_version");
                }
                appletParams.put((Object)"java_arguments", (Object)untrustedJvmArgs);
                appletParams.put((Object)"__applet_relaunched", (Object)String.valueOf(true));
                String tmp = hostingManager.getParameter("__jre_installed");
                if (null != tmp) {
                    appletParams.put((Object)"__jre_installed", (Object)tmp);
                }
                if (this._ssvValidated) {
                    appletParams.put((Object)"__applet_ssv_validated", (Object)"true");
                }
                if (null != (tmp = hostingManager.getParameter("javafx_version"))) {
                    appletParams.put((Object)"javafx_version", (Object)tmp);
                }
                if (null != (tmp = hostingManager.getParameter("__ui_tk"))) {
                    appletParams.put((Object)"__ui_tk", (Object)tmp);
                }
                if (null != (tmp = hostingManager.getParameter("__jfx_installed"))) {
                    appletParams.put((Object)"__jfx_installed", (Object)tmp);
                }
                if ((f = SessionState.save()) != null) {
                    appletParams.put((Object)"__applet_session_data", (Object)f.getAbsolutePath());
                }
                appletParams.put((Object)"height", (Object)Integer.toString(hostingManager.getHeight()));
                appletParams.put((Object)"width", (Object)Integer.toString(hostingManager.getWidth()));
                this.startMessage.setParameters(appletParams);
                if (DEBUG) {
                    System.out.println("PluginMain.StartAppletListener: appletJRERelaunch for applet ID " + hostingManager.getAppletID());
                    System.out.println("\t javaVersion: " + javaVersion);
                    System.out.println("\t jvmArgs: " + untrustedJvmArgs);
                }
                try {
                    hostingManager.setParametersToRelaunch(appletParams);
                    PluginMain.this.pipe.send(this.startMessage);
                }
                catch (IOException e) {
                    if (!DEBUG) break block13;
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void appletLoaded(Plugin2Manager hostingManager) {
            if (DEBUG) {
                System.out.println("PluginMain.StartAppletListener: appletLoaded for applet ID " + hostingManager.getAppletID());
            }
            Integer appletID = this.startMessage.getAppletID();
            PluginMain.this.sendAppletAck(appletID, 0);
        }

        @Override
        public void appletReady(Plugin2Manager hostingManager) {
            PluginMain.this.sendAppletAck(hostingManager.getAppletID(), 2);
        }

        @Override
        public void appletErrorOccurred(Plugin2Manager hostingManager) {
            if (DEBUG) {
                System.out.println("PluginMain.StartAppletListener: appletErrorOccurred for applet ID " + hostingManager.getAppletID());
            }
            PluginMain.this.sendAppletAck(hostingManager.getAppletID(), 3);
        }
    }

    class StartAppletRunner
    implements Runnable {
        final Plugin2Manager manager;
        StartAppletMessage startMessage;

        StartAppletRunner(Plugin2Manager manager, StartAppletMessage startMessage) {
            this.manager = manager;
            this.startMessage = startMessage;
        }

        @Override
        public void run() {
            this.manager.addAppletListener(new StartAppletListener(this.manager, this.startMessage));
            this.manager.start();
        }
    }

    class AppletFrameCreator
    implements Runnable {
        final ModalityInterface modalityInterface;
        final Plugin2Manager manager;
        StartAppletMessage startMessage;

        AppletFrameCreator(Plugin2Manager manager, StartAppletMessage startMessage, ModalityInterface modalityInterface) {
            this.manager = manager;
            this.startMessage = startMessage;
            this.modalityInterface = modalityInterface;
        }

        private boolean shouldStop() {
            return this.manager != null && this.manager.isStopping();
        }

        @Override
        public void run() {
            if (this.shouldStop()) {
                return;
            }
            Integer appletID = this.startMessage.getAppletID();
            AppletParameters params = this.startMessage.getParameters();
            boolean isForDummyApplet = this.startMessage.isForDummyApplet();
            if (this.shouldStop()) {
                return;
            }
            Window window = null;
            if (!isForDummyApplet) {
                block29: {
                    try {
                        WindowFactory windowFactory = ToolkitStore.getWindowFactory();
                        if (windowFactory instanceof PluginWindowFactory) {
                            try {
                                long parentWindow = this.startMessage.getParentNativeWindowHandle();
                                if (this.startMessage.useNativeSandboxWindow()) {
                                    long newParentWindow = Platform.get().createNativeWindowSandboxHandle(parentWindow);
                                    this.manager.setSandboxNativeWindowHandle(newParentWindow);
                                    parentWindow = newParentWindow;
                                }
                                window = ((PluginWindowFactory)windowFactory).createWindow(parentWindow, this.startMessage.getCARenderServerName(), this.startMessage.useXEmbed(), this.modalityInterface, PluginMain.this.pipe, (int)appletID);
                                if (Platform.get().isNativeSandbox()) {
                                    NativeSandboxBroker broker = Platform.get().getNativeSandboxBroker();
                                    broker.parentWindow(this.startMessage.getAppletID(), parentWindow);
                                } else {
                                    Platform.get().addParentWindow(this.startMessage.getAppletID(), this.startMessage.getParentNativeWindowHandle());
                                }
                            }
                            catch (AbstractMethodError ame) {
                                if (DEBUG) {
                                    System.out.println("re-try with old createWindow");
                                }
                                window = ((PluginWindowFactory)windowFactory).createWindow(this.startMessage.getParentNativeWindowHandle(), 0L, this.startMessage.useXEmbed(), this.modalityInterface, PluginMain.this.pipe, (int)appletID);
                            }
                            if (DEBUG) {
                                System.out.println("Created Embedded Window " + window);
                            }
                            break block29;
                        }
                        System.err.println("WindowFactory (" + windowFactory + ") is unsuitable for plugin");
                        return;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                if (window == null) {
                    System.err.println("PluginMain: could not create embedded frame");
                    PluginMain.this.abortStartApplet(this.manager);
                    return;
                }
            }
            if (this.shouldStop()) {
                return;
            }
            if (!isForDummyApplet) {
                int remoteLayerID;
                int n = remoteLayerID = window != null ? window.getWindowLayerID() : -1;
                if (remoteLayerID != -1) {
                    try {
                        if (DEBUG) {
                            System.out.println("Sending back " + remoteLayerID + " as remote layer");
                        }
                        RemoteCAContextIdMessage rccim = new RemoteCAContextIdMessage(null, appletID, remoteLayerID);
                        PluginMain.this.pipe.send(rccim);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        throw new RuntimeException(ex);
                    }
                } else if (DEBUG) {
                    System.out.println("Remote layer was -1 !!!");
                }
                this.manager.setAppletParent(window);
                int defaultWidth = 256;
                int defaultHeight = 256;
                int width = defaultWidth;
                int height = defaultHeight;
                String w = (String)params.get((Object)"width");
                String h = (String)params.get((Object)"height");
                try {
                    width = Integer.parseInt(w);
                    height = Integer.parseInt(h);
                }
                catch (Exception e) {
                    System.err.println("Error parsing width (\"" + w + "\") or height (\"" + h + "\")");
                    System.err.println("Defaulting to (" + width + ", " + height + ")");
                }
                if (width == 0 || height == 0) {
                    width = this.manager.getWidth();
                    height = this.manager.getHeight();
                }
                String bgColorStr = (String)params.get((Object)"boxbgcolor");
                ColorUtil.ColorRGB colorRGB = null;
                if (bgColorStr != null) {
                    colorRGB = ColorUtil.createColorRGB("boxbgcolor", bgColorStr);
                }
                int rgb = colorRGB != null ? colorRGB.rgb : 0xC0C0C0;
                if (window != null) {
                    window.setBackground(rgb);
                    window.setVisible(true);
                }
                PluginMain.this.setAppletSize(appletID, width, height);
                if (DEBUG) {
                    System.out.println("Made EmbeddedFrame for applet " + this.startMessage.getAppletID() + " visible");
                }
                PluginUIToolkit ptk = (PluginUIToolkit)ToolkitStore.get();
                if (Boolean.parseBoolean((String)params.get((Object)"draggable")) || Environment.getenv((String)"JPI_PLUGIN2_FORCE_DRAGGABLE") != null) {
                    ptk.getDragHelper().register(Applet2DragContext.getDragContext(this.manager), PluginMain.this.getDragListener());
                }
                ptk.installPluginPopupHelper(ptk.getAppContext());
            }
        }
    }

    class PluginMainDragListener
    implements DragListener {
        PluginMainDragListener() {
        }

        @Override
        public void appletDraggingToDesktop(DragContext ctx) {
            Plugin2Manager manager = ((Applet2DragContext)ctx).getManager();
            PluginMain.this.applets.remove(manager.getAppletID());
            PluginMain.this.disconnectedManagers.add(manager);
        }

        @Override
        public void appletDroppedOntoDesktop(DragContext ctx) {
            Plugin2Manager manager = ((Applet2DragContext)ctx).getManager();
            if (manager.isEagerInstall()) {
                manager.installShortcuts();
            }
        }

        @Override
        public void appletExternalWindowClosed(DragContext ctx) {
            final Plugin2Manager manager = ((Applet2DragContext)ctx).getManager();
            if (!ctx.isDisconnected()) {
                PluginUIToolkit ptk = (PluginUIToolkit)ToolkitStore.get();
                ptk.getDragHelper().restore(ctx);
                PluginMain.this.applets.put(manager.getAppletID(), manager);
                PluginMain.this.disconnectedManagers.remove(manager);
            } else {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        SafeThreadFactory.createThread((ThreadGroup)PluginMain.this.mainThreadGroup, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                LiveConnectSupport.appletStopped(manager.getAppletID());
                                manager.stop(null, null);
                                PluginMain.this.disconnectedManagers.remove(manager);
                                if (PluginMain.this.shouldShutdown && PluginMain.this.disconnectedManagers.isEmpty()) {
                                    PluginMain.this.managerCache.clear();
                                    PluginMain.this.exit(0);
                                }
                            }
                        }, (String)"Drag Listener Cleaner Thread").start();
                        return null;
                    }
                });
            }
        }
    }
}

