/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.applet2.AppletParameters;
import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.ref.AppModel;
import com.sun.deploy.ref.AppRef;
import com.sun.deploy.ref.CodeInstance;
import com.sun.deploy.ref.CodeRef;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.ruleset.BlockRule;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.ArgumentParsingUtil;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JRESelectException;
import com.sun.javaws.jnl.JREDesc;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.plugin.util.JarCacheUtil;
import sun.plugin2.applet.Applet2ClassLoader;
import sun.plugin2.applet.Applet2ClassLoaderCache;
import sun.plugin2.applet.ManagerCache;
import sun.plugin2.applet.Plugin2ClassLoader;
import sun.plugin2.applet.Plugin2Manager;
import sun.plugin2.applet.StopListener;
import sun.plugin2.main.client.JVMHealthData;
import sun.plugin2.util.ParameterNames;

public class Applet2Manager
extends Plugin2Manager {
    private static final String VERSION_TAG = "version=";
    private static final String PRELOAD = "preload";
    private boolean initializedJarVersionMap;
    private Map<String, String> jarVersionMap = new HashMap<String, String>();
    private final Map<String, String> preloadJarMap = new HashMap<String, String>();
    private final List<String> newStyleJarList = new ArrayList<String>();
    private Applet2ClassLoaderCache classLoaderCache;
    private volatile Applet2ClassLoaderCache.Entry classLoaderCacheEntry;
    private volatile String classLoaderCacheKey;
    private URL expectedMainURL = null;
    private URL[] allJarURLs = null;
    private final Map<String, DeploymentRuleSet> _drsMap = new HashMap<String, DeploymentRuleSet>();
    private DeploymentRuleSet mainAppletDeploymentRuleSet = null;

    public Applet2Manager(Applet2ClassLoaderCache classLoaderCache, ManagerCache managerCache, boolean relaunched) {
        super(managerCache, relaunched);
        this.classLoaderCache = classLoaderCache;
        MemoryCache.resetFileExistenceCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Plugin2ClassLoader getAppletClassLoader() {
        Applet2Manager applet2Manager = this;
        synchronized (applet2Manager) {
            if (this.loader == null) {
                Applet2ClassLoaderCache.Entry entry = this.getClassLoaderCacheEntry();
                if (entry != null) {
                    this.loader = entry.getClassLoader();
                    if (this.loader == null) {
                        throw new InternalError("Error during bootstrapping of ClassLoader");
                    }
                } else {
                    this.loader = this.getOrCreatePlugin2ClassLoader();
                }
            }
            return this.loader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ThreadGroup getAppletThreadGroup() {
        Applet2Manager applet2Manager = this;
        synchronized (applet2Manager) {
            if (this.appletThreadGroup == null) {
                Applet2ClassLoaderCache.Entry entry = this.getClassLoaderCacheEntry();
                if (entry != null) {
                    this.appletThreadGroup = entry.getThreadGroup();
                    if (this.appletThreadGroup == null) {
                        throw new InternalError("Error during bootstrapping of ThreadGroup");
                    }
                } else {
                    this.appletThreadGroup = this.getOrCreateAppletThreadGroup();
                }
            }
            return this.appletThreadGroup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AppContext getAppletAppContext() {
        Applet2Manager applet2Manager = this;
        synchronized (applet2Manager) {
            if (this.appletAppContext == null) {
                Applet2ClassLoaderCache.Entry entry = this.getClassLoaderCacheEntry();
                if (entry != null) {
                    this.appletAppContext = entry.getAppContext();
                    if (this.appletAppContext == null) {
                        throw new InternalError("Error during bootstrapping of AppContext");
                    }
                } else {
                    this.appletAppContext = this.getOrCreateAppletAppContext();
                }
                this.registerInAppContext(this.appletAppContext);
            }
            return this.appletAppContext;
        }
    }

    @Override
    public String getAppletUniqueKey() {
        Object keyString = "|";
        URL docBase = this.getDocumentBase();
        if (docBase != null) {
            keyString = (String)keyString + docBase.toString();
        }
        keyString = (String)keyString + "|";
        URL codeBase = this.getCodeBase();
        if (codeBase != null) {
            keyString = (String)keyString + codeBase.toString();
        }
        keyString = (String)keyString + "|";
        String jarFilesList = this.getJarFiles();
        if (jarFilesList != null) {
            keyString = (String)keyString + jarFilesList;
        }
        keyString = (String)keyString + "|";
        return keyString;
    }

    public int getPermissionRequestType() {
        String param = this.getParameter("permissions");
        if ("all-permissions".equals(param)) {
            return 2;
        }
        if ("sandbox".equals(param)) {
            return 1;
        }
        return 0;
    }

    public String getTitle() {
        String title = this.getParameter("java_applet_title");
        if (title == null || title.length() == 0) {
            title = this.getName();
        }
        return title;
    }

    @Override
    public AppInfo getAppInfo() {
        AppInfo ai = new AppInfo();
        ai.setTitle(this.getTitle());
        ai.setFrom(this.getCodeBase());
        ai.setDocumentBase(this.getDocumentBase());
        try {
            ai.setLapURL(new URL(ai.getFrom() + "/" + ai.getTitle() + "/" + ai.getDocumentBase().getHost()));
        }
        catch (Exception ioe) {
            ai.setLapURL(ai.getFrom());
            Trace.ignored((Throwable)ioe);
        }
        ai.setSecurity(this.getPermissionRequestType());
        URL emURL = this.getExpectedMain();
        if (emURL != null) {
            ai.setEMURL(emURL);
            ai.setEMVersion((String)ToolkitStore.get().getAppContext().get((Object)("deploy-" + emURL)));
        }
        ai.setAppArgs("##docbase:" + HttpUtils.removeQueryStringFromURL((URL)this.getDocumentBase()) + "##Parameters:" + this.getParametersString());
        ai.setAppModel(this.getAppModel());
        return ai;
    }

    @Override
    public void checkInvalidSandboxVmArgs() {
        String badArg = Config.findSecureSignedVmArg((String)this.getParameter("orig_java_arguments"));
        if (badArg != null) {
            String message = ResourceManager.getString((String)"deployment.blocked.secure.vmarg", (Object[])new Object[]{badArg});
            throw new SecurityException(message);
        }
    }

    private AppModel.SecurityMode getSecurityMode() {
        String param = this.getParameter("permissions");
        if ("all-permissions".equals(param)) {
            return AppModel.SecurityMode.ALL_PERMISSIONS;
        }
        if ("sandbox".equals(param)) {
            return AppModel.SecurityMode.SANDBOX;
        }
        return null;
    }

    private AppModel getAppModel() {
        AppModel appModel = new AppModel();
        appModel.setType(AppModel.Type.APPLET);
        appModel.setSecurityMode(this.getSecurityMode());
        appModel.setTitle(this.getTitle());
        appModel.setVendor(null);
        appModel.setDescription(null);
        appModel.setCodebase(this.getCodeBase());
        appModel.setLocation(this.getDocumentBase());
        appModel.setMainClass(this.getCode());
        for (URL jar : this.getAllJarURLs()) {
            if (jar == null) continue;
            appModel.addJarResource(jar, null);
        }
        return appModel;
    }

    private URL createJarURL(String jar, URL base) {
        try {
            return new URL(jar);
        }
        catch (MalformedURLException mue) {
            try {
                return new URL(base, jar);
            }
            catch (MalformedURLException e) {
                Trace.ignored((Throwable)e);
                return null;
            }
        }
    }

    private URL getExpectedMain() {
        if (this.expectedMainURL == null) {
            URL base = this.getCodeBase();
            String archive = this.getJarFiles();
            if (archive != null) {
                String[] jars = Applet2Manager.splitJarList(archive, false);
                if (jars.length > 0) {
                    this.expectedMainURL = this.createJarURL(jars[0], base);
                }
            } else {
                Object name = this.getCode();
                if (name != null) {
                    if (((String)name).endsWith(".class")) {
                        name = ((String)name).substring(0, ((String)name).lastIndexOf(46));
                    }
                    name = ((String)name).replace('.', '/') + ".class";
                    try {
                        this.expectedMainURL = new URL(base, (String)name);
                    }
                    catch (MalformedURLException e) {
                        Trace.ignored((Throwable)e);
                    }
                }
            }
            Trace.println((String)("Expected Main URL: " + this.expectedMainURL), (TraceLevel)TraceLevel.SECURITY);
        }
        return this.expectedMainURL;
    }

    private URL[] getAllJarURLs() {
        if (this.allJarURLs == null) {
            URL base = this.getCodeBase();
            String archive = this.getJarFiles();
            if (archive != null) {
                String[] jars = Applet2Manager.splitJarList(archive, false);
                if (jars.length > 0) {
                    this.allJarURLs = new URL[jars.length];
                    for (int i = 0; i < jars.length; ++i) {
                        this.allJarURLs[i] = this.createJarURL(jars[i], base);
                    }
                }
            } else {
                this.allJarURLs = new URL[0];
            }
        }
        return this.allJarURLs;
    }

    private String getParametersString() {
        AppletParameters orig = this.getAppletParameters();
        AppletParameters params = new AppletParameters();
        for (String internalParam : ParameterNames.internalParams) {
            params.remove((Object)internalParam);
        }
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder sb = new StringBuilder();
        for (Object key : keys) {
            sb.append(SystemUtils.encodeString((String)key)).append("=").append(SystemUtils.encodeString((String)("" + params.get(key)))).append(",");
        }
        return sb.toString();
    }

    public URL getMainLocation(Class cls) {
        URL mainLocation;
        CodeSource cs = cls.getProtectionDomain().getCodeSource();
        if (this.getJarFiles() != null) {
            mainLocation = cs.getLocation();
        } else {
            URL base = cs.getLocation();
            Object name = this.getCode();
            if (((String)name).endsWith(".class")) {
                name = ((String)name).substring(0, ((String)name).lastIndexOf(46));
            }
            name = ((String)name).replace('.', '/') + ".class";
            try {
                mainLocation = new URL(base, (String)name);
            }
            catch (MalformedURLException e) {
                Trace.ignored((Throwable)e);
                mainLocation = base;
            }
        }
        return mainLocation;
    }

    private static AppRef getHTMLAppRef(Applet2Manager manager, URL location) {
        return new AppRef(AppRef.Type.HTML, manager.getTitle(), manager.getDocumentBase(), null, (URL)null);
    }

    @Override
    public DeploymentRuleSet getMainDeploymentRuleSet(URL loc) {
        DeploymentRuleSet value = this._drsMap.get(loc.toString());
        if (value == null) {
            boolean isCodebase = URLUtil.sameURLs((URL)loc, (URL)this.getCodeBase());
            String jarVersion = (String)ToolkitStore.get().getAppContext().get((Object)("deploy-" + loc));
            CodeRef codeRef = new CodeRef(loc, jarVersion, isCodebase, false);
            AppRef appRef = Applet2Manager.getHTMLAppRef(this, loc);
            Trace.println((String)("Non-jnlp appRef: " + appRef), (TraceLevel)TraceLevel.RULESET);
            Trace.println((String)("Non-jnlp codeRef: " + codeRef), (TraceLevel)TraceLevel.RULESET);
            value = DeploymentRuleSet.findDRS((CodeInstance)new CodeInstance(appRef, codeRef));
            this._drsMap.put(loc.toString(), value);
            String version = value.getVersionString();
            if (version != null) {
                this.setParameter("__applet_request_version", version);
            }
        }
        if (this.mainAppletDeploymentRuleSet == null) {
            this.mainAppletDeploymentRuleSet = value;
        }
        return value;
    }

    @Override
    public DeploymentRuleSet getMainDeploymentRuleSet() {
        if (this.mainAppletDeploymentRuleSet != null) {
            return this.mainAppletDeploymentRuleSet;
        }
        return new BlockRule(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cleanupAppContext(long startTime, long timeout, StopListener stopListener) {
        Applet2ClassLoaderCache.Entry entry;
        Applet2ClassLoaderCache cache;
        AppContext ac;
        Applet2Manager applet2Manager = this;
        synchronized (applet2Manager) {
            ac = this.appletAppContext;
            this.appletAppContext = null;
            cache = this.classLoaderCache;
            this.classLoaderCache = null;
            entry = this.classLoaderCacheEntry;
            this.classLoaderCacheEntry = null;
        }
        long timeRemaining = timeout - (System.currentTimeMillis() - startTime);
        if (entry != null) {
            assert (cache != null);
            Applet2Manager applet2Manager2 = this;
            synchronized (applet2Manager2) {
                cache.release(entry, this, stopListener, timeRemaining);
            }
        } else {
            this.destroyAppContext(ac, stopListener, timeRemaining);
        }
    }

    @Override
    protected Plugin2ClassLoader newClassLoader() {
        URL codebase = this.getCodeBase();
        Applet2ClassLoader res = Applet2ClassLoader.newInstance(codebase);
        if (this.isForDummyApplet()) {
            res.setCodebaseLookup(false);
        }
        return res;
    }

    @Override
    protected synchronized void initJarVersionMap() {
        block12: {
            String[] jarNames;
            block11: {
                if (this.initializedJarVersionMap) {
                    return;
                }
                this.initializedJarVersionMap = true;
                int i = 1;
                String archive_tag_value = this.getParameter("archive_" + i);
                if (archive_tag_value == null) break block11;
                while (archive_tag_value != null) {
                    String[] jars = Applet2Manager.splitJarList(archive_tag_value, false);
                    String jarName = null;
                    String version = null;
                    boolean preloadJar = false;
                    for (String str : jars) {
                        if (jarName == null) {
                            jarName = str;
                            continue;
                        }
                        if ((str = str.toLowerCase()).startsWith(VERSION_TAG)) {
                            version = str.substring(VERSION_TAG.length());
                            continue;
                        }
                        if (!str.equals(PRELOAD)) continue;
                        preloadJar = true;
                    }
                    if (jarName != null) {
                        if (preloadJar) {
                            this.preloadJarMap.put(jarName, version);
                        }
                        this.jarVersionMap.put(jarName, version);
                        this.newStyleJarList.add(jarName);
                    }
                    archive_tag_value = this.getParameter("archive_" + ++i);
                }
                break block12;
            }
            String jpi_archive = this.getParameter("cache_archive");
            String jpi_version = this.getParameter("cache_version");
            String jpi_archive_ex = this.getParameter("cache_archive_ex");
            try {
                this.jarVersionMap = JarCacheUtil.getJarsWithVersion(jpi_archive, jpi_version, jpi_archive_ex);
            }
            catch (Exception ex) {
                Trace.printException((Throwable)ex, (String)ResourceManager.getString((String)"cache.error.text"), (String)ResourceManager.getString((String)"cache.error.caption"));
            }
            if (jpi_archive_ex == null) break block12;
            for (String jarName : jarNames = Applet2Manager.splitJarList(jpi_archive_ex, false)) {
                String[] nameAndOption = Applet2Manager.splitOptionString(jarName);
                if (nameAndOption.length <= 1 || nameAndOption[1] == null || !nameAndOption[1].toLowerCase().contains(PRELOAD)) continue;
                String ver = null;
                if (nameAndOption.length > 2) {
                    ver = nameAndOption[2];
                }
                this.preloadJarMap.put(nameAndOption[0], ver);
            }
        }
    }

    private void storeJarVersionMapInAppContext() {
        for (Map.Entry<String, String> entry : this.jarVersionMap.entrySet()) {
            String jarName = entry.getKey();
            String jarVersion = entry.getValue();
            URL url = null;
            try {
                url = new URL(this.getCodeBase(), jarName);
                if (!URLUtil.checkTargetURL((URL)this.getCodeBase(), (URL)url)) {
                    throw new SecurityException("Permission denied: " + url);
                }
            }
            catch (MalformedURLException mue) {
                Trace.ignoredException((Exception)mue);
            }
            if (url == null) continue;
            ToolkitStore.get().getAppContext().put((Object)("deploy-" + url), (Object)jarVersion);
            URL finalURL = DownloadEngine.getKnownRedirectFinalURL((URL)url);
            if (URLUtil.sameURLs((URL)finalURL, (URL)url)) continue;
            ToolkitStore.get().getAppContext().put((Object)("deploy-" + finalURL), (Object)jarVersion);
        }
    }

    @Override
    protected void setupAppletAppContext() {
        this.storeJarVersionMapInAppContext();
        super.setupAppletAppContext();
    }

    private void verifyFxIfNeeded() throws ExitException {
        String fxAsked = this.getParameter("javafx_version");
        if (fxAsked == null) {
            return;
        }
        if (ToolkitStore.setPreferredToolkit((ToolkitStore.ToolkitType)ToolkitStore.ToolkitType.FX_TOOLKIT)) {
            return;
        }
        throw new ExitException(ResourceManager.getString((String)"launch.error.jfx.unavailable", (Object[])new Object[]{fxAsked}), null, 3);
    }

    @Override
    protected void performDesktopIntegration() {
    }

    @Override
    protected void loadJarFiles() throws ExitException {
        int depth = ResourceProvider.get().incrementInternalUse();
        try {
            this._loadJarFiles();
        }
        finally {
            ResourceProvider.get().decrementInternalUse(depth);
        }
    }

    private void _loadJarFiles() throws ExitException {
        block7: {
            this.verifyFxIfNeeded();
            try {
                JarCacheUtil.preload(this.getCodeBase(), this.preloadJarMap);
            }
            catch (Exception ex) {
                Trace.printException((Throwable)ex, (String)ResourceManager.getString((String)"cache.error.text"), (String)ResourceManager.getString((String)"cache.error.caption"));
            }
            try {
                String[] jars;
                String archive = this.getJarFiles();
                Applet2ClassLoader cl = (Applet2ClassLoader)this.getAppletClassLoader();
                String fSep = File.separator;
                String appletDir = System.getProperty("java.home") + fSep + "lib" + fSep + "applet";
                this.loadLocalJarFiles(cl, appletDir);
                if (Config.getOSName().equalsIgnoreCase("Windows")) {
                    String untrustDir = Config.getSystemHome() + fSep + "Lib" + fSep + "Untrusted";
                    this.loadLocalJarFiles(cl, untrustDir);
                }
                if (archive == null) {
                    return;
                }
                for (String jar : jars = Applet2Manager.splitJarList(archive, false)) {
                    cl.addJar(jar);
                }
            }
            catch (Throwable t) {
                int exitValue;
                ExitException ee = t instanceof ExitException ? (ExitException)t : new ExitException(t, 3);
                int n = exitValue = ee.getReason() == 0 ? 0 : -1;
                if (exitValue == 0) break block7;
                throw ee;
            }
        }
    }

    protected void appletRelaunch(JREDesc newJre) throws JRESelectException {
        JVMParameters params = JVMParameters.getRunningJVMParameters();
        List untrustedJvmArgsList = params.getCommandLineArguments(null, false, false, false, true, false);
        String untrustedJvmArgs = ArgumentParsingUtil.encodeArgumentList((List)untrustedJvmArgsList);
        throw new JRESelectException(newJre, untrustedJvmArgs);
    }

    @Override
    protected void appletSSVRelaunch() throws JRESelectException {
        URL href = null;
        String version = this.getParameter("__applet_ssv_version");
        if (version != null && version.indexOf("_") > 0) {
            try {
                href = new URL(JREInfo.getHomeJRE().getLocation());
            }
            catch (MalformedURLException mue) {
                Trace.ignored((Throwable)mue);
            }
        }
        JREDesc newJre = new JREDesc(version, 0L, 0L, null, href, null, null);
        Trace.println((String)"AppletRelaunch due to SSV", (TraceLevel)TraceLevel.BASIC);
        this.appletRelaunch(newJre);
    }

    @Override
    protected void checkRunningJVMToolkitSatisfying() throws JRESelectException {
    }

    @Override
    protected void checkRunningJVMArgsSatisfying() throws JRESelectException {
        if (super.isAppletRelaunched()) {
            return;
        }
        JVMHealthData data = JVMHealthData.getCurrent();
        if (!data.isHealthy()) {
            if (DEBUG) {
                System.out.println("Relaunch due to unhealthy JVM: " + data);
            }
            Trace.println((String)"AppletRelaunch due to health", (TraceLevel)TraceLevel.BASIC);
            this.appletRelaunch(new JREDesc(null, 0L, 0L, null, null, null, null));
        }
    }

    private void loadLocalJarFiles(Applet2ClassLoader loader, String basePath) {
        File dir = new File(basePath);
        if (dir.exists()) {
            String[] jarList;
            for (String entry : jarList = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File f, String s) {
                    return s.endsWith(".jar");
                }
            })) {
                try {
                    URL localJarUrl = new File(basePath + File.separator + entry).toURI().toURL();
                    loader.addLocalJar(localJarUrl);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    protected String getJarFiles() {
        int idx;
        if (!this.newStyleJarList.isEmpty()) {
            return Applet2Manager.buildJarList(this.newStyleJarList.toArray(new String[0]));
        }
        String archive_ex = this.getParameter("cache_archive_ex");
        if (archive_ex != null && (idx = archive_ex.indexOf(";")) >= 0) {
            archive_ex = Applet2Manager.buildJarList(Applet2Manager.splitJarList(archive_ex, true));
        }
        String list = Applet2Manager.buildJarList(new String[]{archive_ex, this.getParameter("cache_archive"), this.getParameter("java_archive"), this.getParameter("archive")});
        if (DEBUG) {
            System.out.println("Applet2Manager.getJarFiles() for applet ID " + this.appletID + " Jar Files:" + list);
        }
        return list;
    }

    @Override
    protected String getCodeSourceLocations() {
        return this.getJarFiles();
    }

    private synchronized Applet2ClassLoaderCache.Entry getClassLoaderCacheEntry() {
        if (this.classLoaderCache == null) {
            return null;
        }
        if (this.classLoaderCacheEntry == null) {
            this.initJarVersionMap();
            this.verifyJarVersions();
            this.classLoaderCacheEntry = this.classLoaderCache.get(this.getClassLoaderCacheKey(), this);
            if (DEBUG) {
                System.out.println("Applet2Manager.getClassLoaderCacheEntry() for applet ID " + this.appletID + ": ClassLoader=" + Applet2Manager.objToString((Object)this.classLoaderCacheEntry.getClassLoader()) + ", ThreadGroup=" + Applet2Manager.objToString(this.classLoaderCacheEntry.getThreadGroup()) + ", AppContext=" + Applet2Manager.objToString(this.classLoaderCacheEntry.getAppContext()));
            }
        }
        return this.classLoaderCacheEntry;
    }

    @Override
    protected synchronized void invalidateClassLoaderCacheEntry() {
        if (this.classLoaderCache != null && this.classLoaderCacheEntry != null) {
            this.classLoaderCache.markNotCacheable(this.classLoaderCacheEntry);
        }
    }

    private static String objToString(Object obj) {
        return obj.getClass().getName() + "@~0x" + Integer.toHexString(System.identityHashCode(obj));
    }

    public static Applet2ClassLoaderCache.EntryCreator getCacheEntryCreator() {
        return new CacheEntryCreator();
    }

    private String getClassLoaderCacheKey() {
        if (this.classLoaderCacheKey == null) {
            String param = this.getParameter("classloader-policy");
            String permParam = this.getParameter("permissions");
            if (permParam == null && param != null && param.equals("classic")) {
                this.classLoaderCacheKey = this.getCodeBase().toString();
            } else {
                StringBuilder sb = new StringBuilder().append(this.getCodeBase());
                String jarFilesList = this.getJarFiles();
                if (jarFilesList != null) {
                    sb.append(",").append(jarFilesList);
                }
                if (permParam != null) {
                    sb.append(",").append(permParam);
                }
                this.classLoaderCacheKey = sb.toString();
            }
        }
        return this.classLoaderCacheKey;
    }

    private void verifyJarVersions() {
        assert (this.classLoaderCache != null);
        boolean markClassLoader = false;
        URL codeBase = this.getCodeBase();
        for (Map.Entry<String, String> entry : this.jarVersionMap.entrySet()) {
            String jarFileName = entry.getKey();
            String jarFileVersion = entry.getValue();
            try {
                String cacheVersion;
                URL url = new URL(codeBase, jarFileName);
                if (!URLUtil.checkTargetURL((URL)codeBase, (URL)url)) {
                    throw new SecurityException("Permission denied: " + url);
                }
                Trace.msgNetPrintln((String)"cache.version_checking", (Object[])new Object[]{jarFileName, jarFileVersion});
                if (jarFileVersion == null || (cacheVersion = ResourceProvider.get().getCurrentVersion(url)) == null || cacheVersion.compareTo(jarFileVersion) == 0) continue;
                markClassLoader = true;
                break;
            }
            catch (MalformedURLException e) {
                if (!DEBUG) continue;
                e.printStackTrace();
            }
        }
        if (markClassLoader) {
            this.classLoaderCache.markNotCacheable(this.getClassLoaderCacheKey());
        }
    }

    static class CacheEntryCreator
    implements Applet2ClassLoaderCache.EntryCreator {
        CacheEntryCreator() {
        }

        @Override
        public void createAll(Applet2Manager manager, Applet2ClassLoaderCache.Entry entry) {
            if (Plugin2Manager.DEBUG) {
                System.out.println("Applet2Manager executing createAll() for entry " + entry.getClassLoaderCacheKey());
            }
            entry.setClassLoader((Applet2ClassLoader)manager.getOrCreatePlugin2ClassLoader());
            entry.setThreadGroup(manager.getOrCreateAppletThreadGroup());
            entry.setAppContext(manager.getOrCreateAppletAppContext());
        }

        @Override
        public void createThreadGroupAndAppContext(Applet2Manager manager, Applet2ClassLoaderCache.Entry entry) {
            if (Plugin2Manager.DEBUG) {
                System.out.println("Applet2Manager executing createTGAndAC() for entry " + entry.getClassLoaderCacheKey());
            }
            manager.loader = entry.getClassLoader();
            if (manager.loader == null) {
                throw new InternalError("Error during bootstrapping of new ThreadGroup and AppContext");
            }
            entry.setThreadGroup(manager.getOrCreateAppletThreadGroup());
            entry.setAppContext(manager.getOrCreateAppletAppContext());
            Applet2ClassLoader loader = entry.getClassLoader();
            loader.setThreadGroup(entry.getThreadGroup());
            loader.setAppContext(entry.getAppContext());
        }

        @Override
        public void destroyThreadGroupAndAppContext(Applet2Manager manager, StopListener stopListener, long timeToWait, Applet2ClassLoaderCache.Entry entry) {
            if (Plugin2Manager.DEBUG) {
                System.out.println("Applet2Manager executing destroyTGAndAC() for entry " + entry.getClassLoaderCacheKey());
            }
            manager.destroyAppContext(entry.getAppContext(), stopListener, timeToWait);
            entry.setThreadGroup(null);
            entry.setAppContext(null);
            Applet2ClassLoader loader = entry.getClassLoader();
            loader.setThreadGroup(null);
            loader.setAppContext(null);
        }
    }
}

