/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.DeployUIManager;
import com.sun.deploy.util.SystemPropertyUtil;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JDialog;
import sun.plugin2.applet.Plugin2Manager;

public final class PluginSysUtil
extends DeploySysRun {
    private static ThreadGroup pluginThreadGroup = null;
    private static ClassLoader pluginSysClassLoader = null;
    private static final SysExecutionThreadCreator sysExecutionThreadCreator = new SysExecutionThreadCreator();

    public static synchronized ThreadGroup getPluginThreadGroup() {
        if (pluginThreadGroup == null) {
            pluginSysClassLoader = Thread.currentThread().getContextClassLoader();
            pluginThreadGroup = new ThreadGroup(Thread.currentThread().getThreadGroup(), "Plugin Thread Group");
            PluginSysUtil.createAppContext(pluginThreadGroup);
            try {
                Thread t = new Thread(pluginThreadGroup, new Runnable(){

                    @Override
                    public void run() {
                        DeployUIManager.setLookAndFeel();
                    }
                });
                t.start();
                t.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return pluginThreadGroup;
    }

    public static Thread createPluginSysThread(Runnable runner) {
        Thread t = new Thread(pluginThreadGroup, runner);
        t.setContextClassLoader(pluginSysClassLoader);
        return t;
    }

    public static Thread createPluginSysThread(Runnable runner, String name) {
        Thread t = new Thread(pluginThreadGroup, runner, name);
        t.setContextClassLoader(pluginSysClassLoader);
        return t;
    }

    protected Object delegate(DeploySysAction action) throws Exception {
        return PluginSysUtil.execute(action);
    }

    public static Object execute(DeploySysAction action) throws Exception {
        return PluginSysUtil.execute(action, PluginSysUtil.getDefaultSetup(), PluginSysUtil.getDefaultCleanup());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object execute(DeploySysAction action, Runnable setup, Runnable cleanup) throws Exception {
        boolean enableWorkaroundForAWT;
        if (pluginThreadGroup == null) {
            Trace.println((String)"ERROR:  pluginThreadGroup should not be null!");
            return null;
        }
        if (pluginThreadGroup.equals(Thread.currentThread().getThreadGroup())) {
            return action.execute();
        }
        final SysExecutionThread t = PluginSysUtil.sysExecutionThreadCreator.createThread(action, setup, cleanup);
        t.setContextClassLoader(pluginSysClassLoader);
        boolean bl = enableWorkaroundForAWT = ToolkitStore.isAWTToolkitRunning() && EventQueue.isDispatchThread();
        if (enableWorkaroundForAWT) {
            Object object = t.syncObject;
            synchronized (object) {
                DummyDialog dummy;
                t.theDummy = dummy = new DummyDialog(null, true);
                dummy.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                        t.start();
                    }

                    @Override
                    public void windowClosing(WindowEvent e) {
                        dummy.setVisible(false);
                    }
                });
                Rectangle rect = new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
                if (!PluginSysUtil.isOnWindows()) {
                    dummy.setLocation(rect.x + rect.width / 2 - 50, rect.y + rect.height / 2);
                } else {
                    dummy.setLocation(-100, -100);
                }
                dummy.setResizable(false);
                dummy.toBack();
                dummy.setVisible(true);
                while (!t.done) {
                    try {
                        t.syncObject.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                dummy.setVisible(false);
            }
        }
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (t.exception != null) {
            throw t.exception;
        }
        return t.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createAppContext(ThreadGroup tg) {
        AppContextCreatorThread t = new AppContextCreatorThread(tg);
        Object object = t.synObject;
        synchronized (object) {
            t.start();
            while (!t.done) {
                try {
                    t.synObject.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static boolean isOnWindows() {
        String osName = SystemPropertyUtil.getProperty((String)"os.name");
        return osName.indexOf("Windows") != -1;
    }

    private static Runnable getDefaultSetup() {
        final Plugin2Manager manager = Plugin2Manager.getCurrentManager();
        return new Runnable(){

            @Override
            public void run() {
                Plugin2Manager.setCurrentManagerThreadLocal(manager);
            }
        };
    }

    private static Runnable getDefaultCleanup() {
        return new Runnable(){

            @Override
            public void run() {
                Plugin2Manager.setCurrentManagerThreadLocal(null);
            }
        };
    }

    static {
        sysExecutionThreadCreator.start();
    }

    private static class SysExecutionThread
    extends Thread {
        Exception exception = null;
        Object result = null;
        final DeploySysAction action;
        final Runnable setup;
        final Runnable cleanup;
        final Object syncObject = new Object();
        volatile boolean done = false;
        DummyDialog theDummy = null;

        public SysExecutionThread(DeploySysAction action, Runnable setup, Runnable cleanup) {
            super(pluginThreadGroup, "SysExecutionThead");
            this.setDaemon(true);
            this.action = action;
            this.setup = setup;
            this.cleanup = cleanup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.setup != null) {
                    this.setup.run();
                }
                this.result = this.action.execute();
            }
            catch (Exception e) {
                this.exception = e;
            }
            finally {
                this.done = true;
                if (this.theDummy != null) {
                    this.theDummy.secureHide();
                }
                Object object = this.syncObject;
                synchronized (object) {
                    this.syncObject.notifyAll();
                }
                if (this.cleanup != null) {
                    this.cleanup.run();
                }
            }
        }
    }

    private static class SysExecutionThreadCreator
    extends Thread {
        final List<Request> requestQueue = new LinkedList<Request>();

        private SysExecutionThreadCreator() {
            super("SysExecutionTheadCreator");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SysExecutionThread createThread(DeploySysAction action, Runnable setup, Runnable cleanup) {
            Request r = new Request(action, setup, cleanup);
            SysExecutionThreadCreator sysExecutionThreadCreator = this;
            synchronized (sysExecutionThreadCreator) {
                this.requestQueue.add(r);
                this.notifyAll();
                while (r.getResult() == null) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException ie) {
                        Trace.ignoredException((Exception)ie);
                    }
                }
                return r.getResult();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                SysExecutionThreadCreator sysExecutionThreadCreator = this;
                synchronized (sysExecutionThreadCreator) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        Trace.ignoredException((Exception)ie);
                    }
                    while (!this.requestQueue.isEmpty()) {
                        Request r = this.requestQueue.remove(0);
                        r.setResult(new SysExecutionThread(r.deploySysAction, r.setup, r.cleanup));
                    }
                    this.notifyAll();
                }
            }
        }
    }

    private static class Request {
        private DeploySysAction deploySysAction = null;
        private SysExecutionThread sysExecutionThread = null;
        private Runnable setup;
        private Runnable cleanup;

        Request(DeploySysAction action, Runnable setup, Runnable cleanup) {
            this.deploySysAction = action;
            this.setup = setup;
            this.cleanup = cleanup;
        }

        void setResult(SysExecutionThread t) {
            this.sysExecutionThread = t;
        }

        SysExecutionThread getResult() {
            return this.sysExecutionThread;
        }
    }

    private static class AppContextCreatorThread
    extends Thread {
        final Object synObject = new Object();
        volatile boolean done = false;

        public AppContextCreatorThread(ThreadGroup tg) {
            super(tg, "AppContext Creator Thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ToolkitStore.get().createAppContext();
            }
            finally {
                this.done = true;
                Object object = this.synObject;
                synchronized (object) {
                    this.synObject.notifyAll();
                }
            }
        }
    }

    private static class DummyDialog
    extends JDialog {
        private static final long serialVersionUID = 2496751495115985790L;
        private ThreadGroup _unsecureGroup = Thread.currentThread().getThreadGroup();

        DummyDialog(Frame owner, boolean isModal) {
            super(owner, isModal);
        }

        public void secureHide() {
            new Thread(this._unsecureGroup, new Runnable(){

                @Override
                public void run() {
                    this.setVisible(false);
                }
            }).start();
        }
    }
}

