/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.javascript;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;

final class Trampoline {
    Trampoline() {
    }

    private static void validateDeclaringClass(Class<?> clazz) throws InvocationTargetException, IllegalAccessException {
        if (clazz.equals(AccessController.class) || clazz.getName().startsWith("java.lang.invoke.") || clazz.equals(Trampoline.class)) {
            throw new InvocationTargetException(new UnsupportedOperationException("invocation not supported"));
        }
    }

    private static Object invoke(Method m, Object obj, Object[] params) throws InvocationTargetException, IllegalAccessException {
        Object[] paramsCopy;
        Method method = m;
        Object[] p = paramsCopy = params == null ? null : Trampoline.deepCopy(params);
        if (obj instanceof Method) {
            Trampoline.validateDeclaringClass(((Method)obj).getDeclaringClass());
        }
        while (method.getDeclaringClass().equals(Method.class) && method.getName().equals("invoke") && p.length > 1 && p[0] instanceof Method && p[1] instanceof Object[]) {
            method = (Method)p[0];
            p = (Object[])p[1];
        }
        Trampoline.validateDeclaringClass(method.getDeclaringClass());
        return m.invoke(obj, paramsCopy);
    }

    private static Object[] deepCopy(Object[] p) {
        Object[] copy = (Object[])Array.newInstance(p.getClass().getComponentType(), p.length);
        for (int i = 0; i < p.length; ++i) {
            Object obj = p[i];
            copy[i] = obj instanceof Object[] ? Trampoline.deepCopy((Object[])obj) : obj;
        }
        return copy;
    }

    private static Object newInstance(Constructor<?> c, Object[] params) throws InstantiationException, InvocationTargetException, IllegalAccessException {
        Trampoline.validateDeclaringClass(c.getDeclaringClass());
        return c.newInstance(params);
    }

    static {
        if (Trampoline.class.getClassLoader() == null) {
            throw new Error("Trampoline must not be defined by the bootstrap classloader");
        }
    }
}

