/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Platform;
import com.sun.jnlp.FileContentsImpl;
import com.sun.jnlp.PersistenceServiceImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;

public final class PersistenceServiceNSBImpl
implements PersistenceService {
    private final PersistenceServiceImpl service;

    public PersistenceServiceNSBImpl(PersistenceServiceImpl service) {
        this.service = service;
    }

    public long create(URL url, long maxsize) throws MalformedURLException, IOException {
        return Platform.get().getNativeSandboxBroker().createMuffin(url.toExternalForm(), maxsize);
    }

    public FileContents get(URL url) throws MalformedURLException, IOException, FileNotFoundException {
        String fileName = Platform.get().getNativeSandboxBroker().getMuffin(url.toExternalForm());
        File f = new File(fileName);
        return new FileContentsImpl(f, this.service, url, this.service.getMaxLength(url));
    }

    public void delete(URL url) throws MalformedURLException, IOException {
        Platform.get().getNativeSandboxBroker().deleteMuffin(url.toExternalForm());
    }

    public String[] getNames(URL url) throws MalformedURLException, IOException {
        return this.service.getNames(url);
    }

    public int getTag(URL url) throws MalformedURLException, IOException {
        return this.service.getTag(url);
    }

    public void setTag(URL url, int tag) throws MalformedURLException, IOException {
        Platform.get().getNativeSandboxBroker().setMuffinTag(url.toExternalForm(), tag);
    }
}

