/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.nativesandbox.NativeSandboxJNLPService;
import com.sun.deploy.trace.Trace;
import com.sun.jnlp.ExtendedServiceImpl;
import com.sun.jnlp.FileOpenServiceImpl;
import com.sun.jnlp.FileSaveServiceImpl;
import com.sun.jnlp.PersistenceServiceImpl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jnlp.BasicService;
import javax.jnlp.IntegrationService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;

public class NativeSandboxJNLPServiceImpl
implements NativeSandboxJNLPService {
    public String openFileDialog(String pathHint, String[] extensions) {
        try {
            FileOpenServiceImpl service = (FileOpenServiceImpl)ServiceManager.lookup((String)"javax.jnlp.FileOpenService");
            return service.openFileDialogNSB(pathHint, extensions);
        }
        catch (IOException e) {
            Trace.ignoredException((Exception)e);
            return null;
        }
        catch (UnavailableServiceException e) {
            Trace.ignoredException((Exception)((Object)e));
            return null;
        }
    }

    public String[] openMultiFileDialog(String pathHint, String[] extensions) {
        try {
            FileOpenServiceImpl service = (FileOpenServiceImpl)ServiceManager.lookup((String)"javax.jnlp.FileOpenService");
            return service.openMultiFileDialogNSB(pathHint, extensions);
        }
        catch (IOException e) {
            Trace.ignoredException((Exception)e);
            return null;
        }
        catch (UnavailableServiceException e) {
            Trace.ignoredException((Exception)((Object)e));
            return null;
        }
    }

    public String saveFile(String pathHint, String[] extensions, String filename) {
        try {
            FileSaveServiceImpl service = (FileSaveServiceImpl)ServiceManager.lookup((String)"javax.jnlp.FileSaveService");
            return service.saveFileDialogNSB(pathHint, extensions, filename);
        }
        catch (IOException e) {
            Trace.ignoredException((Exception)e);
            return null;
        }
        catch (UnavailableServiceException e) {
            Trace.ignoredException((Exception)((Object)e));
            return null;
        }
    }

    public boolean openFile(String file) {
        try {
            ExtendedServiceImpl service = (ExtendedServiceImpl)ServiceManager.lookup((String)"javax.jnlp.ExtendedService");
            return service.openFile(file);
        }
        catch (UnavailableServiceException e) {
            Trace.ignoredException((Exception)((Object)e));
            return false;
        }
    }

    public boolean openFiles(String[] files) {
        try {
            ExtendedServiceImpl service = (ExtendedServiceImpl)ServiceManager.lookup((String)"javax.jnlp.ExtendedService");
            return service.openFiles(files);
        }
        catch (UnavailableServiceException e) {
            Trace.ignoredException((Exception)((Object)e));
            return false;
        }
    }

    public boolean removeAssociation(String mimetype, String[] extensions) {
        try {
            IntegrationService service = (IntegrationService)ServiceManager.lookup((String)"javax.jnlp.IntegrationService");
            return service.removeAssociation(mimetype, extensions);
        }
        catch (UnavailableServiceException e) {
            Trace.ignoredException((Exception)((Object)e));
            return false;
        }
    }

    public boolean removeShortcuts() {
        try {
            IntegrationService service = (IntegrationService)ServiceManager.lookup((String)"javax.jnlp.IntegrationService");
            return service.removeShortcuts();
        }
        catch (UnavailableServiceException e) {
            Trace.ignoredException((Exception)((Object)e));
            return false;
        }
    }

    public boolean requestAssociation(String mimetype, String[] extensions) {
        try {
            IntegrationService service = (IntegrationService)ServiceManager.lookup((String)"javax.jnlp.IntegrationService");
            return service.requestAssociation(mimetype, extensions);
        }
        catch (UnavailableServiceException e) {
            Trace.ignoredException((Exception)((Object)e));
            return false;
        }
    }

    public boolean requestShortcut(boolean desktop, boolean menu, String submenu) {
        try {
            IntegrationService service = (IntegrationService)ServiceManager.lookup((String)"javax.jnlp.IntegrationService");
            return service.requestShortcut(desktop, menu, submenu);
        }
        catch (UnavailableServiceException e) {
            Trace.ignoredException((Exception)((Object)e));
            return false;
        }
    }

    public long createMuffin(String url, long maxsize) throws IOException {
        try {
            PersistenceServiceImpl service = (PersistenceServiceImpl)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
            return service.create(new URL(url), maxsize);
        }
        catch (UnavailableServiceException e) {
            Trace.ignoredException((Exception)((Object)e));
            return -1L;
        }
    }

    public void deleteMuffin(String url) throws IOException {
        try {
            PersistenceServiceImpl service = (PersistenceServiceImpl)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
            service.delete(new URL(url));
        }
        catch (UnavailableServiceException e) {
            Trace.ignoredException((Exception)((Object)e));
        }
    }

    public String getMuffin(String url) throws IOException {
        try {
            PersistenceServiceImpl service = (PersistenceServiceImpl)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
            return service.get(url);
        }
        catch (UnavailableServiceException e) {
            Trace.ignoredException((Exception)((Object)e));
            return null;
        }
    }

    public void setMuffinTag(String url, int tag) throws IOException {
        try {
            PersistenceServiceImpl service = (PersistenceServiceImpl)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
            service.setTag(new URL(url), tag);
        }
        catch (UnavailableServiceException e) {
            Trace.ignoredException((Exception)((Object)e));
        }
    }

    public boolean showDocument(String url) {
        try {
            BasicService service = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            return service.showDocument(new URL(url));
        }
        catch (UnavailableServiceException e) {
            Trace.ignoredException((Exception)((Object)e));
            return false;
        }
        catch (MalformedURLException e) {
            Trace.ignoredException((Exception)e);
            return false;
        }
    }
}

