/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.Waiter;
import com.sun.jnlp.FileContentsImpl;
import com.sun.jnlp.FileOpenServiceImpl;
import com.sun.jnlp.FileSaveServiceImpl;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;

public final class FileOpenServiceNSBImpl
implements FileOpenService {
    private final FileOpenServiceImpl service;
    private static final AccessControlContext ACC_DIALOG_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions perms = new Permissions();
            ((PermissionCollection)perms).add(new FilePermission("<<ALL FILES>>", "read,write"));
            ((PermissionCollection)perms).add(new RuntimePermission("setContextClassLoader"));
            ((PermissionCollection)perms).add(new RuntimePermission("accessClassInPackage.com.apple.*"));
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        }
    });

    public FileOpenServiceNSBImpl(FileOpenServiceImpl service) {
        this.service = service;
    }

    public FileContents openFileDialog(final String pathHint, final String[] extensions) throws IOException {
        if (!this.service.askUser()) {
            return null;
        }
        Waiter.WaiterTask task = new Waiter.WaiterTask(){

            public Object run() throws Exception {
                return (FileContents)DeploySysRun.executePrivileged((DeploySysAction)new DeploySysAction(){

                    public Object execute() {
                        String filePath = Platform.get().getNativeSandboxBroker().openFileDialog(pathHint, extensions);
                        if (filePath == null) {
                            return null;
                        }
                        File file = new File(filePath);
                        if (file != null) {
                            try {
                                FileOpenServiceImpl._fileSaveServiceImpl.setLastPath(file.getPath());
                                return new FileContentsImpl(file, FileSaveServiceImpl.computeMaxLength(file.length()));
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return null;
                    }
                }, null, (AccessControlContext)ACC_DIALOG_INSTANCE);
            }
        };
        try {
            return (FileContents)Waiter.runAndWait((Waiter.WaiterTask)task);
        }
        catch (Exception ex) {
            Trace.ignored((Throwable)ex);
            return null;
        }
    }

    public FileContents[] openMultiFileDialog(final String pathHint, final String[] extensions) throws IOException {
        if (!this.service.askUser()) {
            return null;
        }
        Waiter.WaiterTask task = new Waiter.WaiterTask(){

            public Object run() throws Exception {
                return (FileContents[])DeploySysRun.executePrivileged((DeploySysAction)new DeploySysAction(){

                    public Object execute() {
                        String[] filePaths = Platform.get().getNativeSandboxBroker().openMultiFileDialog(pathHint, extensions);
                        if (filePaths == null) {
                            return null;
                        }
                        if (filePaths != null && filePaths.length > 0) {
                            FileContents[] fcontents = new FileContents[filePaths.length];
                            for (int i = 0; i < filePaths.length; ++i) {
                                try {
                                    File file = new File(filePaths[i]);
                                    fcontents[i] = new FileContentsImpl(file, FileSaveServiceImpl.computeMaxLength(file.length()));
                                    continue;
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            return fcontents;
                        }
                        return null;
                    }
                }, null, (AccessControlContext)ACC_DIALOG_INSTANCE);
            }
        };
        try {
            return (FileContents[])Waiter.runAndWait((Waiter.WaiterTask)task);
        }
        catch (Exception ex) {
            Trace.ignored((Throwable)ex);
            return null;
        }
    }
}

