/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Platform;
import com.sun.jnlp.JNLPRandomAccessFileImpl;
import com.sun.jnlp.JNLPRandomAccessFileNSBImpl;
import com.sun.jnlp.MeteredFileOutputStream;
import com.sun.jnlp.MeteredFileOutputStreamNSB;
import com.sun.jnlp.PersistenceServiceImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import javax.jnlp.FileContents;
import javax.jnlp.JNLPRandomAccessFile;

public final class FileContentsImpl
implements FileContents {
    private String _name = null;
    private File _file = null;
    private long _limit = Long.MAX_VALUE;
    private URL _url = null;
    private JNLPRandomAccessFile _raf = null;
    private PersistenceServiceImpl _psCallback = null;
    private static final AccessControlContext ACC_FILE_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions perms = new Permissions();
            FilePermission perm = new FilePermission("<<ALL FILES>>", "read,write");
            ((PermissionCollection)perms).add(perm);
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        }
    });

    FileContentsImpl(File file, long maxlength) throws IOException {
        this._file = file;
        this._limit = maxlength;
        this._name = this._file.getName();
    }

    FileContentsImpl(File file, PersistenceServiceImpl callback, URL url, long maxlength) {
        this._file = file;
        this._url = url;
        this._psCallback = callback;
        this._limit = maxlength;
        int index = url.getFile().lastIndexOf(47);
        this._name = index != -1 ? url.getFile().substring(index + 1) : url.getFile();
    }

    public String getName() {
        return this._name;
    }

    public long getLength() {
        Long ll = AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return FileContentsImpl.this._file.length();
            }
        }, ACC_FILE_INSTANCE);
        return ll;
    }

    public InputStream getInputStream() throws IOException {
        try {
            InputStream is = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    return new FileInputStream(FileContentsImpl.this._file);
                }
            }, ACC_FILE_INSTANCE);
            return is;
        }
        catch (PrivilegedActionException e) {
            throw this.rethrowException(e);
        }
    }

    public OutputStream getOutputStream(final boolean overwrite) throws IOException {
        try {
            OutputStream os = AccessController.doPrivileged(new PrivilegedExceptionAction<OutputStream>(){

                @Override
                public OutputStream run() throws IOException {
                    if (Platform.get().isNativeSandbox()) {
                        return new MeteredFileOutputStreamNSB(FileContentsImpl.this._file, !overwrite, FileContentsImpl.this);
                    }
                    return new MeteredFileOutputStream(FileContentsImpl.this._file, !overwrite, FileContentsImpl.this);
                }
            }, ACC_FILE_INSTANCE);
            return os;
        }
        catch (PrivilegedActionException e) {
            throw this.rethrowException(e);
        }
    }

    public boolean canRead() throws IOException {
        Boolean bb = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return FileContentsImpl.this._file.canRead();
            }
        }, ACC_FILE_INSTANCE);
        return bb;
    }

    public boolean canWrite() throws IOException {
        Boolean bb = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return FileContentsImpl.this.canWriteFile(FileContentsImpl.this._file);
            }
        }, ACC_FILE_INSTANCE);
        return bb;
    }

    private boolean canWriteFile(File file) {
        if (file.exists()) {
            return file.canWrite();
        }
        File dir = file.getParentFile();
        return dir != null && dir.exists() && dir.canWrite();
    }

    public JNLPRandomAccessFile getRandomAccessFile(final String mode) throws IOException {
        if (Platform.get().isNativeSandbox() && mode.equals("rw")) {
            return new JNLPRandomAccessFileNSBImpl(this._file, mode, this);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<JNLPRandomAccessFile>(){

                @Override
                public JNLPRandomAccessFile run() throws MalformedURLException, IOException {
                    return new JNLPRandomAccessFileImpl(FileContentsImpl.this._file, mode, FileContentsImpl.this);
                }
            }, ACC_FILE_INSTANCE);
        }
        catch (PrivilegedActionException e) {
            throw this.rethrowException(e);
        }
    }

    public long getMaxLength() throws IOException {
        return this._limit;
    }

    public long setMaxLength(long limit) throws IOException {
        if (this._psCallback != null) {
            this._limit = this._psCallback.setMaxLength(this._url, limit);
            return this._limit;
        }
        this._limit = limit;
        return this._limit;
    }

    private IOException rethrowException(PrivilegedActionException e) throws IOException {
        Exception ee = e.getException();
        if (ee instanceof IOException) {
            throw new IOException("IOException from FileContents");
        }
        if (ee instanceof RuntimeException) {
            throw (RuntimeException)ee;
        }
        throw new IOException(ee.getMessage());
    }
}

