/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.xdg;

import com.sun.deploy.Environment;
import com.sun.deploy.association.Association;
import com.sun.deploy.association.AssociationAlreadyRegisteredException;
import com.sun.deploy.association.AssociationNotRegisteredException;
import com.sun.deploy.association.AssociationService;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.association.utility.DesktopEntry;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.xdg.Associations;
import com.sun.deploy.xdg.BaseDir;
import com.sun.javaws.UnixInstallHandler;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import com.sun.javaws.xdg.Menu;
import com.sun.javaws.xdg.MenuDatabase;
import com.sun.javaws.xdg.UserDirs;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class XDGInstallHandler
extends UnixInstallHandler {
    private static final String ACTION_COMMAND = "command";

    @Override
    public boolean isLocalInstallSupported() {
        return true;
    }

    @Override
    public boolean isAssociationSupported() {
        return true;
    }

    @Override
    protected boolean desktopEntryExists(String path) {
        File file = this.getDesktopEntryFile(path);
        return file != null ? file.exists() : false;
    }

    @Override
    protected String writeDesktopEntry(DesktopEntry entry, String name, Association assoc, int level) {
        File f = null;
        if (assoc != null) {
            f = Associations.getDesktopEntryFile((Association)assoc, (int)level);
        } else {
            UserDirs ud = UserDirs.getInstance();
            String desktopDir = ud.getDesktopDir();
            f = new File(desktopDir, name);
        }
        boolean ok = this.writeDesktopFile(entry, f, true);
        return ok ? "desktop:" + name : null;
    }

    private boolean writeDesktopFile(DesktopEntry e, File f, boolean exec) {
        boolean success;
        Trace.println((String)("Writing desktop file to: " + f), (TraceLevel)TraceLevel.UI);
        try {
            f.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(f);
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            BufferedWriter bw = new BufferedWriter(osw);
            bw.write(e.toString());
            bw.close();
            if (exec) {
                f.setExecutable(true);
            }
            success = true;
        }
        catch (IOException ex) {
            Trace.ignored((Throwable)ex);
            success = false;
        }
        return success;
    }

    @Override
    protected String writeMenuEntry(DesktopEntry entry, String menuEntryPath, String name) {
        String resultPath;
        String appsDir = this.getAppsDir();
        new File(appsDir).mkdirs();
        File f = new File(appsDir, name);
        boolean ok = this.writeDesktopFile(entry, f, false);
        if (ok) {
            MenuDatabase mdb = MenuDatabase.getInstance();
            Menu menu = mdb.addMenu(menuEntryPath);
            if (menuEntryPath == null) {
                menuEntryPath = "";
            }
            menu.addEntry(name);
            try {
                mdb.save();
            }
            catch (IOException ex) {
                Trace.ignored((Throwable)ex);
                Object var7_10 = null;
            }
            resultPath = "menu:" + menuEntryPath + ":" + name;
        } else {
            resultPath = null;
        }
        return resultPath;
    }

    protected File getDesktopEntryFile(String path) {
        File file = null;
        int idx = path.indexOf(58);
        if (idx == -1) {
            return null;
        }
        String type = path.substring(0, idx);
        if (type.equals("desktop")) {
            String name = path.substring(idx + 1, path.length());
            UserDirs ud = UserDirs.getInstance();
            file = new File(ud.getDesktopDir(), name);
        } else if (type.equals("menu")) {
            String subPath = path.substring(idx + 1, path.length());
            if ((idx = subPath.indexOf(58)) == -1) {
                return null;
            }
            String desktopFilename = subPath.substring(idx + 1, subPath.length());
            file = new File(this.getAppsDir(), desktopFilename);
        }
        return file;
    }

    @Override
    protected boolean removeDesktopPath(String path) {
        int idx = path.indexOf(58);
        if (idx == -1) {
            return false;
        }
        String type = path.substring(0, idx);
        boolean ok = false;
        if (type.equals("desktop")) {
            File file = this.getDesktopEntryFile(path);
            if (file != null && file.delete()) {
                ok = true;
            }
        } else if (type.equals("menu")) {
            String subPath = path.substring(idx + 1, path.length());
            if ((idx = subPath.indexOf(58)) == -1) {
                return false;
            }
            String menuPath = subPath.substring(0, idx);
            String desktopFilename = subPath.substring(idx + 1, subPath.length());
            String appsDir = this.getAppsDir();
            File f = new File(appsDir, desktopFilename);
            f.delete();
            MenuDatabase mdb = MenuDatabase.getInstance();
            Menu menu = mdb.getMenu(menuPath);
            if (menu != null) {
                menu.removeEntry(desktopFilename);
            }
            try {
                mdb.save();
                ok = true;
            }
            catch (IOException ex) {
                Trace.ignored((Throwable)ex);
                ok = false;
            }
        } else {
            ok = false;
        }
        return ok;
    }

    @Override
    protected boolean removeDirectory(String directoryFilePath) {
        return true;
    }

    private String getAppsDir() {
        BaseDir bd = BaseDir.getInstance();
        String appsDir = bd.getUserDataDir() + File.separatorChar + "applications";
        return appsDir;
    }

    @Override
    protected String getMenuEntryDirPath(LaunchDesc ld, boolean allUsers) {
        InformationDesc iDesc = ld.getInformation();
        ShortcutDesc sd = iDesc.getShortcut();
        String submenu = null;
        if (sd != null) {
            submenu = this.dirFilter(sd.getSubmenu());
        }
        return submenu;
    }

    @Override
    public String getAssociationPrintCommand(String jnlpLocation) {
        return ACTION_COMMAND;
    }

    @Override
    public String getAssociationOpenCommand(String jnlpLocation) {
        return ACTION_COMMAND;
    }

    @Override
    public void registerAssociationInternal(LaunchDesc ld, LocalApplicationProperties lap, Association assoc) throws AssociationAlreadyRegisteredException, RegisterFailedException {
        int level;
        AssociationService assocService = new AssociationService(lap);
        int n = level = Environment.isSystemCacheMode() ? 2 : 1;
        if (!this.createShortcuts(ld, lap, new boolean[]{false, false}, assoc, level)) {
            throw new RegisterFailedException();
        }
        super.registerAssociationInternal(ld, lap, assoc);
    }

    @Override
    public void unregisterAssociationInternal(LaunchDesc ld, LocalApplicationProperties lap, Association assoc) throws AssociationNotRegisteredException, RegisterFailedException {
        int level = Environment.isSystemCacheMode() ? 2 : 1;
        File desktopFile = Associations.getDesktopEntryFile((Association)assoc, (int)level);
        if (!desktopFile.exists()) {
            Trace.print((String)("desktop entry file doesn't exist, path == " + desktopFile.getAbsolutePath()), (TraceLevel)TraceLevel.TEMP);
        } else {
            desktopFile.delete();
        }
        super.unregisterAssociationInternal(ld, lap, assoc);
    }
}

