/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.xdg;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.xdg.BaseDir;
import com.sun.deploy.xml.XMLNode;
import com.sun.deploy.xml.XMLParser;
import com.sun.javaws.xdg.Menu;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.xml.sax.SAXException;

final class MenuDatabase {
    private static final String DEFAULT_JWS_MENU_NAME = "Java WebStart";
    private static MenuDatabase instance;
    private Menu rootMenu;

    static synchronized MenuDatabase getInstance() {
        if (instance == null) {
            instance = new MenuDatabase();
        }
        return instance;
    }

    MenuDatabase() {
        this.load();
    }

    private File getMenuFile() {
        BaseDir bd = BaseDir.getInstance();
        String menuFile = bd.getUserConfigDir() + File.separatorChar + "menus" + File.separator + "applications-merged" + File.separator + "javaws.menu";
        return new File(menuFile);
    }

    void load() {
        File menuFile = this.getMenuFile();
        try {
            FileInputStream fis = new FileInputStream(menuFile);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            StringBuffer xmlFile = new StringBuffer();
            String line = br.readLine();
            while (line != null) {
                xmlFile.append(line);
                line = br.readLine();
            }
            br.close();
            XMLParser xmlParser = new XMLParser(xmlFile.toString());
            XMLNode xmlNode = xmlParser.parse();
            this.rootMenu = new Menu();
            this.rootMenu.read(xmlNode);
        }
        catch (FileNotFoundException ex) {
            this.rootMenu = new Menu("Applications", null);
            Menu menu = new Menu(DEFAULT_JWS_MENU_NAME, this.rootMenu);
        }
        catch (IOException ex) {
            Trace.ignored((Throwable)ex);
        }
        catch (SAXException ex) {
            Trace.ignored((Throwable)ex);
        }
    }

    void save() throws IOException {
        File menuFile = this.getMenuFile();
        if (menuFile.getParentFile() != null) {
            menuFile.getParentFile().mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(menuFile);
        OutputStreamWriter osw = new OutputStreamWriter(fos);
        BufferedWriter bw = new BufferedWriter(osw);
        this.rootMenu.write(bw);
        bw.close();
    }

    private Menu getJavaWSMenu() {
        return this.rootMenu.getSubMenu(DEFAULT_JWS_MENU_NAME);
    }

    static boolean isJavaWSMenu(Menu menu) {
        return DEFAULT_JWS_MENU_NAME.equals(menu.getName());
    }

    Menu addMenu(String menuPath) {
        return this.getJavaWSMenu().addMenuPath(menuPath);
    }

    Menu getMenu(String menuPath) {
        return this.getJavaWSMenu().getMenuPath(menuPath);
    }
}

